/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.policies;

import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javafx.scene.Node;
import org.eclipse.gef.mvc.fx.operations.AbstractCompositeOperation;
import org.eclipse.gef.mvc.fx.operations.ChangeContentsOperation;
import org.eclipse.gef.mvc.fx.operations.ChangeFocusOperation;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.operations.ReverseUndoCompositeOperation;
import org.eclipse.gef.mvc.fx.operations.SelectOperation;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IContentPartFactory;
import org.eclipse.gef.mvc.fx.parts.IRootPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.policies.AbstractTransactionPolicy;
import org.eclipse.gef.mvc.fx.policies.ContentPolicy;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class CreationPolicy
extends AbstractTransactionPolicy {
    public IContentPart<? extends Node> create(Object content, IVisualPart<? extends Node> parent, int index, SetMultimap<IContentPart<? extends Node>, String> anchoreds, boolean doFocus, boolean doSelect) {
        ITransactionalOperation selectOperation;
        ITransactionalOperation focusOperation;
        this.checkInitialized();
        if (content == null) {
            throw new IllegalArgumentException("The given content may not be null.");
        }
        if (parent == null) {
            throw new IllegalArgumentException("The given parent may not be null.");
        }
        if (anchoreds == null) {
            throw new IllegalArgumentException("The given anchored parts may not be null");
        }
        IViewer viewer = this.getHost().getRoot().getViewer();
        if (parent instanceof IRootPart) {
            ChangeContentsOperation changeContentsOperation = new ChangeContentsOperation(viewer);
            ArrayList<Object> newContents = new ArrayList<Object>((Collection<Object>)viewer.getContents());
            newContents.add(index, content);
            changeContentsOperation.setNewContents(newContents);
            this.getCompositeOperation().add(changeContentsOperation);
        } else {
            ContentPolicy parentContentPolicy = (ContentPolicy)parent.getAdapter(ContentPolicy.class);
            if (parentContentPolicy == null) {
                throw new IllegalStateException("No ContentPolicy registered for <" + parent + ">.");
            }
            parentContentPolicy.init();
            parentContentPolicy.addContentChild(content, index);
            ITransactionalOperation addToParentOperation = parentContentPolicy.commit();
            if (addToParentOperation != null) {
                this.getCompositeOperation().add(addToParentOperation);
            }
        }
        for (IContentPart anchored : anchoreds.keys()) {
            ContentPolicy anchoredPolicy = (ContentPolicy)anchored.getAdapter(ContentPolicy.class);
            if (anchoredPolicy == null) {
                throw new IllegalStateException("No ContentPolicy registered for <" + anchored + ">.");
            }
            anchoredPolicy.init();
            for (String role : anchoreds.get((Object)anchored)) {
                anchoredPolicy.attachToContentAnchorage(content, role);
            }
            ITransactionalOperation attachToAnchorageOperation = anchoredPolicy.commit();
            if (attachToAnchorageOperation == null) continue;
            this.getCompositeOperation().add(attachToAnchorageOperation);
        }
        this.locallyExecuteOperation();
        IContentPart<? extends Node> contentPart = viewer.getContentPartMap().get(content);
        if (doFocus && (focusOperation = this.createFocusOperation(contentPart)) != null) {
            this.getCompositeOperation().add(focusOperation);
        }
        if (doSelect && (selectOperation = this.createSelectOperation(contentPart)) != null) {
            this.getCompositeOperation().add(selectOperation);
        }
        return contentPart;
    }

    public IContentPart<? extends Node> create(Object content, IVisualPart<? extends Node> parent, SetMultimap<IContentPart<? extends Node>, String> anchoreds) {
        int index = parent instanceof IRootPart ? this.getHost().getRoot().getViewer().getContents().size() : ((IContentPart)parent).getContentChildrenUnmodifiable().size();
        return this.create(content, parent, index, anchoreds, true, true);
    }

    protected ITransactionalOperation createFocusOperation(IContentPart<? extends Node> part) {
        return new ChangeFocusOperation(part.getRoot().getViewer(), part);
    }

    @Override
    protected ITransactionalOperation createOperation() {
        return new ReverseUndoCompositeOperation("Create Content");
    }

    protected ITransactionalOperation createSelectOperation(IContentPart<? extends Node> part) {
        return new SelectOperation(part.getRoot().getViewer(), Collections.singletonList(part));
    }

    protected AbstractCompositeOperation getCompositeOperation() {
        return (AbstractCompositeOperation)this.getOperation();
    }

    protected IContentPartFactory getContentPartFactory() {
        IViewer viewer = this.getHost().getRoot().getViewer();
        IContentPartFactory cpFactory = (IContentPartFactory)viewer.getAdapter(IContentPartFactory.class);
        return cpFactory;
    }
}

