/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.policies;

import javafx.scene.Cursor;
import javafx.scene.Scene;
import org.eclipse.gef.mvc.fx.policies.IPolicy;

public class CursorSupport {
    private IPolicy hostPolicy;
    private Cursor originalCursor;
    private boolean isCursorChanged = false;

    public CursorSupport(IPolicy hostPolicy) {
        this.hostPolicy = hostPolicy;
    }

    public Cursor getOriginalCursor() {
        return this.originalCursor;
    }

    public boolean isCursorChanged() {
        return this.isCursorChanged;
    }

    public void restoreCursor() {
        if (this.isCursorChanged) {
            this.setCursor(this.originalCursor);
            this.isCursorChanged = false;
        }
    }

    public void setCursor(Cursor cursor) {
        Scene scene = this.hostPolicy.getHost().getVisual().getScene();
        if (cursor != scene.getCursor()) {
            scene.setCursor(cursor);
        }
    }

    public void storeAndReplaceCursor(Cursor cursor) {
        if (!this.isCursorChanged) {
            this.originalCursor = this.hostPolicy.getHost().getVisual().getScene().getCursor();
            this.isCursorChanged = true;
        }
        this.setCursor(cursor);
    }
}

