/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.policies;

import java.util.ArrayList;
import java.util.Collection;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.eclipse.gef.mvc.fx.models.SelectionModel;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.policies.AbstractInteractionPolicy;
import org.eclipse.gef.mvc.fx.policies.DeletionPolicy;
import org.eclipse.gef.mvc.fx.policies.IOnStrokePolicy;
import org.eclipse.gef.mvc.fx.tools.ClickDragTool;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class DeleteSelectedOnTypePolicy
extends AbstractInteractionPolicy
implements IOnStrokePolicy {
    @Override
    public void abortPress() {
    }

    @Override
    public void finalRelease(KeyEvent event) {
    }

    @Override
    public void initialPress(KeyEvent event) {
        if (!this.isDelete(event)) {
            return;
        }
        IViewer viewer = this.getHost().getRoot().getViewer();
        ArrayList<IContentPart<? extends Node>> selected = new ArrayList<IContentPart<? extends Node>>((Collection<IContentPart<? extends Node>>)((SelectionModel)viewer.getAdapter(SelectionModel.class)).getSelectionUnmodifiable());
        if (selected.isEmpty()) {
            return;
        }
        DeletionPolicy deletionPolicy = (DeletionPolicy)this.getHost().getRoot().getAdapter(DeletionPolicy.class);
        this.init(deletionPolicy);
        for (IContentPart iContentPart : selected) {
            deletionPolicy.delete(iContentPart);
        }
        this.commit(deletionPolicy);
    }

    protected boolean isDelete(KeyEvent event) {
        if (event.getCode() != KeyCode.DELETE) {
            return false;
        }
        ClickDragTool tool = (ClickDragTool)this.getHost().getRoot().getViewer().getDomain().getAdapter(ClickDragTool.class);
        return tool == null || !this.getHost().getRoot().getViewer().getDomain().isExecutionTransactionOpen(tool);
    }

    @Override
    public void press(KeyEvent event) {
    }

    @Override
    public void release(KeyEvent event) {
    }
}

