/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.policies;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import javafx.scene.Node;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.mvc.fx.models.SelectionModel;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.policies.AbstractInteractionPolicy;
import org.eclipse.gef.mvc.fx.policies.AbstractTransactionPolicy;
import org.eclipse.gef.mvc.fx.policies.BendConnectionPolicy;
import org.eclipse.gef.mvc.fx.policies.IOnDragPolicy;

public class NormalizeConnectedOnDragPolicy
extends AbstractInteractionPolicy
implements IOnDragPolicy {
    private Set<IVisualPart<? extends Node>> targetParts;
    private boolean invalidGesture = false;

    @Override
    public void abortDrag() {
        if (this.invalidGesture) {
            return;
        }
        for (IVisualPart<? extends Node> part : this.targetParts) {
            this.rollback((AbstractTransactionPolicy)part.getAdapter(BendConnectionPolicy.class));
            this.restoreRefreshVisuals(part);
        }
        this.targetParts = null;
    }

    protected Set<IVisualPart<? extends Node>> determineTargetParts() {
        Set<IVisualPart<? extends Node>> targetParts = Collections.newSetFromMap(new IdentityHashMap());
        for (IVisualPart anchored : this.getHost().getAnchoredsUnmodifiable()) {
            BendConnectionPolicy bendConnectionPolicy;
            if (!(anchored instanceof IContentPart) || (bendConnectionPolicy = (BendConnectionPolicy)anchored.getAdapter(BendConnectionPolicy.class)) == null || targetParts.contains(anchored)) continue;
            targetParts.add(anchored);
        }
        SelectionModel selectionModel = (SelectionModel)this.getHost().getRoot().getViewer().getAdapter(SelectionModel.class);
        Iterator it = targetParts.iterator();
        while (it.hasNext()) {
            IVisualPart part = (IVisualPart)it.next();
            if (!(part instanceof IContentPart) || !selectionModel.isSelected((IContentPart)part)) continue;
            it.remove();
        }
        return targetParts;
    }

    @Override
    public void drag(MouseEvent e, Dimension delta) {
        if (this.invalidGesture) {
            return;
        }
        for (IVisualPart<? extends Node> part : this.targetParts) {
            ((BendConnectionPolicy)part.getAdapter(BendConnectionPolicy.class)).normalize();
        }
    }

    @Override
    public void endDrag(MouseEvent e, Dimension delta) {
        if (this.invalidGesture) {
            return;
        }
        for (IVisualPart<? extends Node> part : this.targetParts) {
            this.commit((AbstractTransactionPolicy)part.getAdapter(BendConnectionPolicy.class));
            this.restoreRefreshVisuals(part);
        }
        this.targetParts = null;
    }

    @Override
    public void hideIndicationCursor() {
    }

    protected boolean isNormalize(MouseEvent event) {
        return !this.targetParts.isEmpty();
    }

    @Override
    public boolean showIndicationCursor(KeyEvent event) {
        return false;
    }

    @Override
    public boolean showIndicationCursor(MouseEvent event) {
        return false;
    }

    @Override
    public void startDrag(MouseEvent e) {
        this.targetParts = this.determineTargetParts();
        boolean bl = this.invalidGesture = !this.isNormalize(e);
        if (this.invalidGesture) {
            return;
        }
        for (IVisualPart<? extends Node> part : this.targetParts) {
            this.storeAndDisableRefreshVisuals(part);
            this.init((AbstractTransactionPolicy)part.getAdapter(BendConnectionPolicy.class));
        }
    }
}

