/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.policies;

import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.input.ScrollEvent;
import org.eclipse.gef.fx.nodes.InfiniteCanvas;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.mvc.fx.policies.AbstractInteractionPolicy;
import org.eclipse.gef.mvc.fx.policies.IOnScrollPolicy;
import org.eclipse.gef.mvc.fx.policies.PanningSupport;
import org.eclipse.gef.mvc.fx.policies.ViewportPolicy;

public class PanOrZoomOnScrollPolicy
extends AbstractInteractionPolicy
implements IOnScrollPolicy {
    private PanningSupport panningSupport = new PanningSupport();
    private ViewportPolicy viewportPolicy;

    @Override
    public void abortScroll() {
        this.rollback(this.viewportPolicy);
        this.viewportPolicy = null;
    }

    protected Dimension computePanTranslation(ScrollEvent event) {
        double dx = event.getDeltaX();
        double dy = event.getDeltaY();
        if (this.isPanDirectionSwapped(event)) {
            double t = dx;
            dx = dy;
            dy = t;
        }
        return new Dimension(dx, dy);
    }

    protected double computeZoomFactor(ScrollEvent event) {
        return event.getDeltaY() > 0.0 ? 1.05 : 0.9523809523809523;
    }

    protected ViewportPolicy determineViewportPolicy() {
        return (ViewportPolicy)this.getHost().getRoot().getAdapter(ViewportPolicy.class);
    }

    @Override
    public void endScroll() {
        this.commit(this.viewportPolicy);
        this.viewportPolicy = null;
    }

    protected final ViewportPolicy getViewportPolicy() {
        return this.viewportPolicy;
    }

    protected boolean isContentRestricted() {
        return false;
    }

    protected boolean isPan(ScrollEvent event) {
        return !event.isAltDown() && !event.isControlDown() && !event.isMetaDown();
    }

    protected boolean isPanDirectionSwapped(ScrollEvent event) {
        return event.isShiftDown();
    }

    protected boolean isZoom(ScrollEvent event) {
        return event.isControlDown() || event.isAltDown();
    }

    protected void pan(ScrollEvent event) {
        Dimension delta = this.computePanTranslation(event);
        this.viewportPolicy.scroll(true, delta.width, delta.height);
        if (this.isContentRestricted()) {
            this.panningSupport.removeFreeSpace(this.viewportPolicy, Pos.TOP_LEFT, true);
            this.panningSupport.removeFreeSpace(this.viewportPolicy, Pos.BOTTOM_RIGHT, false);
        }
    }

    @Override
    public void scroll(ScrollEvent event) {
        if (this.isPan(event)) {
            this.pan(event);
        } else if (this.isZoom(event)) {
            this.zoom(event);
        }
    }

    @Override
    public void startScroll(ScrollEvent event) {
        this.viewportPolicy = this.determineViewportPolicy();
        this.init(this.viewportPolicy);
        this.scroll(event);
    }

    protected void zoom(ScrollEvent event) {
        double zoomFactor = this.computeZoomFactor(event);
        if (this.isContentRestricted()) {
            this.panningSupport.removeFreeSpace(this.viewportPolicy, Pos.TOP_LEFT, true);
            InfiniteCanvas infiniteCanvas = (InfiniteCanvas)this.getHost().getRoot().getViewer().getCanvas();
            Point2D pivotPointInScene = infiniteCanvas.localToScene(infiniteCanvas.getContentBounds().getMinX(), 0.0);
            this.viewportPolicy.zoom(true, true, zoomFactor, pivotPointInScene.getX(), pivotPointInScene.getY());
            this.panningSupport.removeFreeSpace(this.viewportPolicy, Pos.BOTTOM_RIGHT, false);
        } else {
            this.viewportPolicy.zoom(true, true, zoomFactor, event.getSceneX(), event.getSceneY());
        }
    }
}

