/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.policies;

import javafx.scene.Node;
import javafx.scene.layout.Region;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.mvc.fx.operations.ForwardUndoCompositeOperation;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.operations.ResizeContentOperation;
import org.eclipse.gef.mvc.fx.operations.ResizeOperation;
import org.eclipse.gef.mvc.fx.parts.IResizableContentPart;
import org.eclipse.gef.mvc.fx.policies.AbstractTransactionPolicy;

public class ResizePolicy
extends AbstractTransactionPolicy {
    private Dimension initialSize;

    protected void applySize(double dw, double dh) {
        this.updateResizeOperation(dw, dh);
        this.locallyExecuteOperation();
    }

    @Override
    public ITransactionalOperation commit() {
        ITransactionalOperation commitOperation = super.commit();
        if (commitOperation != null && !commitOperation.isNoOp() && this.isContentResizable()) {
            ForwardUndoCompositeOperation composite = new ForwardUndoCompositeOperation("Resize Content");
            composite.add(commitOperation);
            composite.add(this.createResizeContentOperation());
            commitOperation = composite;
        }
        this.initialSize = null;
        return commitOperation;
    }

    protected Dimension computeApplicableDelta(double dw, double dh) {
        double layoutDh;
        Node visual = this.getVisualToResize();
        boolean resizable = visual.isResizable();
        resizable = true;
        double layoutDw = resizable ? dw : 0.0;
        double d = layoutDh = resizable ? dh : 0.0;
        if (resizable && (layoutDw != 0.0 || layoutDh != 0.0)) {
            double minimumWidth = this.getMinimumWidth();
            double minimumHeight = this.getMinimumHeight();
            ResizeOperation resizeOperation = this.getResizeOperation();
            if (resizeOperation.getInitialSize().width + layoutDw < minimumWidth) {
                layoutDw = minimumWidth - resizeOperation.getInitialSize().width;
            }
            if (resizeOperation.getInitialSize().height + layoutDh < minimumHeight) {
                layoutDh = minimumHeight - resizeOperation.getInitialSize().height;
            }
        }
        Dimension applicable = new Dimension(layoutDw, layoutDh);
        return applicable;
    }

    @Override
    protected ITransactionalOperation createOperation() {
        return new ResizeOperation("Resize", (IResizableContentPart<? extends Node>)this.getHost(), this.getCurrentSize(), 0.0, 0.0);
    }

    protected ITransactionalOperation createResizeContentOperation() {
        ResizeContentOperation resizeOperation = new ResizeContentOperation((IResizableContentPart<? extends Node>)this.getHost(), this.getInitialSize(), this.getCurrentSize());
        return resizeOperation;
    }

    protected Dimension getCurrentSize() {
        return this.getHost().getVisualSize();
    }

    public double getDeltaHeight() {
        return this.getResizeOperation().getDh();
    }

    public double getDeltaWidth() {
        return this.getResizeOperation().getDw();
    }

    public IResizableContentPart<? extends Node> getHost() {
        return (IResizableContentPart)super.getHost();
    }

    protected Dimension getInitialSize() {
        return this.initialSize;
    }

    protected double getMinimumHeight() {
        Node visualToResize = this.getVisualToResize();
        double computedMinHeight = -1.0;
        if (visualToResize instanceof Region) {
            computedMinHeight = ((Region)visualToResize).getMinHeight();
        } else if (visualToResize.isResizable()) {
            computedMinHeight = visualToResize.minHeight(-1.0);
        }
        return Math.max(computedMinHeight, 4.0);
    }

    protected double getMinimumWidth() {
        Node visualToResize = this.getVisualToResize();
        double computedMinWidth = -1.0;
        if (visualToResize instanceof Region) {
            computedMinWidth = ((Region)visualToResize).getMinWidth();
        } else if (visualToResize.isResizable()) {
            computedMinWidth = visualToResize.minWidth(-1.0);
        }
        return Math.max(computedMinWidth, 4.0);
    }

    protected ResizeOperation getResizeOperation() {
        return (ResizeOperation)this.getOperation();
    }

    protected Node getVisualToResize() {
        return this.getHost().getVisual();
    }

    @Override
    public void init() {
        super.init();
        this.initialSize = this.getCurrentSize();
    }

    protected boolean isContentResizable() {
        return this.getHost() instanceof IResizableContentPart;
    }

    public void resize(double finalDw, double finalDh) {
        this.checkInitialized();
        this.applySize(finalDw, finalDh);
    }

    protected void updateResizeOperation(double dw, double dh) {
        Dimension adjusted = this.computeApplicableDelta(dw, dh);
        double layoutDw = adjusted.width;
        double layoutDh = adjusted.height;
        ResizeOperation op = this.getResizeOperation();
        op.setDw(layoutDw);
        op.setDh(layoutDh);
    }
}

