/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef.geometry.convert.fx.Geometry2FX;
import org.eclipse.gef.geometry.euclidean.Angle;
import org.eclipse.gef.geometry.planar.AffineTransform;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.geometry.planar.Rectangle;
import org.eclipse.gef.mvc.fx.models.SelectionModel;
import org.eclipse.gef.mvc.fx.parts.AbstractSegmentHandlePart;
import org.eclipse.gef.mvc.fx.parts.AbstractVisualPart;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.policies.AbstractInteractionPolicy;
import org.eclipse.gef.mvc.fx.policies.CursorSupport;
import org.eclipse.gef.mvc.fx.policies.IOnDragPolicy;
import org.eclipse.gef.mvc.fx.policies.ResizePolicy;
import org.eclipse.gef.mvc.fx.policies.SnapSupport;
import org.eclipse.gef.mvc.fx.policies.TransformPolicy;
import org.eclipse.gef.mvc.fx.providers.ResizableTransformableBoundsProvider;

public class ResizeTransformSelectedOnHandleDragPolicy
extends AbstractInteractionPolicy
implements IOnDragPolicy {
    private CursorSupport cursorSupport = new CursorSupport(this);
    private SnapSupport snapSupport = new SnapSupport(this);
    private Point initialMouseLocation = null;
    private Rectangle selectionBounds;
    private Map<IContentPart<? extends Node>, Double> relX1 = null;
    private Map<IContentPart<? extends Node>, Double> relY1 = null;
    private Map<IContentPart<? extends Node>, Double> relX2 = null;
    private Map<IContentPart<? extends Node>, Double> relY2 = null;
    private boolean invalidGesture = false;
    private Map<IContentPart<? extends Node>, Integer> scaleIndices = new HashMap<IContentPart<? extends Node>, Integer>();
    private Map<IContentPart<? extends Node>, Integer> translateIndices = new HashMap<IContentPart<? extends Node>, Integer>();
    private List<IContentPart<? extends Node>> targetParts;

    @Override
    public void abortDrag() {
        if (this.invalidGesture) {
            return;
        }
        for (IContentPart<? extends Node> part : this.targetParts) {
            TransformPolicy transformPolicy = this.getTransformPolicy(part);
            if (transformPolicy == null) continue;
            this.restoreRefreshVisuals(part);
            this.rollback(transformPolicy);
            ResizePolicy resizePolicy = this.getResizePolicy(part);
            if (resizePolicy == null) continue;
            this.rollback(resizePolicy);
        }
        this.scaleIndices.clear();
        this.translateIndices.clear();
        this.selectionBounds = null;
        this.initialMouseLocation = null;
        this.relY2 = null;
        this.relX2 = null;
        this.relY1 = null;
        this.relX1 = null;
    }

    private void computeRelatives(IContentPart<? extends Node> targetPart) {
        Rectangle bounds = this.getVisualBounds(targetPart);
        if (bounds != null) {
            double left = bounds.getX() - this.selectionBounds.getX();
            double right = left + bounds.getWidth();
            double top = bounds.getY() - this.selectionBounds.getY();
            double bottom = top + bounds.getHeight();
            double selWidth = this.selectionBounds.getWidth();
            double selHeight = this.selectionBounds.getHeight();
            this.relX1.put(targetPart, left / selWidth);
            this.relX2.put(targetPart, right / selWidth);
            this.relY1.put(targetPart, top / selHeight);
            this.relY2.put(targetPart, bottom / selHeight);
        }
    }

    @Override
    public void drag(MouseEvent e, Dimension delta) {
        if (this.invalidGesture) {
            return;
        }
        if (this.selectionBounds == null) {
            return;
        }
        if (this.targetParts.isEmpty()) {
            return;
        }
        Point newEndPointInScene = this.isPrecise(e) ? new Point(e.getSceneX(), e.getSceneY()) : this.snapSupport.snapToGrid(e.getSceneX(), e.getSceneY());
        Rectangle sel = this.updateSelectionBounds(newEndPointInScene);
        for (IContentPart<? extends Node> targetPart : this.targetParts) {
            Bounds initialBounds = this.getBounds(this.selectionBounds, targetPart);
            Bounds newBounds = this.getBounds(sel, targetPart);
            double dx = newBounds.getMinX() - initialBounds.getMinX();
            double dy = newBounds.getMinY() - initialBounds.getMinY();
            Object visual = targetPart.getVisual();
            Point2D originInParent = visual.getParent().sceneToLocal(0.0, 0.0);
            Point2D deltaInParent = visual.getParent().sceneToLocal(dx, dy);
            dx = deltaInParent.getX() - originInParent.getX();
            dy = deltaInParent.getY() - originInParent.getY();
            this.getTransformPolicy(targetPart).setPostTranslate(this.translateIndices.get(targetPart), dx, dy);
            AffineTransform affineTransform = this.getTransformPolicy(targetPart).getCurrentTransform();
            if (affineTransform.getRotation().equals((Object)Angle.fromDeg((double)0.0))) {
                double dw = newBounds.getWidth() - initialBounds.getWidth();
                double dh = newBounds.getHeight() - initialBounds.getHeight();
                Point2D originInLocal = visual.sceneToLocal(newBounds.getMinX(), newBounds.getMinY());
                Point2D dstInLocal = visual.sceneToLocal(newBounds.getMinX() + dw, newBounds.getMinY() + dh);
                dw = dstInLocal.getX() - originInLocal.getX();
                dh = dstInLocal.getY() - originInLocal.getY();
                this.getResizePolicy(targetPart).resize(dw, dh);
                continue;
            }
            double sx = newBounds.getWidth() / initialBounds.getWidth();
            double sy = newBounds.getHeight() / initialBounds.getHeight();
            this.getTransformPolicy(targetPart).setPostScale(this.scaleIndices.get(targetPart), sx, sy);
        }
    }

    @Override
    public void endDrag(MouseEvent e, Dimension delta) {
        if (this.invalidGesture) {
            this.invalidGesture = false;
            return;
        }
        for (IContentPart<? extends Node> part : this.targetParts) {
            TransformPolicy transformPolicy = this.getTransformPolicy(part);
            if (transformPolicy == null) continue;
            this.restoreRefreshVisuals(part);
            this.commit(transformPolicy);
            ResizePolicy resizePolicy = this.getResizePolicy(part);
            if (resizePolicy == null) continue;
            this.commit(resizePolicy);
        }
        this.scaleIndices.clear();
        this.translateIndices.clear();
        this.selectionBounds = null;
        this.initialMouseLocation = null;
        this.relY2 = null;
        this.relX2 = null;
        this.relY1 = null;
        this.relX1 = null;
    }

    private Bounds getBounds(Rectangle sel, IContentPart<? extends Node> targetPart) {
        double x1 = sel.getX() + sel.getWidth() * this.relX1.get(targetPart);
        double x2 = sel.getX() + sel.getWidth() * this.relX2.get(targetPart);
        double y1 = sel.getY() + sel.getHeight() * this.relY1.get(targetPart);
        double y2 = sel.getY() + sel.getHeight() * this.relY2.get(targetPart);
        return new BoundingBox(x1, y1, x2 - x1, y2 - y1);
    }

    protected CursorSupport getCursorSupport() {
        return this.cursorSupport;
    }

    public AbstractSegmentHandlePart<Node> getHost() {
        return (AbstractSegmentHandlePart)super.getHost();
    }

    protected ResizePolicy getResizePolicy(IContentPart<? extends Node> part) {
        return (ResizePolicy)part.getAdapter(ResizePolicy.class);
    }

    private Rectangle getSelectionBounds(List<IContentPart<? extends Node>> targetParts) {
        if (targetParts.isEmpty()) {
            throw new IllegalArgumentException("No target parts given.");
        }
        Rectangle bounds = this.getVisualBounds(targetParts.get(0));
        if (targetParts.size() == 1) {
            return bounds;
        }
        ListIterator<IContentPart<? extends Node>> iterator = targetParts.listIterator(1);
        while (iterator.hasNext()) {
            IContentPart<? extends Node> cp = iterator.next();
            if (bounds == null) {
                bounds = this.getVisualBounds(cp);
                continue;
            }
            bounds.union(this.getVisualBounds(cp));
        }
        return bounds;
    }

    protected List<IContentPart<? extends Node>> getTargetParts() {
        ArrayList<IContentPart<? extends Node>> selection = new ArrayList<IContentPart<? extends Node>>((Collection<IContentPart<? extends Node>>)((SelectionModel)((AbstractVisualPart)this.getHost()).getRoot().getViewer().getAdapter(SelectionModel.class)).getSelectionUnmodifiable());
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            if (this.getVisualBounds((IContentPart)it.next()) != null) continue;
            it.remove();
        }
        return selection;
    }

    protected TransformPolicy getTransformPolicy(IContentPart<? extends Node> part) {
        return (TransformPolicy)part.getAdapter(TransformPolicy.class);
    }

    protected Rectangle getVisualBounds(IContentPart<? extends Node> contentPart) {
        if (contentPart == null) {
            throw new IllegalArgumentException("contentPart may not be null!");
        }
        ResizableTransformableBoundsProvider boundsProvider = new ResizableTransformableBoundsProvider();
        boundsProvider.setAdaptable(contentPart);
        IGeometry boundsInLocal = boundsProvider.get();
        return boundsInLocal == null ? null : FX2Geometry.toRectangle((Bounds)contentPart.getVisual().localToScene(Geometry2FX.toFXBounds((Rectangle)boundsInLocal.getBounds())));
    }

    @Override
    public void hideIndicationCursor() {
        this.getCursorSupport().restoreCursor();
    }

    protected boolean isPrecise(MouseEvent e) {
        return e.isShortcutDown();
    }

    protected boolean isResizeTransform(MouseEvent event) {
        return this.targetParts.size() > 0 && !event.isControlDown() && ((SelectionModel)((AbstractVisualPart)this.getHost()).getRoot().getViewer().getAdapter(SelectionModel.class)).getSelectionUnmodifiable().size() > 1;
    }

    @Override
    public boolean showIndicationCursor(KeyEvent event) {
        return false;
    }

    @Override
    public boolean showIndicationCursor(MouseEvent event) {
        return false;
    }

    @Override
    public void startDrag(MouseEvent e) {
        this.targetParts = this.getTargetParts();
        boolean bl = this.invalidGesture = !this.isResizeTransform(e);
        if (this.invalidGesture) {
            return;
        }
        this.initialMouseLocation = new Point(e.getSceneX(), e.getSceneY());
        this.selectionBounds = this.getSelectionBounds(this.targetParts);
        this.relX1 = new HashMap<IContentPart<? extends Node>, Double>();
        this.relY1 = new HashMap<IContentPart<? extends Node>, Double>();
        this.relX2 = new HashMap<IContentPart<? extends Node>, Double>();
        this.relY2 = new HashMap<IContentPart<? extends Node>, Double>();
        for (IContentPart<? extends Node> targetPart : this.targetParts) {
            TransformPolicy transformPolicy = this.getTransformPolicy(targetPart);
            if (transformPolicy == null) continue;
            this.storeAndDisableRefreshVisuals(targetPart);
            this.computeRelatives(targetPart);
            this.init(transformPolicy);
            Point pivotInScene = this.getVisualBounds(targetPart).getTopLeft();
            Point pivotInParent = FX2Geometry.toPoint((Point2D)((AbstractVisualPart)this.getHost()).getVisual().getParent().sceneToLocal(pivotInScene.x, pivotInScene.y));
            int translateToOriginIndex = transformPolicy.createPostTransform();
            int scaleIndex = transformPolicy.createPostTransform();
            int translateBackIndex = transformPolicy.createPostTransform();
            transformPolicy.setPostTranslate(translateToOriginIndex, -pivotInParent.x, -pivotInParent.y);
            transformPolicy.setPostTranslate(translateBackIndex, pivotInParent.x, pivotInParent.y);
            this.scaleIndices.put(targetPart, scaleIndex);
            this.translateIndices.put(targetPart, transformPolicy.createPostTransform());
            ResizePolicy resizePolicy = this.getResizePolicy(targetPart);
            if (resizePolicy == null) continue;
            this.init(resizePolicy);
        }
    }

    private Rectangle updateSelectionBounds(Point endPointInScene) {
        Rectangle sel = this.selectionBounds.getCopy();
        double dx = endPointInScene.x - this.initialMouseLocation.x;
        double dy = endPointInScene.y - this.initialMouseLocation.y;
        int segment = ((AbstractSegmentHandlePart)this.getHost()).getSegmentIndex();
        if (segment == 0 || segment == 3) {
            sel.shrink(dx, 0.0, 0.0, 0.0);
        } else if (segment == 1 || segment == 2) {
            sel.expand(0.0, 0.0, dx, 0.0);
        }
        if (segment == 0 || segment == 1) {
            sel.shrink(0.0, dy, 0.0, 0.0);
        } else if (segment == 2 || segment == 3) {
            sel.expand(0.0, 0.0, 0.0, dy);
        }
        return sel;
    }
}

