/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.policies;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.ImageCursor;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef.geometry.euclidean.Angle;
import org.eclipse.gef.geometry.euclidean.Vector;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.geometry.planar.Rectangle;
import org.eclipse.gef.mvc.fx.models.SelectionModel;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.parts.PartUtils;
import org.eclipse.gef.mvc.fx.policies.AbstractInteractionPolicy;
import org.eclipse.gef.mvc.fx.policies.CursorSupport;
import org.eclipse.gef.mvc.fx.policies.IOnDragPolicy;
import org.eclipse.gef.mvc.fx.policies.TransformPolicy;

public class RotateSelectedOnHandleDragPolicy
extends AbstractInteractionPolicy
implements IOnDragPolicy {
    private CursorSupport cursorSupport = new CursorSupport(this);
    private ImageCursor rotateCursor;
    private boolean invalidGesture = false;
    private Point initialPointerLocationInScene;
    private Point pivotInScene;
    private Map<IContentPart<? extends Node>, Integer> rotationIndices = new HashMap<IContentPart<? extends Node>, Integer>();
    private List<IContentPart<? extends Node>> targetParts;

    @Override
    public void abortDrag() {
        if (this.invalidGesture) {
            return;
        }
        for (IVisualPart iVisualPart : this.getTargetParts()) {
            TransformPolicy transformPolicy = this.getTransformPolicy(iVisualPart);
            if (transformPolicy == null) continue;
            this.restoreRefreshVisuals(iVisualPart);
            this.rollback(transformPolicy);
        }
    }

    protected Angle computeRotationAngleCW(MouseEvent e, IVisualPart<? extends Node> part) {
        Vector vStart = new Vector(this.pivotInScene, this.initialPointerLocationInScene);
        Vector vEnd = new Vector(this.pivotInScene, new Point(e.getSceneX(), e.getSceneY()));
        Angle angle = vStart.getAngleCW(vEnd);
        return angle;
    }

    protected ImageCursor createRotateCursor() {
        return new ImageCursor(new Image(RotateSelectedOnHandleDragPolicy.class.getResource("/rotate_obj.gif").toExternalForm()));
    }

    protected List<IContentPart<? extends Node>> determineTargetParts() {
        return ((SelectionModel)this.getHost().getRoot().getViewer().getAdapter(SelectionModel.class)).getSelectionUnmodifiable();
    }

    @Override
    public void drag(MouseEvent e, Dimension delta) {
        if (this.invalidGesture) {
            return;
        }
        for (IVisualPart iVisualPart : this.getTargetParts()) {
            this.updateOperation(e, iVisualPart);
        }
    }

    @Override
    public void endDrag(MouseEvent e, Dimension delta) {
        if (this.invalidGesture) {
            this.invalidGesture = false;
            return;
        }
        for (IVisualPart iVisualPart : this.getTargetParts()) {
            this.updateOperation(e, iVisualPart);
            TransformPolicy transformPolicy = this.getTransformPolicy(iVisualPart);
            if (transformPolicy == null) continue;
            this.restoreRefreshVisuals(iVisualPart);
            this.commit(transformPolicy);
        }
    }

    protected CursorSupport getCursorSupport() {
        return this.cursorSupport;
    }

    protected Cursor getRotateCursor() {
        if (this.rotateCursor == null) {
            this.rotateCursor = this.createRotateCursor();
        }
        return this.rotateCursor;
    }

    protected List<IContentPart<? extends Node>> getTargetParts() {
        return this.targetParts;
    }

    protected TransformPolicy getTransformPolicy(IVisualPart<? extends Node> part) {
        return (TransformPolicy)part.getAdapter(TransformPolicy.class);
    }

    @Override
    public void hideIndicationCursor() {
        this.getCursorSupport().restoreCursor();
    }

    protected boolean isRotate(MouseEvent event) {
        return event.isControlDown();
    }

    protected boolean showIndicationCursor(boolean isControlDown) {
        if (isControlDown) {
            this.getCursorSupport().storeAndReplaceCursor(this.getRotateCursor());
            return true;
        }
        return false;
    }

    @Override
    public boolean showIndicationCursor(KeyEvent event) {
        return this.showIndicationCursor(event.isControlDown());
    }

    @Override
    public boolean showIndicationCursor(MouseEvent event) {
        return this.showIndicationCursor(event.isControlDown());
    }

    @Override
    public void startDrag(MouseEvent e) {
        Rectangle bounds;
        boolean bl = this.invalidGesture = !this.isRotate(e);
        if (this.invalidGesture) {
            return;
        }
        this.initialPointerLocationInScene = new Point(e.getSceneX(), e.getSceneY());
        this.targetParts = this.determineTargetParts();
        if (this.targetParts == null) {
            this.targetParts = Collections.emptyList();
        }
        if ((bounds = PartUtils.getUnionedVisualBoundsInScene(this.targetParts)) == null) {
            throw new IllegalStateException("Cannot determine visual bounds (null).");
        }
        this.pivotInScene = bounds.getCenter();
        this.rotationIndices.clear();
        for (IContentPart<? extends Node> part : this.getTargetParts()) {
            TransformPolicy transformPolicy = this.getTransformPolicy(part);
            if (transformPolicy == null) continue;
            this.storeAndDisableRefreshVisuals(part);
            this.init(transformPolicy);
            Point pivotInLocal = FX2Geometry.toPoint((Point2D)this.getHost().getVisual().getParent().sceneToLocal(this.pivotInScene.x, this.pivotInScene.y));
            int translateIndex = transformPolicy.createPostTransform();
            int rotateIndex = transformPolicy.createPostTransform();
            int translateBackIndex = transformPolicy.createPostTransform();
            transformPolicy.setPostTranslate(translateIndex, -pivotInLocal.x, -pivotInLocal.y);
            transformPolicy.setPostTranslate(translateBackIndex, pivotInLocal.x, pivotInLocal.y);
            this.rotationIndices.put(part, rotateIndex);
        }
    }

    private void updateOperation(MouseEvent e, IVisualPart<? extends Node> part) {
        TransformPolicy transformPolicy = this.getTransformPolicy(part);
        if (transformPolicy != null) {
            transformPolicy.setPostRotate(this.rotationIndices.get(part), this.computeRotationAngleCW(e, part));
        }
    }
}

