/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.policies;

import javafx.geometry.Point2D;
import javafx.scene.Node;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.mvc.fx.models.GridModel;
import org.eclipse.gef.mvc.fx.policies.IPolicy;
import org.eclipse.gef.mvc.fx.viewer.IViewer;
import org.eclipse.gef.mvc.fx.viewer.InfiniteCanvasViewer;

public class SnapSupport {
    private IPolicy hostPolicy;

    public SnapSupport(IPolicy hostPolicy) {
        this.hostPolicy = hostPolicy;
    }

    protected Node getGridLocalVisual(IViewer viewer) {
        return viewer instanceof InfiniteCanvasViewer ? ((InfiniteCanvasViewer)viewer).getCanvas().getContentGroup() : viewer.getRootPart().getVisual();
    }

    protected double getSnapToGridGranularityX() {
        return 1.0;
    }

    protected double getSnapToGridGranularityY() {
        return 1.0;
    }

    protected Point snapToGrid(double sceneX, double sceneY) {
        IViewer viewer = this.hostPolicy.getHost().getRoot().getViewer();
        return this.snapToGrid(sceneX, sceneY, (GridModel)viewer.getAdapter(GridModel.class), this.getSnapToGridGranularityX(), this.getSnapToGridGranularityY(), this.getGridLocalVisual(viewer));
    }

    public Point snapToGrid(double sceneX, double sceneY, GridModel gridModel, double gridCellWidthFraction, double gridCellHeightFraction, Node gridLocalVisual) {
        if (!gridModel.isSnapToGrid()) {
            return new Point(sceneX, sceneY);
        }
        Point2D gridLocalPosition = gridLocalVisual.sceneToLocal(sceneX, sceneY);
        double gcw = gridCellWidthFraction * gridModel.getGridCellWidth();
        double nearest = gridLocalPosition.getX() > 0.0 ? 0.5 : -0.5;
        int xs = (int)(gridLocalPosition.getX() / gcw + nearest);
        double gch = gridCellHeightFraction * gridModel.getGridCellHeight();
        nearest = gridLocalPosition.getY() > 0.0 ? 0.5 : -0.5;
        int ys = (int)(gridLocalPosition.getY() / gch + nearest);
        double nx = (double)xs * gcw;
        double ny = (double)ys * gch;
        Point2D newPositionInScene = gridLocalVisual.localToScene(nx, ny);
        return new Point(newPositionInScene.getX(), newPositionInScene.getY());
    }
}

