/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.policies;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef.fx.nodes.Connection;
import org.eclipse.gef.fx.nodes.OrthogonalRouter;
import org.eclipse.gef.fx.utils.NodeUtils;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.geometry.planar.Rectangle;
import org.eclipse.gef.mvc.fx.models.GridModel;
import org.eclipse.gef.mvc.fx.models.SelectionModel;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.policies.AbstractInteractionPolicy;
import org.eclipse.gef.mvc.fx.policies.BendOnSegmentDragPolicy;
import org.eclipse.gef.mvc.fx.policies.CursorSupport;
import org.eclipse.gef.mvc.fx.policies.IOnDragPolicy;
import org.eclipse.gef.mvc.fx.policies.SnapSupport;
import org.eclipse.gef.mvc.fx.policies.TransformPolicy;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class TranslateSelectedOnDragPolicy
extends AbstractInteractionPolicy
implements IOnDragPolicy {
    private CursorSupport cursorSupport = new CursorSupport(this);
    private SnapSupport snapSupport = new SnapSupport(this);
    private Point initialMouseLocationInScene = null;
    private Map<IContentPart<? extends Node>, Integer> translationIndices = new HashMap<IContentPart<? extends Node>, Integer>();
    private List<IContentPart<? extends Node>> targetParts;
    private boolean invalidGesture = false;
    private Map<IContentPart<? extends Node>, Rectangle> boundsInScene = new IdentityHashMap<IContentPart<? extends Node>, Rectangle>();

    @Override
    public void abortDrag() {
        if (this.invalidGesture) {
            return;
        }
        for (IContentPart<? extends Node> part : this.targetParts) {
            TransformPolicy policy = this.getTransformPolicy(part);
            if (policy == null) continue;
            this.rollback(policy);
            this.restoreRefreshVisuals(part);
        }
        this.targetParts = null;
        this.setInitialMouseLocationInScene(null);
        this.translationIndices.clear();
    }

    @Override
    public void drag(MouseEvent e, Dimension delta) {
        if (this.invalidGesture) {
            return;
        }
        IViewer viewer = this.getHost().getRoot().getViewer();
        Node gridLocalVisual = null;
        GridModel gridModel = null;
        double granularityX = 0.0;
        double granularityY = 0.0;
        if (!this.isPrecise(e)) {
            granularityX = this.snapSupport.getSnapToGridGranularityX();
            granularityY = this.snapSupport.getSnapToGridGranularityY();
            gridModel = (GridModel)viewer.getAdapter(GridModel.class);
            gridLocalVisual = this.snapSupport.getGridLocalVisual(viewer);
        }
        for (IContentPart<? extends Node> part : this.targetParts) {
            TransformPolicy policy = this.getTransformPolicy(part);
            if (policy == null) continue;
            Point startInScene = this.boundsInScene.get(part).getTopLeft();
            Point endInScene = startInScene.getTranslated(delta);
            Point newEndInScene = endInScene.getCopy();
            if (gridLocalVisual != null) {
                newEndInScene = this.snapSupport.snapToGrid(endInScene.x, endInScene.y, gridModel, granularityX, granularityY, gridLocalVisual);
            }
            Point newEndInParent = NodeUtils.sceneToLocal((Node)part.getVisual().getParent(), (Point)newEndInScene);
            Point startInParent = NodeUtils.sceneToLocal((Node)part.getVisual().getParent(), (Point)startInScene);
            Point deltaInParent = newEndInParent.getTranslated(startInParent.getNegated());
            policy.setPostTranslate(this.translationIndices.get(part), deltaInParent.x, deltaInParent.y);
        }
    }

    @Override
    public void endDrag(MouseEvent e, Dimension delta) {
        if (this.invalidGesture) {
            return;
        }
        for (IContentPart<? extends Node> part : this.targetParts) {
            TransformPolicy policy = this.getTransformPolicy(part);
            if (policy == null) continue;
            this.commit(policy);
            this.restoreRefreshVisuals(part);
        }
        this.targetParts = null;
        this.setInitialMouseLocationInScene(null);
        this.translationIndices.clear();
    }

    protected CursorSupport getCursorSupport() {
        return this.cursorSupport;
    }

    protected Point getInitialMouseLocationInScene() {
        return this.initialMouseLocationInScene;
    }

    protected List<IContentPart<? extends Node>> getTargetParts() {
        return ((SelectionModel)this.getHost().getRoot().getViewer().getAdapter(SelectionModel.class)).getSelectionUnmodifiable();
    }

    protected TransformPolicy getTransformPolicy(IContentPart<? extends Node> part) {
        return (TransformPolicy)part.getAdapter(TransformPolicy.class);
    }

    @Override
    public void hideIndicationCursor() {
        this.getCursorSupport().restoreCursor();
    }

    protected boolean isPrecise(MouseEvent e) {
        return e.isShortcutDown();
    }

    protected boolean isTranslate(MouseEvent event) {
        IContentPart<? extends Node> part;
        Object visual;
        if (this.targetParts.size() == 1 && this.targetParts.get(0).getAdapter(BendOnSegmentDragPolicy.class) != null && (visual = (part = this.targetParts.get(0)).getVisual()) instanceof Connection && ((Connection)visual).getRouter() instanceof OrthogonalRouter && (((Connection)visual).isStartConnected() || ((Connection)visual).isEndConnected())) {
            this.targetParts = null;
        }
        return this.targetParts != null && !this.targetParts.isEmpty();
    }

    protected void setInitialMouseLocationInScene(Point point) {
        this.initialMouseLocationInScene = point;
    }

    @Override
    public boolean showIndicationCursor(KeyEvent event) {
        return false;
    }

    @Override
    public boolean showIndicationCursor(MouseEvent event) {
        return false;
    }

    @Override
    public void startDrag(MouseEvent e) {
        this.targetParts = this.getTargetParts();
        boolean bl = this.invalidGesture = !this.isTranslate(e);
        if (this.invalidGesture) {
            return;
        }
        this.setInitialMouseLocationInScene(new Point(e.getSceneX(), e.getSceneY()));
        for (IContentPart<? extends Node> part : this.targetParts) {
            TransformPolicy policy = this.getTransformPolicy(part);
            if (policy == null) continue;
            this.storeAndDisableRefreshVisuals(part);
            this.init(policy);
            this.translationIndices.put(part, policy.createPostTransform());
            Rectangle shapeBounds = NodeUtils.getShapeBounds((Node)this.getHost().getVisual());
            Rectangle shapeBoundsInScene = NodeUtils.localToScene((Node)this.getHost().getVisual(), (IGeometry)shapeBounds).getBounds();
            this.boundsInScene.put(part, shapeBoundsInScene);
        }
    }
}

