/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.policies;

import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.input.ZoomEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef.fx.nodes.InfiniteCanvas;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.policies.AbstractInteractionPolicy;
import org.eclipse.gef.mvc.fx.policies.IOnPinchSpreadPolicy;
import org.eclipse.gef.mvc.fx.policies.PanningSupport;
import org.eclipse.gef.mvc.fx.policies.ViewportPolicy;
import org.eclipse.gef.mvc.fx.viewer.InfiniteCanvasViewer;

public class ZoomOnPinchSpreadPolicy
extends AbstractInteractionPolicy
implements IOnPinchSpreadPolicy {
    private PanningSupport panningSupport = new PanningSupport();
    private boolean invalidGesture = false;
    private ViewportPolicy viewportPolicy;

    @Override
    public void abortZoom() {
        if (this.invalidGesture) {
            return;
        }
        this.rollback(this.viewportPolicy);
        this.viewportPolicy = null;
    }

    protected double computeZoomFactor(ZoomEvent event) {
        return event.getZoomFactor();
    }

    protected ViewportPolicy determineViewportPolicy() {
        return (ViewportPolicy)this.getHost().getRoot().getAdapter(ViewportPolicy.class);
    }

    @Override
    public void endZoom(ZoomEvent event) {
        if (this.invalidGesture) {
            return;
        }
        ITransactionalOperation commit = this.getViewportPolicy().commit();
        if (commit != null && !commit.isNoOp()) {
            try {
                this.getHost().getRoot().getViewer().getDomain().execute(commit, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected final ViewportPolicy getViewportPolicy() {
        return this.viewportPolicy;
    }

    protected boolean isContentRestricted() {
        return false;
    }

    protected boolean isZoom(ZoomEvent event) {
        return true;
    }

    @Override
    public void startZoom(ZoomEvent event) {
        boolean bl = this.invalidGesture = !this.isZoom(event);
        if (this.invalidGesture) {
            return;
        }
        this.viewportPolicy = this.determineViewportPolicy();
        this.viewportPolicy.init();
    }

    @Override
    public void zoom(ZoomEvent event) {
        if (this.invalidGesture) {
            return;
        }
        double zoomFactor = this.computeZoomFactor(event);
        if (this.isContentRestricted()) {
            this.panningSupport.removeFreeSpace(this.viewportPolicy, Pos.TOP_LEFT, true);
            InfiniteCanvas infiniteCanvas = ((InfiniteCanvasViewer)this.getHost().getRoot().getViewer()).getCanvas();
            Point2D pivotPointInScene = infiniteCanvas.localToScene(infiniteCanvas.getContentBounds().getMinX(), 0.0);
            this.viewportPolicy.zoom(true, true, zoomFactor, pivotPointInScene.getX(), pivotPointInScene.getY());
            this.panningSupport.removeFreeSpace(this.viewportPolicy, Pos.BOTTOM_RIGHT, false);
        } else {
            this.viewportPolicy.zoom(true, true, zoomFactor, event.getSceneX(), event.getSceneY());
        }
    }
}

