/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import org.eclipse.gef.common.activate.ActivatableSupport;
import org.eclipse.gef.common.activate.IActivatable;
import org.eclipse.gef.mvc.fx.domain.IDomain;
import org.eclipse.gef.mvc.fx.policies.IPolicy;
import org.eclipse.gef.mvc.fx.tools.ITargetPolicyResolver;
import org.eclipse.gef.mvc.fx.tools.ITool;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public abstract class AbstractTool
implements ITool {
    private ActivatableSupport acs = new ActivatableSupport((IActivatable)this);
    private ReadOnlyObjectWrapper<IDomain> domainProperty = new ReadOnlyObjectWrapper();
    private Map<IViewer, List<IPolicy>> activePolicies = new IdentityHashMap<IViewer, List<IPolicy>>();

    public final void activate() {
        this.acs.activate(null, this::doActivate);
    }

    public final ReadOnlyBooleanProperty activeProperty() {
        return this.acs.activeProperty();
    }

    public ReadOnlyObjectProperty<IDomain> adaptableProperty() {
        return this.domainProperty.getReadOnlyProperty();
    }

    protected void clearActivePolicies(IViewer viewer) {
        if (viewer == null) {
            throw new IllegalArgumentException("The given viewer may not be null.");
        }
        this.activePolicies.remove(viewer);
    }

    public final void deactivate() {
        this.acs.deactivate(this::doDeactivate, null);
    }

    protected void doActivate() {
    }

    protected void doDeactivate() {
    }

    @Override
    public List<? extends IPolicy> getActivePolicies(IViewer viewer) {
        if (this.activePolicies.containsKey(viewer)) {
            return Collections.unmodifiableList(this.activePolicies.get(viewer));
        }
        return Collections.emptyList();
    }

    public IDomain getAdaptable() {
        return (IDomain)this.domainProperty.get();
    }

    @Override
    public IDomain getDomain() {
        return this.getAdaptable();
    }

    protected ITargetPolicyResolver getTargetPolicyResolver() {
        return (ITargetPolicyResolver)this.getDomain().getAdapter(ITargetPolicyResolver.class);
    }

    public final boolean isActive() {
        return this.acs.isActive();
    }

    protected void setActivePolicies(IViewer viewer, Collection<? extends IPolicy> activePolicies) {
        if (viewer == null) {
            throw new IllegalArgumentException("The given viewer may not be null.");
        }
        if (activePolicies == null) {
            throw new IllegalArgumentException("The given activePolicies may not be null.");
        }
        this.clearActivePolicies(viewer);
        this.activePolicies.put(viewer, new ArrayList<IPolicy>(activePolicies));
    }

    public void setAdaptable(IDomain adaptable) {
        if (this.isActive()) {
            throw new IllegalStateException("The reference to the IDomain may not be changed while the tool is active. Please deactivate the tool before setting the IEditDomain and re-activate it afterwards.");
        }
        this.domainProperty.set((Object)adaptable);
    }
}

