/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef.fx.gestures.AbstractMouseDragGesture;
import org.eclipse.gef.fx.nodes.InfiniteCanvas;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.mvc.fx.parts.PartUtils;
import org.eclipse.gef.mvc.fx.policies.IOnClickPolicy;
import org.eclipse.gef.mvc.fx.policies.IOnDragPolicy;
import org.eclipse.gef.mvc.fx.policies.IPolicy;
import org.eclipse.gef.mvc.fx.tools.AbstractTool;
import org.eclipse.gef.mvc.fx.viewer.IViewer;
import org.eclipse.gef.mvc.fx.viewer.InfiniteCanvasViewer;

public class ClickDragTool
extends AbstractTool {
    public static final Class<IOnClickPolicy> ON_CLICK_POLICY_KEY = IOnClickPolicy.class;
    public static final Class<IOnDragPolicy> ON_DRAG_POLICY_KEY = IOnDragPolicy.class;
    private final Map<Scene, AbstractMouseDragGesture> gestures = new HashMap<Scene, AbstractMouseDragGesture>();
    private final Map<IViewer, ChangeListener<Boolean>> viewerFocusChangeListeners = new HashMap<IViewer, ChangeListener<Boolean>>();
    private final Map<Scene, EventHandler<MouseEvent>> cursorMouseMoveFilters = new HashMap<Scene, EventHandler<MouseEvent>>();
    private final Map<Scene, EventHandler<KeyEvent>> cursorKeyFilters = new HashMap<Scene, EventHandler<KeyEvent>>();
    private IViewer activeViewer;

    public List<IOnDragPolicy> getActivePolicies(IViewer viewer) {
        return super.getActivePolicies(viewer);
    }

    @Override
    protected void doActivate() {
        super.doActivate();
        for (final IViewer viewer : this.getDomain().getViewers().values()) {
            ChangeListener<Boolean> viewerFocusChangeListener = new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    if (ClickDragTool.this.activeViewer == null) {
                        return;
                    }
                    for (IViewer iViewer : ClickDragTool.this.getDomain().getViewers().values()) {
                        if (!iViewer.isViewerFocused()) continue;
                        return;
                    }
                    for (IPolicy iPolicy : ClickDragTool.this.getActivePolicies(ClickDragTool.this.activeViewer)) {
                        if (!(iPolicy instanceof IOnDragPolicy)) continue;
                        ((IOnDragPolicy)iPolicy).abortDrag();
                    }
                    ClickDragTool.this.clearActivePolicies(ClickDragTool.this.activeViewer);
                    ClickDragTool.this.activeViewer = null;
                    ClickDragTool.this.getDomain().closeExecutionTransaction(ClickDragTool.this);
                }
            };
            viewer.viewerFocusedProperty().addListener((ChangeListener)viewerFocusChangeListener);
            this.viewerFocusChangeListeners.put(viewer, viewerFocusChangeListener);
            Scene scene = viewer.getCanvas().getScene();
            if (this.gestures.containsKey(scene)) continue;
            final IOnDragPolicy[] indicationCursorPolicy = new IOnDragPolicy[1];
            final List[] possibleDragPolicies = new ArrayList[1];
            EventHandler<MouseEvent> indicationCursorMouseMoveFilter = new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    EventTarget eventTarget;
                    if (indicationCursorPolicy[0] != null) {
                        indicationCursorPolicy[0].hideIndicationCursor();
                        indicationCursorPolicy[0] = null;
                    }
                    if ((eventTarget = event.getTarget()) instanceof Node) {
                        Node target = (Node)eventTarget;
                        possibleDragPolicies[0] = new ArrayList<IOnDragPolicy>(ClickDragTool.this.getTargetPolicyResolver().getTargetPolicies(ClickDragTool.this, target, ON_DRAG_POLICY_KEY));
                        ListIterator dragIterator = possibleDragPolicies[0].listIterator(possibleDragPolicies[0].size());
                        while (dragIterator.hasPrevious()) {
                            IOnDragPolicy policy = (IOnDragPolicy)dragIterator.previous();
                            if (!policy.showIndicationCursor(event)) continue;
                            indicationCursorPolicy[0] = policy;
                            break;
                        }
                    }
                }
            };
            scene.addEventFilter(MouseEvent.MOUSE_MOVED, (EventHandler)indicationCursorMouseMoveFilter);
            this.cursorMouseMoveFilters.put(scene, indicationCursorMouseMoveFilter);
            EventHandler<KeyEvent> indicationCursorKeyFilter = new EventHandler<KeyEvent>(){

                public void handle(KeyEvent event) {
                    if (indicationCursorPolicy[0] != null) {
                        indicationCursorPolicy[0].hideIndicationCursor();
                        indicationCursorPolicy[0] = null;
                    }
                    if (possibleDragPolicies[0] == null || possibleDragPolicies[0].isEmpty()) {
                        return;
                    }
                    ListIterator dragIterator = possibleDragPolicies[0].listIterator(possibleDragPolicies[0].size());
                    while (dragIterator.hasPrevious()) {
                        IOnDragPolicy policy = (IOnDragPolicy)dragIterator.previous();
                        if (!policy.showIndicationCursor(event)) continue;
                        indicationCursorPolicy[0] = policy;
                        break;
                    }
                }
            };
            scene.addEventFilter(KeyEvent.ANY, (EventHandler)indicationCursorKeyFilter);
            this.cursorKeyFilters.put(scene, indicationCursorKeyFilter);
            AbstractMouseDragGesture gesture = new AbstractMouseDragGesture((EventHandler)indicationCursorMouseMoveFilter, (EventHandler)indicationCursorKeyFilter, indicationCursorPolicy){
                private final /* synthetic */ EventHandler val$indicationCursorMouseMoveFilter;
                private final /* synthetic */ EventHandler val$indicationCursorKeyFilter;
                private final /* synthetic */ IOnDragPolicy[] val$indicationCursorPolicy;
                {
                    this.val$indicationCursorMouseMoveFilter = eventHandler;
                    this.val$indicationCursorKeyFilter = eventHandler2;
                    this.val$indicationCursorPolicy = iOnDragPolicyArray;
                }

                protected void drag(Node target, MouseEvent e, double dx, double dy) {
                    if (ClickDragTool.this.getActivePolicies(ClickDragTool.this.activeViewer).isEmpty()) {
                        return;
                    }
                    for (IOnDragPolicy policy : ClickDragTool.this.getActivePolicies(ClickDragTool.this.activeViewer)) {
                        policy.drag(e, new Dimension(dx, dy));
                    }
                }

                protected void press(Node target, MouseEvent e) {
                    if (viewer instanceof InfiniteCanvasViewer) {
                        InfiniteCanvas canvas = ((InfiniteCanvasViewer)viewer).getCanvas();
                        if (e.getTarget() instanceof Node) {
                            Node targetNode = (Node)e.getTarget();
                            while (targetNode != null) {
                                if (targetNode == canvas.getHorizontalScrollBar() || targetNode == canvas.getVerticalScrollBar()) {
                                    return;
                                }
                                targetNode = targetNode.getParent();
                            }
                        }
                    }
                    this.val$indicationCursorMouseMoveFilter.handle((Event)e);
                    Scene scene = viewer.getRootPart().getVisual().getScene();
                    scene.removeEventFilter(MouseEvent.MOUSE_MOVED, this.val$indicationCursorMouseMoveFilter);
                    scene.removeEventFilter(KeyEvent.ANY, this.val$indicationCursorKeyFilter);
                    boolean opened = false;
                    List<IOnClickPolicy> clickPolicies = ClickDragTool.this.getTargetPolicyResolver().getTargetPolicies(ClickDragTool.this, target, ON_CLICK_POLICY_KEY);
                    if (clickPolicies != null && !clickPolicies.isEmpty()) {
                        opened = true;
                        ClickDragTool.this.getDomain().openExecutionTransaction(ClickDragTool.this);
                        for (IOnClickPolicy clickPolicy : clickPolicies) {
                            clickPolicy.click(e);
                        }
                    }
                    ClickDragTool.this.activeViewer = PartUtils.retrieveViewer(ClickDragTool.this.getDomain(), target);
                    List<IOnDragPolicy> policies = null;
                    if (ClickDragTool.this.activeViewer != null) {
                        policies = ClickDragTool.this.getTargetPolicyResolver().getTargetPolicies(ClickDragTool.this, target, ClickDragTool.this.activeViewer, ON_DRAG_POLICY_KEY);
                    }
                    if (policies == null || policies.isEmpty()) {
                        if (opened) {
                            ClickDragTool.this.getDomain().closeExecutionTransaction(ClickDragTool.this);
                        }
                        policies = null;
                        return;
                    }
                    if (!opened) {
                        ClickDragTool.this.getDomain().openExecutionTransaction(ClickDragTool.this);
                    }
                    ClickDragTool.this.setActivePolicies(ClickDragTool.this.activeViewer, policies);
                    for (IOnDragPolicy policy : policies) {
                        policy.startDrag(e);
                    }
                }

                protected void release(Node target, MouseEvent e, double dx, double dy) {
                    Scene scene = viewer.getRootPart().getVisual().getScene();
                    scene.addEventFilter(MouseEvent.MOUSE_MOVED, this.val$indicationCursorMouseMoveFilter);
                    scene.addEventFilter(KeyEvent.ANY, this.val$indicationCursorKeyFilter);
                    if (ClickDragTool.this.getActivePolicies(ClickDragTool.this.activeViewer).isEmpty()) {
                        ClickDragTool.this.activeViewer = null;
                        return;
                    }
                    for (IOnDragPolicy policy : ClickDragTool.this.getActivePolicies(ClickDragTool.this.activeViewer)) {
                        policy.endDrag(e, new Dimension(dx, dy));
                    }
                    ClickDragTool.this.clearActivePolicies(ClickDragTool.this.activeViewer);
                    ClickDragTool.this.activeViewer = null;
                    ClickDragTool.this.getDomain().closeExecutionTransaction(ClickDragTool.this);
                    if (this.val$indicationCursorPolicy[0] != null) {
                        this.val$indicationCursorPolicy[0].hideIndicationCursor();
                        this.val$indicationCursorPolicy[0] = null;
                    }
                }
            };
            gesture.setScene(scene);
            this.gestures.put(scene, gesture);
        }
    }

    @Override
    protected void doDeactivate() {
        for (Scene scene : new ArrayList<Scene>(this.gestures.keySet())) {
            this.gestures.remove(scene).setScene(null);
            scene.removeEventFilter(MouseEvent.MOUSE_MOVED, this.cursorMouseMoveFilters.remove(scene));
            scene.removeEventFilter(KeyEvent.ANY, this.cursorKeyFilters.remove(scene));
        }
        for (IViewer viewer : new ArrayList<IViewer>(this.viewerFocusChangeListeners.keySet())) {
            viewer.viewerFocusedProperty().removeListener(this.viewerFocusChangeListeners.remove(viewer));
        }
        super.doDeactivate();
    }
}

