/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.tools;

import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import org.eclipse.gef.common.adapt.AdapterKey;
import org.eclipse.gef.common.adapt.IAdaptable;
import org.eclipse.gef.mvc.fx.domain.IDomain;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.parts.PartUtils;
import org.eclipse.gef.mvc.fx.policies.IPolicy;
import org.eclipse.gef.mvc.fx.tools.ITargetPolicyResolver;
import org.eclipse.gef.mvc.fx.tools.ITool;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class DefaultTargetPolicyResolver
extends IAdaptable.Bound.Impl<IDomain>
implements ITargetPolicyResolver {
    private static final AdapterKeyComparator ADAPTER_KEY_COMPARATOR = new AdapterKeyComparator(true);

    @Override
    public <T extends IPolicy> List<? extends T> getTargetPolicies(ITool contextTool, Node target, Class<T> policyClass) {
        IViewer viewer = PartUtils.retrieveViewer(contextTool.getDomain(), target);
        if (viewer == null) {
            return Collections.emptyList();
        }
        return this.getTargetPolicies(contextTool, target, viewer, policyClass);
    }

    @Override
    public <T extends IPolicy> List<? extends T> getTargetPolicies(ITool contextTool, Node target, IViewer viewer, Class<T> policyClass) {
        IVisualPart<? extends Node> targetPart;
        ArrayList<IPolicy> outerTargetPolicies = new ArrayList<IPolicy>();
        Collection tools = viewer.getDomain().getAdapters((TypeToken)new TypeToken<ITool>(){}).values();
        for (ITool tool : tools) {
            if (tool == contextTool) continue;
            for (IPolicy iPolicy : tool.getActivePolicies(viewer)) {
                if (!iPolicy.getClass().isAssignableFrom(policyClass)) continue;
                try {
                    outerTargetPolicies.add(iPolicy);
                }
                catch (ClassCastException classCastException) {}
            }
        }
        if (!outerTargetPolicies.isEmpty()) {
            return outerTargetPolicies;
        }
        IVisualPart<? extends Node> part = targetPart = PartUtils.retrieveVisualPart(viewer, target);
        ArrayList<IPolicy> arrayList = new ArrayList<IPolicy>();
        while (part != null) {
            Map partPolicies = part.getAdapters(policyClass);
            ArrayList descendinglySortedKeys = new ArrayList(partPolicies.keySet());
            Collections.sort(descendinglySortedKeys, ADAPTER_KEY_COMPARATOR);
            for (AdapterKey key : descendinglySortedKeys) {
                arrayList.add((IPolicy)partPolicies.get(key));
            }
            part = part.getParent();
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    private static final class AdapterKeyComparator
    implements Comparator<AdapterKey<?>> {
        private boolean descending;

        public AdapterKeyComparator(boolean descending) {
            this.descending = descending;
        }

        @Override
        public int compare(AdapterKey<?> lhs, AdapterKey<?> rhs) {
            int cmp = lhs.getRole().compareTo(rhs.getRole());
            return this.descending ? -cmp : cmp;
        }
    }
}

