/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.tools;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef.mvc.fx.policies.IOnHoverPolicy;
import org.eclipse.gef.mvc.fx.tools.AbstractTool;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class HoverTool
extends AbstractTool {
    public static final Class<IOnHoverPolicy> ON_HOVER_POLICY_KEY = IOnHoverPolicy.class;
    private final Map<Scene, EventHandler<MouseEvent>> hoverFilters = new HashMap<Scene, EventHandler<MouseEvent>>();

    protected EventHandler<MouseEvent> createHoverFilter(IViewer viewer) {
        return new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (!(event.getEventType().equals(MouseEvent.MOUSE_MOVED) || event.getEventType().equals(MouseEvent.MOUSE_ENTERED_TARGET) || event.getEventType().equals(MouseEvent.MOUSE_EXITED_TARGET))) {
                    return;
                }
                EventTarget eventTarget = event.getTarget();
                if (eventTarget instanceof Node) {
                    List<IOnHoverPolicy> policies = HoverTool.this.getTargetPolicyResolver().getTargetPolicies(HoverTool.this, (Node)eventTarget, ON_HOVER_POLICY_KEY);
                    HoverTool.this.getDomain().openExecutionTransaction(HoverTool.this);
                    for (IOnHoverPolicy policy : policies) {
                        policy.hover(event);
                    }
                    HoverTool.this.getDomain().closeExecutionTransaction(HoverTool.this);
                }
            }
        };
    }

    @Override
    protected void doActivate() {
        super.doActivate();
        for (IViewer viewer : this.getDomain().getViewers().values()) {
            Scene scene = viewer.getCanvas().getScene();
            if (this.hoverFilters.containsKey(scene)) continue;
            EventHandler<MouseEvent> hoverFilter = this.createHoverFilter(viewer);
            scene.addEventFilter(MouseEvent.ANY, hoverFilter);
            this.hoverFilters.put(scene, hoverFilter);
        }
    }

    @Override
    protected void doDeactivate() {
        for (Scene scene : this.hoverFilters.keySet()) {
            scene.removeEventFilter(MouseEvent.ANY, this.hoverFilters.remove(scene));
        }
        super.doDeactivate();
    }
}

