/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.ZoomEvent;
import org.eclipse.gef.fx.gestures.AbstractPinchSpreadGesture;
import org.eclipse.gef.mvc.fx.policies.IOnPinchSpreadPolicy;
import org.eclipse.gef.mvc.fx.tools.AbstractTool;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class PinchSpreadTool
extends AbstractTool {
    public static final Class<IOnPinchSpreadPolicy> ON_PINCH_SPREAD_POLICY_KEY = IOnPinchSpreadPolicy.class;
    private final Map<Scene, AbstractPinchSpreadGesture> gestures = new HashMap<Scene, AbstractPinchSpreadGesture>();
    private final Map<IViewer, ChangeListener<Boolean>> viewerFocusChangeListeners = new HashMap<IViewer, ChangeListener<Boolean>>();

    public List<? extends IOnPinchSpreadPolicy> getActivePolicies(IViewer viewer) {
        return super.getActivePolicies(viewer);
    }

    @Override
    protected void doActivate() {
        super.doActivate();
        for (final IViewer viewer : this.getDomain().getViewers().values()) {
            ChangeListener<Boolean> viewerFocusChangeListener = new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    if (newValue == null || !newValue.booleanValue()) {
                        for (IOnPinchSpreadPolicy iOnPinchSpreadPolicy : PinchSpreadTool.this.getActivePolicies(viewer)) {
                            iOnPinchSpreadPolicy.abortZoom();
                        }
                        PinchSpreadTool.this.clearActivePolicies(viewer);
                        PinchSpreadTool.this.getDomain().closeExecutionTransaction(PinchSpreadTool.this);
                    }
                }
            };
            viewer.viewerFocusedProperty().addListener((ChangeListener)viewerFocusChangeListener);
            this.viewerFocusChangeListeners.put(viewer, viewerFocusChangeListener);
            Scene scene = viewer.getRootPart().getVisual().getScene();
            if (this.gestures.containsKey(scene)) continue;
            AbstractPinchSpreadGesture gesture = new AbstractPinchSpreadGesture(){

                protected void zoom(ZoomEvent e) {
                    for (IOnPinchSpreadPolicy iOnPinchSpreadPolicy : PinchSpreadTool.this.getActivePolicies(viewer)) {
                        iOnPinchSpreadPolicy.zoom(e);
                    }
                }

                protected void zoomFinished(ZoomEvent e) {
                    for (IOnPinchSpreadPolicy iOnPinchSpreadPolicy : PinchSpreadTool.this.getActivePolicies(viewer)) {
                        iOnPinchSpreadPolicy.endZoom(e);
                    }
                    PinchSpreadTool.this.clearActivePolicies(viewer);
                    PinchSpreadTool.this.getDomain().closeExecutionTransaction(PinchSpreadTool.this);
                }

                protected void zoomStarted(ZoomEvent e) {
                    if (!PinchSpreadTool.this.getDomain().isExecutionTransactionOpen(PinchSpreadTool.this)) {
                        PinchSpreadTool.this.getDomain().openExecutionTransaction(PinchSpreadTool.this);
                    }
                    EventTarget eventTarget = e.getTarget();
                    PinchSpreadTool.this.setActivePolicies(viewer, PinchSpreadTool.this.getTargetPolicyResolver().getTargetPolicies(PinchSpreadTool.this, eventTarget instanceof Node ? (Node)eventTarget : null, ON_PINCH_SPREAD_POLICY_KEY));
                    for (IOnPinchSpreadPolicy iOnPinchSpreadPolicy : PinchSpreadTool.this.getActivePolicies(viewer)) {
                        iOnPinchSpreadPolicy.startZoom(e);
                    }
                }
            };
            gesture.setScene(viewer.getCanvas().getScene());
            this.gestures.put(scene, gesture);
        }
    }

    @Override
    protected void doDeactivate() {
        for (Scene scene : new ArrayList<Scene>(this.gestures.keySet())) {
            this.gestures.remove(scene).setScene(null);
        }
        for (IViewer viewer : new ArrayList<IViewer>(this.viewerFocusChangeListeners.keySet())) {
            viewer.viewerFocusedProperty().removeListener(this.viewerFocusChangeListeners.remove(viewer));
        }
        super.doDeactivate();
    }
}

