/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.RotateEvent;
import org.eclipse.gef.fx.gestures.AbstractRotateGesture;
import org.eclipse.gef.mvc.fx.policies.IOnRotatePolicy;
import org.eclipse.gef.mvc.fx.tools.AbstractTool;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class RotateTool
extends AbstractTool {
    public static final Class<IOnRotatePolicy> ON_ROTATE_POLICY_KEY = IOnRotatePolicy.class;
    private final Map<Scene, AbstractRotateGesture> gestures = new HashMap<Scene, AbstractRotateGesture>();
    private final Map<IViewer, ChangeListener<Boolean>> viewerFocusChangeListeners = new HashMap<IViewer, ChangeListener<Boolean>>();

    public List<? extends IOnRotatePolicy> getActivePolicies(IViewer viewer) {
        return super.getActivePolicies(viewer);
    }

    @Override
    protected void doActivate() {
        super.doActivate();
        for (final IViewer viewer : this.getDomain().getViewers().values()) {
            ChangeListener<Boolean> viewerFocusChangeListener = new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    if (newValue == null || !newValue.booleanValue()) {
                        for (IOnRotatePolicy iOnRotatePolicy : RotateTool.this.getActivePolicies(viewer)) {
                            iOnRotatePolicy.abortRotate();
                        }
                        RotateTool.this.clearActivePolicies(viewer);
                        RotateTool.this.getDomain().closeExecutionTransaction(RotateTool.this);
                    }
                }
            };
            viewer.viewerFocusedProperty().addListener((ChangeListener)viewerFocusChangeListener);
            this.viewerFocusChangeListeners.put(viewer, viewerFocusChangeListener);
            Scene scene = viewer.getCanvas().getScene();
            if (this.gestures.containsKey(scene)) continue;
            AbstractRotateGesture gesture = new AbstractRotateGesture(){

                protected void rotate(RotateEvent event) {
                    for (IOnRotatePolicy iOnRotatePolicy : RotateTool.this.getActivePolicies(viewer)) {
                        iOnRotatePolicy.rotate(event);
                    }
                }

                protected void rotationFinished(RotateEvent event) {
                    for (IOnRotatePolicy iOnRotatePolicy : RotateTool.this.getActivePolicies(viewer)) {
                        iOnRotatePolicy.endRotate(event);
                    }
                    RotateTool.this.clearActivePolicies(viewer);
                    RotateTool.this.getDomain().closeExecutionTransaction(RotateTool.this);
                }

                protected void rotationStarted(RotateEvent event) {
                    EventTarget eventTarget = event.getTarget();
                    RotateTool.this.setActivePolicies(viewer, RotateTool.this.getTargetPolicyResolver().getTargetPolicies(RotateTool.this, eventTarget instanceof Node ? (Node)eventTarget : null, ON_ROTATE_POLICY_KEY));
                    RotateTool.this.getDomain().openExecutionTransaction(RotateTool.this);
                    for (IOnRotatePolicy iOnRotatePolicy : RotateTool.this.getActivePolicies(viewer)) {
                        iOnRotatePolicy.startRotate(event);
                    }
                }
            };
            gesture.setScene(scene);
            this.gestures.put(scene, gesture);
        }
    }

    @Override
    protected void doDeactivate() {
        for (IViewer viewer : new ArrayList<IViewer>(this.viewerFocusChangeListeners.keySet())) {
            viewer.viewerFocusedProperty().removeListener(this.viewerFocusChangeListeners.remove(viewer));
        }
        for (Scene scene : new ArrayList<Scene>(this.gestures.keySet())) {
            this.gestures.remove(scene).setScene(null);
        }
        super.doDeactivate();
    }
}

