/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.ScrollEvent;
import org.eclipse.gef.fx.gestures.AbstractScrollGesture;
import org.eclipse.gef.mvc.fx.policies.IOnScrollPolicy;
import org.eclipse.gef.mvc.fx.tools.AbstractTool;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class ScrollTool
extends AbstractTool {
    public static final Class<IOnScrollPolicy> ON_SCROLL_POLICY_KEY = IOnScrollPolicy.class;
    private final Map<Scene, AbstractScrollGesture> gestures = new HashMap<Scene, AbstractScrollGesture>();
    private final Map<IViewer, ChangeListener<Boolean>> viewerFocusChangeListeners = new HashMap<IViewer, ChangeListener<Boolean>>();

    public List<? extends IOnScrollPolicy> getActivePolicies(IViewer viewer) {
        return super.getActivePolicies(viewer);
    }

    @Override
    protected void doActivate() {
        super.doActivate();
        for (final IViewer viewer : this.getDomain().getViewers().values()) {
            ChangeListener<Boolean> viewerFocusChangeListener = new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    if (newValue == null || !newValue.booleanValue()) {
                        for (IOnScrollPolicy iOnScrollPolicy : ScrollTool.this.getActivePolicies(viewer)) {
                            iOnScrollPolicy.abortScroll();
                        }
                        ScrollTool.this.clearActivePolicies(viewer);
                        ScrollTool.this.getDomain().closeExecutionTransaction(ScrollTool.this);
                    }
                }
            };
            viewer.viewerFocusedProperty().addListener((ChangeListener)viewerFocusChangeListener);
            this.viewerFocusChangeListeners.put(viewer, viewerFocusChangeListener);
            Scene scene = viewer.getCanvas().getScene();
            if (this.gestures.containsKey(scene)) continue;
            AbstractScrollGesture scrollGesture = new AbstractScrollGesture(){

                protected void scroll(ScrollEvent event) {
                    for (IOnScrollPolicy iOnScrollPolicy : ScrollTool.this.getActivePolicies(viewer)) {
                        iOnScrollPolicy.scroll(event);
                    }
                }

                protected void scrollFinished() {
                    for (IOnScrollPolicy iOnScrollPolicy : ScrollTool.this.getActivePolicies(viewer)) {
                        iOnScrollPolicy.endScroll();
                    }
                    ScrollTool.this.clearActivePolicies(viewer);
                    ScrollTool.this.getDomain().closeExecutionTransaction(ScrollTool.this);
                }

                protected void scrollStarted(ScrollEvent event) {
                    EventTarget eventTarget = event.getTarget();
                    ScrollTool.this.getDomain().openExecutionTransaction(ScrollTool.this);
                    ScrollTool.this.setActivePolicies(viewer, ScrollTool.this.getTargetPolicyResolver().getTargetPolicies(ScrollTool.this, eventTarget instanceof Node ? (Node)eventTarget : null, ON_SCROLL_POLICY_KEY));
                    for (IOnScrollPolicy iOnScrollPolicy : ScrollTool.this.getActivePolicies(viewer)) {
                        iOnScrollPolicy.startScroll(event);
                    }
                }
            };
            scrollGesture.setScene(scene);
            this.gestures.put(scene, scrollGesture);
        }
    }

    @Override
    protected void doDeactivate() {
        for (Scene scene : new ArrayList<Scene>(this.gestures.keySet())) {
            this.gestures.remove(scene).setScene(null);
        }
        for (IViewer viewer : new ArrayList<IViewer>(this.viewerFocusChangeListeners.keySet())) {
            viewer.viewerFocusedProperty().removeListener(this.viewerFocusChangeListeners.remove(viewer));
        }
        super.doDeactivate();
    }
}

