/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.tools;

import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.KeyEvent;
import org.eclipse.gef.mvc.fx.models.FocusModel;
import org.eclipse.gef.mvc.fx.parts.PartUtils;
import org.eclipse.gef.mvc.fx.policies.IOnStrokePolicy;
import org.eclipse.gef.mvc.fx.policies.IOnTypePolicy;
import org.eclipse.gef.mvc.fx.tools.AbstractTool;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class TypeTool
extends AbstractTool {
    public static final Class<IOnTypePolicy> ON_TYPE_POLICY_KEY = IOnTypePolicy.class;
    public static final Class<IOnStrokePolicy> ON_STROKE_POLICY_KEY = IOnStrokePolicy.class;
    private Map<Scene, EventHandler<? super KeyEvent>> pressedFilterMap = new IdentityHashMap<Scene, EventHandler<? super KeyEvent>>();
    private Map<Scene, EventHandler<? super KeyEvent>> releasedFilterMap = new IdentityHashMap<Scene, EventHandler<? super KeyEvent>>();
    private Map<Scene, EventHandler<? super KeyEvent>> typedFilterMap = new IdentityHashMap<Scene, EventHandler<? super KeyEvent>>();
    private Map<IViewer, ChangeListener<Boolean>> viewerFocusChangeListeners = new HashMap<IViewer, ChangeListener<Boolean>>();
    private IViewer activeViewer;

    public List<? extends IOnStrokePolicy> getActivePolicies(IViewer viewer) {
        return super.getActivePolicies(viewer);
    }

    @Override
    protected void doActivate() {
        for (IViewer viewer : this.getDomain().getViewers().values()) {
            FocusModel focusModel = (FocusModel)viewer.getAdapter(FocusModel.class);
            if (focusModel == null) {
                throw new IllegalStateException("Cannot find FocusModel.");
            }
            final HashSet pressedKeys = new HashSet();
            ChangeListener<Boolean> viewerFocusChangeListener = new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    if (TypeTool.this.activeViewer == null) {
                        return;
                    }
                    for (IViewer iViewer : TypeTool.this.getDomain().getViewers().values()) {
                        if (!iViewer.isViewerFocused()) continue;
                        return;
                    }
                    for (IOnStrokePolicy iOnStrokePolicy : TypeTool.this.getActivePolicies(TypeTool.this.activeViewer)) {
                        iOnStrokePolicy.abortPress();
                    }
                    TypeTool.this.clearActivePolicies(TypeTool.this.activeViewer);
                    TypeTool.this.activeViewer = null;
                    TypeTool.this.getDomain().closeExecutionTransaction(TypeTool.this);
                    pressedKeys.clear();
                }
            };
            viewer.viewerFocusedProperty().addListener((ChangeListener)viewerFocusChangeListener);
            this.viewerFocusChangeListeners.put(viewer, viewerFocusChangeListener);
            Scene scene = viewer.getRootPart().getVisual().getScene();
            if (this.pressedFilterMap.containsKey(scene)) continue;
            EventHandler<KeyEvent> pressedFilter = new EventHandler<KeyEvent>(){

                /*
                 * WARNING - void declaration
                 */
                public void handle(KeyEvent event) {
                    boolean isInitialPress = false;
                    if (pressedKeys.isEmpty()) {
                        void var3_6;
                        Object var3_3 = null;
                        EventTarget target = event.getTarget();
                        if (target instanceof Node) {
                            Node node = (Node)target;
                            TypeTool.this.activeViewer = PartUtils.retrieveViewer(TypeTool.this.getDomain(), node);
                        } else if (target instanceof Scene) {
                            for (IViewer v : TypeTool.this.getDomain().getViewers().values()) {
                                if (v.getRootPart().getVisual().getScene() != target || !v.isViewerFocused()) continue;
                                TypeTool.this.activeViewer = v;
                                break;
                            }
                            if (TypeTool.this.activeViewer != null) {
                                Object v = TypeTool.this.activeViewer.getRootPart().getVisual();
                            }
                        } else {
                            throw new IllegalStateException("Unsupported event target: " + target);
                        }
                        if (TypeTool.this.activeViewer == null) {
                            return;
                        }
                        TypeTool.this.getDomain().openExecutionTransaction(TypeTool.this);
                        isInitialPress = true;
                        TypeTool.this.setActivePolicies(TypeTool.this.activeViewer, TypeTool.this.getTargetPolicyResolver().getTargetPolicies(TypeTool.this, (Node)var3_6, ON_STROKE_POLICY_KEY));
                    }
                    pressedKeys.add(event.getCode());
                    for (IOnStrokePolicy iOnStrokePolicy : TypeTool.this.getActivePolicies(TypeTool.this.activeViewer)) {
                        if (isInitialPress) {
                            iOnStrokePolicy.initialPress(event);
                            continue;
                        }
                        iOnStrokePolicy.press(event);
                    }
                }
            };
            this.pressedFilterMap.put(scene, (EventHandler<? super KeyEvent>)pressedFilter);
            EventHandler<KeyEvent> releasedFilter = new EventHandler<KeyEvent>(){

                public void handle(KeyEvent event) {
                    boolean isFinalRelease = pressedKeys.size() == 1 && pressedKeys.contains(event.getCode());
                    for (IOnStrokePolicy iOnStrokePolicy : TypeTool.this.getActivePolicies(TypeTool.this.activeViewer)) {
                        if (isFinalRelease) {
                            iOnStrokePolicy.finalRelease(event);
                            continue;
                        }
                        iOnStrokePolicy.release(event);
                    }
                    if (isFinalRelease) {
                        TypeTool.this.clearActivePolicies(TypeTool.this.activeViewer);
                        TypeTool.this.activeViewer = null;
                        TypeTool.this.getDomain().closeExecutionTransaction(TypeTool.this);
                    }
                    pressedKeys.remove(event.getCode());
                }
            };
            this.releasedFilterMap.put(scene, (EventHandler<? super KeyEvent>)releasedFilter);
            EventHandler<KeyEvent> typedFilter = new EventHandler<KeyEvent>(){

                public void handle(KeyEvent event) {
                    if (pressedKeys.isEmpty()) {
                        TypeTool.this.getDomain().openExecutionTransaction(TypeTool.this);
                    }
                    EventTarget target = event.getTarget();
                    Object targetNode = null;
                    if (target instanceof Node) {
                        targetNode = (Node)target;
                    } else if (target instanceof Scene) {
                        for (IViewer v : TypeTool.this.getDomain().getViewers().values()) {
                            if (v.getRootPart().getVisual().getScene() != target || !v.isViewerFocused()) continue;
                            targetNode = v.getRootPart().getVisual();
                            break;
                        }
                    } else {
                        throw new IllegalStateException("Unsupported event target: " + target);
                    }
                    List<IOnTypePolicy> policies = TypeTool.this.getTargetPolicyResolver().getTargetPolicies(TypeTool.this, (Node)targetNode, ON_TYPE_POLICY_KEY);
                    for (IOnTypePolicy policy : policies) {
                        policy.type(event, pressedKeys);
                    }
                    if (pressedKeys.isEmpty()) {
                        TypeTool.this.getDomain().closeExecutionTransaction(TypeTool.this);
                    }
                }
            };
            this.typedFilterMap.put(scene, (EventHandler<? super KeyEvent>)typedFilter);
            scene.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)pressedFilter);
            scene.addEventFilter(KeyEvent.KEY_RELEASED, (EventHandler)releasedFilter);
            scene.addEventFilter(KeyEvent.KEY_TYPED, (EventHandler)typedFilter);
        }
    }

    @Override
    protected void doDeactivate() {
        for (IViewer viewer : this.getDomain().getViewers().values()) {
            viewer.viewerFocusedProperty().removeListener(this.viewerFocusChangeListeners.remove(viewer));
            Scene scene = viewer.getRootPart().getVisual().getScene();
            if (this.pressedFilterMap.containsKey(scene)) {
                scene.removeEventFilter(KeyEvent.KEY_PRESSED, this.pressedFilterMap.remove(scene));
            }
            if (this.releasedFilterMap.containsKey(scene)) {
                scene.removeEventFilter(KeyEvent.KEY_RELEASED, this.releasedFilterMap.remove(scene));
            }
            if (!this.typedFilterMap.containsKey(scene)) continue;
            scene.removeEventFilter(KeyEvent.KEY_TYPED, this.typedFilterMap.remove(scene));
        }
    }
}

