/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.viewer;

import com.google.common.reflect.TypeToken;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.TreeMap;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Window;
import org.eclipse.gef.common.activate.ActivatableSupport;
import org.eclipse.gef.common.activate.IActivatable;
import org.eclipse.gef.common.adapt.AdaptableSupport;
import org.eclipse.gef.common.adapt.AdapterKey;
import org.eclipse.gef.common.adapt.IAdaptable;
import org.eclipse.gef.common.adapt.inject.InjectAdapters;
import org.eclipse.gef.common.beans.property.ReadOnlyListWrapperEx;
import org.eclipse.gef.common.beans.property.ReadOnlyMapWrapperEx;
import org.eclipse.gef.common.collections.CollectionUtils;
import org.eclipse.gef.fx.nodes.InfiniteCanvas;
import org.eclipse.gef.fx.utils.NodeUtils;
import org.eclipse.gef.mvc.fx.domain.IDomain;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IRootPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class InfiniteCanvasViewer
implements IViewer {
    private InfiniteCanvas infiniteCanvas;
    private boolean isInitialized = false;
    private boolean isWindowFocused = false;
    private boolean isFocusOwnerFocused = false;
    private ReadOnlyBooleanWrapper viewerFocusedProperty = new ReadOnlyBooleanWrapper(false);
    private ObservableList<Object> contents = CollectionUtils.observableArrayList();
    private ReadOnlyListWrapper<Object> contentsProperty = new ReadOnlyListWrapperEx((Object)this, "contents", this.contents);
    private BooleanBinding viewerFocusedPropertyBinding = new BooleanBinding(){

        protected boolean computeValue() {
            return InfiniteCanvasViewer.this.isWindowFocused && InfiniteCanvasViewer.this.isFocusOwnerFocused;
        }
    };
    private ChangeListener<Window> windowObserver = new ChangeListener<Window>(){

        public void changed(ObservableValue<? extends Window> observable, Window oldValue, Window newValue) {
            InfiniteCanvasViewer.this.onWindowChanged(oldValue, newValue);
        }
    };
    private ChangeListener<Boolean> windowFocusedObserver = new ChangeListener<Boolean>(){

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            InfiniteCanvasViewer.this.onWindowFocusedChanged(oldValue, newValue);
        }
    };
    private ChangeListener<Node> focusOwnerObserver = new ChangeListener<Node>(){

        public void changed(ObservableValue<? extends Node> observable, Node oldValue, Node newValue) {
            if (oldValue != newValue) {
                InfiniteCanvasViewer.this.onFocusOwnerChanged(oldValue, newValue);
            }
        }
    };
    private ChangeListener<Boolean> focusOwnerFocusedObserver = new ChangeListener<Boolean>(){

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (observable == InfiniteCanvasViewer.this.getCanvas().getScene().getFocusOwner() && (oldValue == null ? newValue != null : !oldValue.equals(newValue))) {
                InfiniteCanvasViewer.this.onFocusOwnerFocusedChanged(oldValue, newValue);
            }
        }
    };
    private ChangeListener<Scene> sceneListener = new ChangeListener<Scene>(){

        public void changed(ObservableValue<? extends Scene> observable, Scene oldValue, Scene newValue) {
            InfiniteCanvasViewer.this.onSceneChanged(oldValue, newValue);
        }
    };
    private ActivatableSupport acs = new ActivatableSupport((IActivatable)this);
    private AdaptableSupport<IViewer> ads = new AdaptableSupport((IAdaptable)this);
    private ObservableMap<Object, IContentPart<? extends Node>> contentPartMap = FXCollections.observableMap(new IdentityHashMap());
    private ReadOnlyMapProperty<Object, IContentPart<? extends Node>> contentPartMapProperty;
    private ObservableMap<Node, IVisualPart<? extends Node>> visualPartMap = FXCollections.observableMap(new IdentityHashMap());
    private ReadOnlyMapProperty<Node, IVisualPart<? extends Node>> visualPartMapProperty;
    private ReadOnlyObjectWrapper<IDomain> domainProperty = new ReadOnlyObjectWrapper();

    public InfiniteCanvasViewer() {
        this.viewerFocusedProperty.bind((ObservableValue)this.viewerFocusedPropertyBinding);
    }

    public final void activate() {
        this.acs.activate(null, this::doActivate);
    }

    protected void activateAdapters() {
        new TreeMap(this.ads.getAdapters()).values().forEach(adapter -> {
            if (adapter instanceof IActivatable) {
                ((IActivatable)adapter).activate();
            }
        });
    }

    public final ReadOnlyBooleanProperty activeProperty() {
        return this.acs.activeProperty();
    }

    public ReadOnlyObjectProperty<IDomain> adaptableProperty() {
        return this.domainProperty.getReadOnlyProperty();
    }

    public ReadOnlyMapProperty<AdapterKey<?>, Object> adaptersProperty() {
        return this.ads.adaptersProperty();
    }

    @Override
    public ReadOnlyMapProperty<Object, IContentPart<? extends Node>> contentPartMapProperty() {
        if (this.contentPartMapProperty == null) {
            this.contentPartMapProperty = new ReadOnlyMapWrapperEx((Object)this, "contentPartMap", this.contentPartMap);
        }
        return this.contentPartMapProperty;
    }

    @Override
    public ReadOnlyListProperty<Object> contentsProperty() {
        return this.contentsProperty.getReadOnlyProperty();
    }

    public final void deactivate() {
        this.acs.deactivate(this::doDeactivate, null);
    }

    protected void deactivateAdapters() {
        new TreeMap(this.ads.getAdapters()).values().forEach(adapter -> {
            if (adapter instanceof IActivatable) {
                ((IActivatable)adapter).deactivate();
            }
        });
    }

    public void dispose() {
        if (this.infiniteCanvas != null) {
            if (this.infiniteCanvas.getScene() != null) {
                this.onSceneChanged(this.infiniteCanvas.getScene(), null);
            }
            this.infiniteCanvas.sceneProperty().removeListener(this.sceneListener);
            this.infiniteCanvas = null;
        }
        this.viewerFocusedProperty.unbind();
        this.viewerFocusedProperty = null;
        this.ads.dispose();
        this.ads = null;
        if (!this.contentPartMap.isEmpty()) {
            throw new IllegalStateException("Content part map was not properly cleared!");
        }
        this.contentPartMap = null;
        if (!this.visualPartMap.isEmpty()) {
            throw new IllegalStateException("Visual part map was not properly cleared!");
        }
        this.visualPartMap = null;
        this.acs = null;
    }

    protected void doActivate() {
        if (this.getDomain() == null) {
            throw new IllegalStateException("Domain has to be set before activation.");
        }
        if (this.getRootPart() == null) {
            throw new IllegalStateException("RootPart has to be set before activation.");
        }
        if (this.infiniteCanvas == null || this.infiniteCanvas.getScene() == null) {
            throw new IllegalStateException("Viewer controls have to be hooked (to scene) before activation.");
        }
        this.activateAdapters();
    }

    protected void doDeactivate() {
        this.deactivateAdapters();
    }

    public IDomain getAdaptable() {
        return (IDomain)this.domainProperty.get();
    }

    public <T> T getAdapter(AdapterKey<T> key) {
        return (T)this.ads.getAdapter(key);
    }

    public <T> T getAdapter(Class<T> classKey) {
        return (T)this.ads.getAdapter(classKey);
    }

    public <T> T getAdapter(TypeToken<T> key) {
        return (T)this.ads.getAdapter(key);
    }

    public <T> AdapterKey<T> getAdapterKey(T adapter) {
        return this.ads.getAdapterKey(adapter);
    }

    public ObservableMap<AdapterKey<?>, Object> getAdapters() {
        return this.ads.getAdapters();
    }

    public <T> Map<AdapterKey<? extends T>, T> getAdapters(Class<? super T> classKey) {
        return this.ads.getAdapters(classKey);
    }

    public <T> Map<AdapterKey<? extends T>, T> getAdapters(TypeToken<? super T> key) {
        return this.ads.getAdapters(key);
    }

    public InfiniteCanvas getCanvas() {
        if (this.infiniteCanvas == null) {
            this.infiniteCanvas = new InfiniteCanvas();
            this.infiniteCanvas.sceneProperty().addListener(this.sceneListener);
            IRootPart<? extends Node> rootPart = this.getRootPart();
            this.infiniteCanvas.getContentGroup().getChildren().addAll((Object[])new Node[]{(Parent)rootPart.getVisual()});
        }
        return this.infiniteCanvas;
    }

    @Override
    public Map<Object, IContentPart<? extends Node>> getContentPartMap() {
        return this.contentPartMap;
    }

    @Override
    public ObservableList<Object> getContents() {
        return this.contents;
    }

    @Override
    public IDomain getDomain() {
        return (IDomain)this.domainProperty.get();
    }

    @Override
    public IRootPart<? extends Node> getRootPart() {
        return (IRootPart)this.ads.getAdapter((TypeToken)new TypeToken<IRootPart<? extends Node>>(){});
    }

    public Scene getScene() {
        return this.getCanvas().getScene();
    }

    @Override
    public Map<Node, IVisualPart<? extends Node>> getVisualPartMap() {
        return this.visualPartMap;
    }

    public final boolean isActive() {
        return this.acs.isActive();
    }

    @Override
    public boolean isViewerFocused() {
        return this.viewerFocusedProperty.get();
    }

    private void onFocusOwnerChanged(Node oldFocusOwner, Node newFocusOwner) {
        if (oldFocusOwner != null && NodeUtils.isNested((Parent)this.getCanvas(), (Node)oldFocusOwner)) {
            oldFocusOwner.focusedProperty().removeListener(this.focusOwnerFocusedObserver);
        }
        if (newFocusOwner != null && NodeUtils.isNested((Parent)this.getCanvas(), (Node)newFocusOwner)) {
            newFocusOwner.focusedProperty().addListener(this.focusOwnerFocusedObserver);
            if (Boolean.TRUE.equals(newFocusOwner.focusedProperty().get())) {
                this.isFocusOwnerFocused = true;
                this.viewerFocusedPropertyBinding.invalidate();
            }
        } else {
            this.isFocusOwnerFocused = false;
            this.viewerFocusedPropertyBinding.invalidate();
        }
    }

    private void onFocusOwnerFocusedChanged(Boolean oldValue, Boolean newValue) {
        this.isFocusOwnerFocused = Boolean.TRUE.equals(newValue);
        this.viewerFocusedPropertyBinding.invalidate();
    }

    private void onSceneChanged(Scene oldScene, Scene newScene) {
        Window oldWindow = null;
        Window newWindow = null;
        Node oldFocusOwner = null;
        Node newFocusOwner = null;
        if (oldScene != null) {
            oldWindow = (Window)oldScene.windowProperty().get();
            oldScene.windowProperty().removeListener(this.windowObserver);
            oldFocusOwner = (Node)oldScene.focusOwnerProperty().get();
            oldScene.focusOwnerProperty().removeListener(this.focusOwnerObserver);
        }
        if (newScene != null) {
            newWindow = (Window)newScene.windowProperty().get();
            newScene.windowProperty().addListener(this.windowObserver);
            newFocusOwner = (Node)newScene.focusOwnerProperty().get();
            newScene.focusOwnerProperty().addListener(this.focusOwnerObserver);
        }
        this.onWindowChanged(oldWindow, newWindow);
        this.onFocusOwnerChanged(oldFocusOwner, newFocusOwner);
    }

    private void onWindowChanged(Window oldValue, Window newValue) {
        if (oldValue != null) {
            oldValue.focusedProperty().removeListener(this.windowFocusedObserver);
        }
        if (newValue != null) {
            newValue.focusedProperty().addListener(this.windowFocusedObserver);
            if (Boolean.TRUE.equals(newValue.focusedProperty().get())) {
                this.isWindowFocused = true;
                this.viewerFocusedPropertyBinding.invalidate();
            }
        } else {
            this.isInitialized = false;
            this.isWindowFocused = false;
            this.viewerFocusedPropertyBinding.invalidate();
        }
    }

    private void onWindowFocusedChanged(Boolean oldValue, Boolean newValue) {
        this.isWindowFocused = Boolean.TRUE.equals(newValue);
        this.viewerFocusedPropertyBinding.invalidate();
        if (!this.isInitialized) {
            this.getRootPart().getVisual().requestFocus();
            this.isInitialized = true;
        }
    }

    @Override
    public void reveal(IVisualPart<? extends Node> visualPart) {
        if (visualPart == null) {
            this.getCanvas().setHorizontalScrollOffset(0.0);
            this.getCanvas().setVerticalScrollOffset(0.0);
        } else {
            this.getCanvas().reveal(visualPart.getVisual());
        }
    }

    public void setAdaptable(IDomain domain) {
        this.domainProperty.set((Object)domain);
    }

    public <T> void setAdapter(T adapter) {
        this.ads.setAdapter(adapter);
    }

    public <T> void setAdapter(T adapter, String role) {
        this.ads.setAdapter(adapter, role);
    }

    public <T> void setAdapter(TypeToken<T> adapterType, T adapter) {
        this.ads.setAdapter(adapterType, adapter);
    }

    @InjectAdapters
    public <T> void setAdapter(TypeToken<T> adapterType, T adapter, String role) {
        this.ads.setAdapter(adapterType, adapter, role);
    }

    public <T> void unsetAdapter(T adapter) {
        this.ads.unsetAdapter(adapter);
    }

    @Override
    public ReadOnlyBooleanProperty viewerFocusedProperty() {
        return this.viewerFocusedProperty.getReadOnlyProperty();
    }

    @Override
    public ReadOnlyMapProperty<Node, IVisualPart<? extends Node>> visualPartMapProperty() {
        if (this.visualPartMapProperty == null) {
            this.visualPartMapProperty = new ReadOnlyMapWrapperEx((Object)this, "visualPartMap", this.visualPartMap);
        }
        return this.visualPartMapProperty;
    }
}

