/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.zest.fx.behaviors;

import javafx.geometry.Bounds;
import javafx.scene.transform.Affine;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.graph.Node;
import org.eclipse.gef.layout.LayoutContext;
import org.eclipse.gef.layout.LayoutProperties;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.zest.fx.ZestProperties;
import org.eclipse.gef.zest.fx.behaviors.AbstractLayoutBehavior;
import org.eclipse.gef.zest.fx.behaviors.GraphLayoutBehavior;
import org.eclipse.gef.zest.fx.parts.NodePart;

public class NodeLayoutBehavior
extends AbstractLayoutBehavior {
    private Dimension preLayoutSize = null;

    public NodePart getHost() {
        return (NodePart)super.getHost();
    }

    @Override
    protected LayoutContext getLayoutContext() {
        IContentPart graphPart = (IContentPart)this.getHost().getRoot().getViewer().getContentPartMap().get(this.getHost().getContent().getGraph());
        return ((GraphLayoutBehavior)((Object)graphPart.getAdapter(GraphLayoutBehavior.class))).getLayoutContext();
    }

    @Override
    protected void postLayout() {
        Point postLayoutLocation;
        Node content = this.getHost().getContent();
        Dimension postLayoutSize = LayoutProperties.getSize((Node)content);
        if (postLayoutSize != null) {
            ZestProperties.setSize(content, postLayoutSize);
        }
        if ((postLayoutLocation = LayoutProperties.getLocation((Node)content)) != null) {
            ZestProperties.setPosition(content, postLayoutLocation.getTranslated((postLayoutSize == null ? this.preLayoutSize : postLayoutSize).getScaled(0.5).getNegated()));
        }
        this.getHost().refreshVisual();
        this.updateLabels();
    }

    @Override
    protected void preLayout() {
        Node content = this.getHost().getContent();
        javafx.scene.Node visual = this.getHost().getVisual();
        Bounds hostBounds = visual.getLayoutBounds();
        double minx = hostBounds.getMinX();
        double miny = hostBounds.getMinY();
        double maxx = hostBounds.getMaxX();
        double maxy = hostBounds.getMaxY();
        Affine transform = this.getHost().getVisualTransform();
        this.preLayoutSize = ZestProperties.getSize(content) != null ? ZestProperties.getSize(content).getCopy() : new Dimension(maxx - minx, maxy - miny);
        LayoutProperties.setSize((Node)content, (Dimension)this.preLayoutSize.getCopy());
        if (ZestProperties.getPosition(content) != null) {
            LayoutProperties.setLocation((Node)content, (Point)ZestProperties.getPosition(content).getTranslated(this.preLayoutSize.getScaled(0.5)));
        } else {
            LayoutProperties.setLocation((Node)content, (Point)new Point(transform.getTx() + minx + (maxx - minx) / 2.0, transform.getTy() + miny + (maxy - miny) / 2.0));
        }
        LayoutProperties.setResizable((Node)content, (boolean)visual.isResizable());
    }
}

