/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.zest.fx.parts;

import java.util.Collections;
import java.util.List;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import javafx.geometry.Bounds;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.text.Text;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import javafx.util.Pair;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.common.attributes.IAttributeStore;
import org.eclipse.gef.fx.listeners.VisualChangeListener;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.mvc.fx.operations.TransformVisualOperation;
import org.eclipse.gef.mvc.fx.parts.AbstractContentPart;
import org.eclipse.gef.mvc.fx.parts.ITransformableContentPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;

public abstract class AbstractLabelPart
extends AbstractContentPart<Group>
implements ITransformableContentPart<Group> {
    public static final String CSS_CLASS_LABEL = "label";
    private VisualChangeListener vcl = new VisualChangeListener(){

        protected void boundsInLocalChanged(Bounds oldBounds, Bounds newBounds) {
            AbstractLabelPart.this.refreshVisual();
        }

        protected void localToParentTransformChanged(Node observed, Transform oldTransform, Transform newTransform) {
            AbstractLabelPart.this.refreshVisual();
        }
    };
    private MapChangeListener<String, Object> elementAttributesObserver = new MapChangeListener<String, Object>(){

        public void onChanged(MapChangeListener.Change<? extends String, ? extends Object> change) {
            AbstractLabelPart.this.refreshVisual();
        }
    };
    private Text text;

    public abstract Point computeLabelPosition();

    protected Text createText() {
        this.text = new Text();
        this.text.setTextOrigin(VPos.TOP);
        this.text.setManaged(false);
        this.text.setPickOnBounds(true);
        this.text.getStyleClass().add((Object)CSS_CLASS_LABEL);
        return this.text;
    }

    protected void doActivate() {
        super.doActivate();
        ((IAttributeStore)this.getContent().getKey()).attributesProperty().addListener(this.elementAttributesObserver);
    }

    protected void doAttachToAnchorageVisual(IVisualPart<? extends Node> anchorage, String role) {
        this.vcl.register(anchorage.getVisual(), this.getVisual());
        this.setLabelPosition(this.computeLabelPosition());
    }

    protected void doDeactivate() {
        ((IAttributeStore)this.getContent().getKey()).attributesProperty().removeListener(this.elementAttributesObserver);
        super.doDeactivate();
    }

    protected void doDetachFromAnchorageVisual(IVisualPart<? extends Node> anchorage, String role) {
        this.vcl.unregister();
    }

    protected List<? extends Object> doGetContentChildren() {
        return Collections.emptyList();
    }

    public Pair<? extends IAttributeStore, String> getContent() {
        return (Pair)super.getContent();
    }

    public Affine getContentTransform() {
        Point p = this.getLabelPosition();
        if (p == null) {
            p = new Point();
        }
        return new Affine((Transform)new Translate(p.x, p.y));
    }

    private String getLabelPositionAttributeKey() {
        String labelRole = (String)this.getContent().getValue();
        String attributeKey = null;
        if ("element-external-label".equals(labelRole)) {
            attributeKey = "element-external-label-position";
        } else if ("element-label".equals(labelRole)) {
            attributeKey = "edge-label-position";
        } else if ("edge-source-label".equals(labelRole)) {
            attributeKey = "edge-source-label-position";
        } else if ("edge-target-label".equals(labelRole)) {
            attributeKey = "edge-target-label-position";
        } else {
            throw new IllegalArgumentException("Unsupported content element.");
        }
        return attributeKey;
    }

    public Point getLabelPosition() {
        String key = this.getLabelPositionAttributeKey();
        ObservableMap attributes = ((IAttributeStore)this.getContent().getKey()).getAttributes();
        if (!attributes.containsKey((Object)key)) {
            return null;
        }
        return (Point)attributes.get((Object)key);
    }

    protected Text getText() {
        return this.text;
    }

    protected void refreshPosition(Node visual, Point position) {
        if (position != null) {
            TransformVisualOperation refreshPositionOp = new TransformVisualOperation((ITransformableContentPart)this, new Affine((Transform)new Translate(position.x, position.y)));
            try {
                refreshPositionOp.execute(null, null);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    public void setContentTransform(Affine transform) {
        this.setLabelPosition(new Point(transform.getTx(), transform.getTy()));
    }

    public void setLabelPosition(Point computedPosition) {
        ((IAttributeStore)this.getContent().getKey()).getAttributes().put((Object)this.getLabelPositionAttributeKey(), (Object)computedPosition);
    }
}

