/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.zest.fx.parts;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import org.eclipse.gef.geometry.planar.BezierCurve;
import org.eclipse.gef.mvc.fx.parts.DefaultHoverHandlePartFactory;
import org.eclipse.gef.mvc.fx.parts.IHandlePart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.zest.fx.models.HidingModel;
import org.eclipse.gef.zest.fx.parts.HideHoverHandlePart;
import org.eclipse.gef.zest.fx.parts.NodePart;
import org.eclipse.gef.zest.fx.parts.ShowHiddenNeighborsHoverHandlePart;

public class ZestFxHoverHandlePartFactory
extends DefaultHoverHandlePartFactory {
    @Inject
    private Injector injector;

    protected List<IHandlePart<? extends Node>> createHoverHandlePartsForPolygonalOutline(IVisualPart<? extends Node> target, Map<Object, Object> contextMap, Provider<BezierCurve[]> segmentsProvider) {
        ArrayList<IHandlePart<? extends Node>> handleParts = new ArrayList<IHandlePart<? extends Node>>();
        if (target instanceof NodePart) {
            HideHoverHandlePart hidePart = (HideHoverHandlePart)((Object)this.injector.getInstance(HideHoverHandlePart.class));
            hidePart.setSegmentsProvider(segmentsProvider);
            hidePart.setSegmentIndex(0);
            hidePart.setSegmentParameter(0.0);
            handleParts.add((IHandlePart<? extends Node>)hidePart);
            HidingModel hidingModel = (HidingModel)target.getRoot().getViewer().getAdapter(HidingModel.class);
            if (hidingModel.hasHiddenNeighbors((NodePart)target)) {
                ShowHiddenNeighborsHoverHandlePart showPart = (ShowHiddenNeighborsHoverHandlePart)((Object)this.injector.getInstance(ShowHiddenNeighborsHoverHandlePart.class));
                showPart.setSegmentsProvider(segmentsProvider);
                showPart.setSegmentIndex(1);
                showPart.setSegmentParameter(0.0);
                handleParts.add((IHandlePart<? extends Node>)showPart);
            }
        }
        return handleParts;
    }

    protected List<IHandlePart<? extends Node>> createHoverHandlePartsForRectangularOutline(IVisualPart<? extends Node> target, Map<Object, Object> contextMap, Provider<BezierCurve[]> segmentsProvider) {
        return this.createHoverHandlePartsForPolygonalOutline(target, contextMap, segmentsProvider);
    }
}

