/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.zest.fx.policies;

import com.google.common.reflect.TypeToken;
import java.util.Collections;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.gef.mvc.fx.models.FocusModel;
import org.eclipse.gef.mvc.fx.operations.AbstractCompositeOperation;
import org.eclipse.gef.mvc.fx.operations.ChangeFocusOperation;
import org.eclipse.gef.mvc.fx.operations.DeselectOperation;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.operations.ReverseUndoCompositeOperation;
import org.eclipse.gef.mvc.fx.policies.AbstractTransactionPolicy;
import org.eclipse.gef.mvc.fx.viewer.IViewer;
import org.eclipse.gef.zest.fx.operations.HideOperation;
import org.eclipse.gef.zest.fx.parts.NodePart;

public class HidePolicy
extends AbstractTransactionPolicy {
    protected ITransactionalOperation createDeselectOperation(NodePart part) {
        return new DeselectOperation(part.getRoot().getViewer(), Collections.singletonList(part));
    }

    protected ITransactionalOperation createHideOperation(NodePart part) {
        return new HideOperation(part.getRoot().getViewer(), part);
    }

    protected ITransactionalOperation createOperation() {
        return new ReverseUndoCompositeOperation("Hide");
    }

    protected ITransactionalOperation createUnfocusOperation(NodePart part) {
        IViewer viewer = part.getRoot().getViewer();
        FocusModel focusModel = (FocusModel)viewer.getAdapter((TypeToken)new TypeToken<FocusModel>(){});
        if (focusModel != null && focusModel.getFocus() == part) {
            return new ChangeFocusOperation(viewer, null);
        }
        return null;
    }

    public NodePart getHost() {
        return (NodePart)super.getHost();
    }

    public void hide() {
        ITransactionalOperation hideOperation;
        ITransactionalOperation deselectOperation;
        this.checkInitialized();
        AbstractCompositeOperation revOp = (AbstractCompositeOperation)this.getOperation();
        ITransactionalOperation unfocusOperation = this.createUnfocusOperation(this.getHost());
        if (unfocusOperation != null) {
            revOp.add((IUndoableOperation)unfocusOperation);
        }
        if ((deselectOperation = this.createDeselectOperation(this.getHost())) != null) {
            revOp.add((IUndoableOperation)deselectOperation);
        }
        if ((hideOperation = this.createHideOperation(this.getHost())) != null) {
            revOp.add((IUndoableOperation)hideOperation);
        }
        this.locallyExecuteOperation();
    }
}

