/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.zest.fx.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.parts.PartUtils;
import org.eclipse.gef.mvc.fx.policies.AbstractTransactionPolicy;
import org.eclipse.gef.mvc.fx.policies.TranslateSelectedOnDragPolicy;
import org.eclipse.gef.zest.fx.parts.AbstractLabelPart;
import org.eclipse.gef.zest.fx.parts.EdgePart;
import org.eclipse.gef.zest.fx.parts.NodePart;
import org.eclipse.gef.zest.fx.policies.TransformLabelPolicy;

public class TranslateSelectedAndRelocateLabelsOnDragPolicy
extends TranslateSelectedOnDragPolicy {
    private List<AbstractLabelPart> labelParts;

    public void abortDrag() {
        for (AbstractLabelPart lp : this.getLabelParts()) {
            this.rollback((AbstractTransactionPolicy)lp.getAdapter(TransformLabelPolicy.class));
            this.restoreRefreshVisuals((IVisualPart)lp);
        }
        super.abortDrag();
        this.labelParts = null;
    }

    protected List<AbstractLabelPart> computeLabelParts() {
        Set labelParts = Collections.newSetFromMap(new IdentityHashMap());
        List targetParts = this.getTargetParts();
        for (IVisualPart tp : targetParts) {
            if (tp instanceof NodePart) {
                labelParts.addAll(this.getNodeLabelParts((NodePart)tp));
                for (IVisualPart anchored : this.getHost().getAnchoredsUnmodifiable()) {
                    if (!(anchored instanceof EdgePart) || targetParts.contains(anchored)) continue;
                    labelParts.addAll(this.getEdgeLabelParts((EdgePart)anchored));
                }
                continue;
            }
            if (!(tp instanceof EdgePart)) continue;
            labelParts.addAll(this.getEdgeLabelParts((EdgePart)tp));
        }
        labelParts.removeAll(targetParts);
        return new ArrayList<AbstractLabelPart>(labelParts);
    }

    public void drag(MouseEvent e, Dimension delta) {
        super.drag(e, delta);
        for (AbstractLabelPart lp : this.getLabelParts()) {
            ((TransformLabelPolicy)((Object)lp.getAdapter(TransformLabelPolicy.class))).preserveLabelOffset();
        }
    }

    public void endDrag(MouseEvent e, Dimension delta) {
        for (AbstractLabelPart lp : this.getLabelParts()) {
            this.commit((AbstractTransactionPolicy)lp.getAdapter(TransformLabelPolicy.class));
            this.restoreRefreshVisuals((IVisualPart)lp);
        }
        super.endDrag(e, delta);
        this.labelParts = null;
    }

    private List<AbstractLabelPart> getEdgeLabelParts(EdgePart edgePart) {
        ArrayList<AbstractLabelPart> linked = new ArrayList<AbstractLabelPart>();
        linked.addAll(new ArrayList(PartUtils.filterParts((Collection)PartUtils.getAnchoreds((IVisualPart)edgePart, (String)"element-label"), AbstractLabelPart.class)));
        linked.addAll(new ArrayList(PartUtils.filterParts((Collection)PartUtils.getAnchoreds((IVisualPart)edgePart, (String)"element-external-label"), AbstractLabelPart.class)));
        linked.addAll(new ArrayList(PartUtils.filterParts((Collection)PartUtils.getAnchoreds((IVisualPart)edgePart, (String)"edge-source-label"), AbstractLabelPart.class)));
        linked.addAll(new ArrayList(PartUtils.filterParts((Collection)PartUtils.getAnchoreds((IVisualPart)edgePart, (String)"edge-target-label"), AbstractLabelPart.class)));
        return linked;
    }

    protected List<AbstractLabelPart> getLabelParts() {
        if (this.labelParts == null) {
            this.labelParts = this.computeLabelParts();
        }
        return this.labelParts;
    }

    private List<AbstractLabelPart> getNodeLabelParts(NodePart nodePart) {
        return new ArrayList<AbstractLabelPart>(PartUtils.filterParts((Collection)PartUtils.getAnchoreds((IVisualPart)nodePart, (String)"element-external-label"), AbstractLabelPart.class));
    }

    public void startDrag(MouseEvent e) {
        super.startDrag(e);
        for (AbstractLabelPart lp : this.getLabelParts()) {
            this.storeAndDisableRefreshVisuals((IVisualPart)lp);
            this.init((AbstractTransactionPolicy)lp.getAdapter(TransformLabelPolicy.class));
        }
    }
}

