/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.jansi.io;

public class Colors {
    public static final int[] DEFAULT_COLORS_256;
    private static final double epsilon = 0.008856451679035631;
    private static final double kappa = 903.2962962962963;

    static {
        int[] nArray = new int[256];
        nArray[1] = 0x800000;
        nArray[2] = 32768;
        nArray[3] = 0x808000;
        nArray[4] = 128;
        nArray[5] = 0x800080;
        nArray[6] = 32896;
        nArray[7] = 0xC0C0C0;
        nArray[8] = 0x808080;
        nArray[9] = 0xFF0000;
        nArray[10] = 65280;
        nArray[11] = 0xFFFF00;
        nArray[12] = 255;
        nArray[13] = 0xFF00FF;
        nArray[14] = 65535;
        nArray[15] = 0xFFFFFF;
        nArray[17] = 95;
        nArray[18] = 135;
        nArray[19] = 175;
        nArray[20] = 215;
        nArray[21] = 255;
        nArray[22] = 24320;
        nArray[23] = 24415;
        nArray[24] = 24455;
        nArray[25] = 24495;
        nArray[26] = 24535;
        nArray[27] = 24575;
        nArray[28] = 34560;
        nArray[29] = 34655;
        nArray[30] = 34695;
        nArray[31] = 34735;
        nArray[32] = 34775;
        nArray[33] = 34815;
        nArray[34] = 44800;
        nArray[35] = 44895;
        nArray[36] = 44935;
        nArray[37] = 44975;
        nArray[38] = 45015;
        nArray[39] = 45055;
        nArray[40] = 55040;
        nArray[41] = 55135;
        nArray[42] = 55175;
        nArray[43] = 55215;
        nArray[44] = 55255;
        nArray[45] = 55295;
        nArray[46] = 65280;
        nArray[47] = 65375;
        nArray[48] = 65415;
        nArray[49] = 65455;
        nArray[50] = 65495;
        nArray[51] = 65535;
        nArray[52] = 0x5F0000;
        nArray[53] = 0x5F005F;
        nArray[54] = 6226055;
        nArray[55] = 6226095;
        nArray[56] = 6226135;
        nArray[57] = 0x5F00FF;
        nArray[58] = 0x5F5F00;
        nArray[59] = 0x5F5F5F;
        nArray[60] = 6250375;
        nArray[61] = 0x5F5FAF;
        nArray[62] = 6250455;
        nArray[63] = 0x5F5FFF;
        nArray[64] = 6260480;
        nArray[65] = 6260575;
        nArray[66] = 6260615;
        nArray[67] = 6260655;
        nArray[68] = 6260695;
        nArray[69] = 6260735;
        nArray[70] = 6270720;
        nArray[71] = 0x5FAF5F;
        nArray[72] = 6270855;
        nArray[73] = 0x5FAFAF;
        nArray[74] = 6270935;
        nArray[75] = 0x5FAFFF;
        nArray[76] = 6280960;
        nArray[77] = 6281055;
        nArray[78] = 6281095;
        nArray[79] = 6281135;
        nArray[80] = 6281175;
        nArray[81] = 6281215;
        nArray[82] = 0x5FFF00;
        nArray[83] = 0x5FFF5F;
        nArray[84] = 6291335;
        nArray[85] = 0x5FFFAF;
        nArray[86] = 6291415;
        nArray[87] = 0x5FFFFF;
        nArray[88] = 0x870000;
        nArray[89] = 8847455;
        nArray[90] = 0x870087;
        nArray[91] = 8847535;
        nArray[92] = 8847575;
        nArray[93] = 8847615;
        nArray[94] = 8871680;
        nArray[95] = 8871775;
        nArray[96] = 8871815;
        nArray[97] = 8871855;
        nArray[98] = 8871895;
        nArray[99] = 8871935;
        nArray[100] = 0x878700;
        nArray[101] = 8882015;
        nArray[102] = 0x878787;
        nArray[103] = 8882095;
        nArray[104] = 0x8787D7;
        nArray[105] = 0x8787FF;
        nArray[106] = 8892160;
        nArray[107] = 8892255;
        nArray[108] = 8892295;
        nArray[109] = 8892335;
        nArray[110] = 8892375;
        nArray[111] = 8892415;
        nArray[112] = 8902400;
        nArray[113] = 8902495;
        nArray[114] = 0x87D787;
        nArray[115] = 8902575;
        nArray[116] = 0x87D7D7;
        nArray[117] = 8902655;
        nArray[118] = 8912640;
        nArray[119] = 8912735;
        nArray[120] = 0x87FF87;
        nArray[121] = 8912815;
        nArray[122] = 8912855;
        nArray[123] = 0x87FFFF;
        nArray[124] = 0xAF0000;
        nArray[125] = 11468895;
        nArray[126] = 11468935;
        nArray[127] = 0xAF00AF;
        nArray[128] = 11469015;
        nArray[129] = 0xAF00FF;
        nArray[130] = 11493120;
        nArray[131] = 0xAF5F5F;
        nArray[132] = 11493255;
        nArray[133] = 0xAF5FAF;
        nArray[134] = 11493335;
        nArray[135] = 0xAF5FFF;
        nArray[136] = 11503360;
        nArray[137] = 11503455;
        nArray[138] = 11503495;
        nArray[139] = 11503535;
        nArray[140] = 11503575;
        nArray[141] = 11503615;
        nArray[142] = 0xAFAF00;
        nArray[143] = 0xAFAF5F;
        nArray[144] = 11513735;
        nArray[145] = 0xAFAFAF;
        nArray[146] = 11513815;
        nArray[147] = 0xAFAFFF;
        nArray[148] = 11523840;
        nArray[149] = 11523935;
        nArray[150] = 11523975;
        nArray[151] = 11524015;
        nArray[152] = 11524055;
        nArray[153] = 11524095;
        nArray[154] = 0xAFFF00;
        nArray[155] = 0xAFFF5F;
        nArray[156] = 11534215;
        nArray[157] = 0xAFFFAF;
        nArray[158] = 11534295;
        nArray[159] = 0xAFFFFF;
        nArray[160] = 0xD70000;
        nArray[161] = 14090335;
        nArray[162] = 14090375;
        nArray[163] = 14090415;
        nArray[164] = 0xD700D7;
        nArray[165] = 14090495;
        nArray[166] = 14114560;
        nArray[167] = 14114655;
        nArray[168] = 14114695;
        nArray[169] = 14114735;
        nArray[170] = 14114775;
        nArray[171] = 14114815;
        nArray[172] = 14124800;
        nArray[173] = 14124895;
        nArray[174] = 0xD78787;
        nArray[175] = 14124975;
        nArray[176] = 0xD787D7;
        nArray[177] = 14125055;
        nArray[178] = 14135040;
        nArray[179] = 14135135;
        nArray[180] = 14135175;
        nArray[181] = 14135215;
        nArray[182] = 14135255;
        nArray[183] = 14135295;
        nArray[184] = 0xD7D700;
        nArray[185] = 14145375;
        nArray[186] = 0xD7D787;
        nArray[187] = 14145455;
        nArray[188] = 0xD7D7D7;
        nArray[189] = 0xD7D7FF;
        nArray[190] = 14155520;
        nArray[191] = 14155615;
        nArray[192] = 14155655;
        nArray[193] = 14155695;
        nArray[194] = 0xD7FFD7;
        nArray[195] = 0xD7FFFF;
        nArray[196] = 0xFF0000;
        nArray[197] = 0xFF005F;
        nArray[198] = 16711815;
        nArray[199] = 0xFF00AF;
        nArray[200] = 16711895;
        nArray[201] = 0xFF00FF;
        nArray[202] = 0xFF5F00;
        nArray[203] = 0xFF5F5F;
        nArray[204] = 16736135;
        nArray[205] = 0xFF5FAF;
        nArray[206] = 16736215;
        nArray[207] = 0xFF5FFF;
        nArray[208] = 16746240;
        nArray[209] = 16746335;
        nArray[210] = 0xFF8787;
        nArray[211] = 16746415;
        nArray[212] = 16746455;
        nArray[213] = 0xFF87FF;
        nArray[214] = 0xFFAF00;
        nArray[215] = 0xFFAF5F;
        nArray[216] = 16756615;
        nArray[217] = 0xFFAFAF;
        nArray[218] = 16756695;
        nArray[219] = 0xFFAFFF;
        nArray[220] = 16766720;
        nArray[221] = 16766815;
        nArray[222] = 16766855;
        nArray[223] = 16766895;
        nArray[224] = 0xFFD7D7;
        nArray[225] = 0xFFD7FF;
        nArray[226] = 0xFFFF00;
        nArray[227] = 0xFFFF5F;
        nArray[228] = 0xFFFF87;
        nArray[229] = 0xFFFFAF;
        nArray[230] = 0xFFFFD7;
        nArray[231] = 0xFFFFFF;
        nArray[232] = 526344;
        nArray[233] = 0x121212;
        nArray[234] = 0x1C1C1C;
        nArray[235] = 0x262626;
        nArray[236] = 0x303030;
        nArray[237] = 0x3A3A3A;
        nArray[238] = 0x444444;
        nArray[239] = 0x4E4E4E;
        nArray[240] = 0x585858;
        nArray[241] = 0x626262;
        nArray[242] = 0x6C6C6C;
        nArray[243] = 0x767676;
        nArray[244] = 0x808080;
        nArray[245] = 0x8A8A8A;
        nArray[246] = 0x949494;
        nArray[247] = 0x9E9E9E;
        nArray[248] = 0xA8A8A8;
        nArray[249] = 0xB2B2B2;
        nArray[250] = 0xBCBCBC;
        nArray[251] = 0xC6C6C6;
        nArray[252] = 0xD0D0D0;
        nArray[253] = 0xDADADA;
        nArray[254] = 0xE4E4E4;
        nArray[255] = 0xEEEEEE;
        DEFAULT_COLORS_256 = nArray;
    }

    public static int roundColor(int col, int max) {
        if (col >= max) {
            int c = DEFAULT_COLORS_256[col];
            col = Colors.roundColor(c, DEFAULT_COLORS_256, max);
        }
        return col;
    }

    public static int roundRgbColor(int r, int g, int b, int max) {
        return Colors.roundColor((r << 16) + (g << 8) + b, DEFAULT_COLORS_256, max);
    }

    private static int roundColor(int color, int[] colors, int max) {
        double best_distance = 2.147483647E9;
        int best_index = Integer.MAX_VALUE;
        int idx = 0;
        while (idx < max) {
            double d = Colors.cie76(color, colors[idx]);
            if (d <= best_distance) {
                best_index = idx;
                best_distance = d;
            }
            ++idx;
        }
        return best_index;
    }

    private static double cie76(int c1, int c2) {
        return Colors.scalar(Colors.rgb2cielab(c1), Colors.rgb2cielab(c2));
    }

    private static double scalar(double[] c1, double[] c2) {
        return Colors.sqr(c1[0] - c2[0]) + Colors.sqr(c1[1] - c2[1]) + Colors.sqr(c1[2] - c2[2]);
    }

    private static double[] rgb(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color >> 0 & 0xFF;
        return new double[]{(double)r / 255.0, (double)g / 255.0, (double)b / 255.0};
    }

    private static double[] rgb2cielab(int color) {
        return Colors.rgb2cielab(Colors.rgb(color));
    }

    private static double[] rgb2cielab(double[] rgb) {
        return Colors.xyz2lab(Colors.rgb2xyz(rgb));
    }

    private static double[] rgb2xyz(double[] rgb) {
        double vr = Colors.pivotRgb(rgb[0]);
        double vg = Colors.pivotRgb(rgb[1]);
        double vb = Colors.pivotRgb(rgb[2]);
        double x = vr * 0.4124564 + vg * 0.3575761 + vb * 0.1804375;
        double y = vr * 0.2126729 + vg * 0.7151522 + vb * 0.072175;
        double z = vr * 0.0193339 + vg * 0.119192 + vb * 0.9503041;
        return new double[]{x, y, z};
    }

    private static double pivotRgb(double n) {
        return n > 0.04045 ? Math.pow((n + 0.055) / 1.055, 2.4) : n / 12.92;
    }

    private static double[] xyz2lab(double[] xyz) {
        double fx = Colors.pivotXyz(xyz[0]);
        double fy = Colors.pivotXyz(xyz[1]);
        double fz = Colors.pivotXyz(xyz[2]);
        double l = 116.0 * fy - 16.0;
        double a = 500.0 * (fx - fy);
        double b = 200.0 * (fy - fz);
        return new double[]{l, a, b};
    }

    private static double pivotXyz(double n) {
        return n > 0.008856451679035631 ? Math.cbrt(n) : (903.2962962962963 * n + 16.0) / 116.0;
    }

    private static double sqr(double n) {
        return n * n;
    }
}

