/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.glassfish.hk2.api.Unqualified;
import org.glassfish.hk2.utilities.general.GeneralUtilities;
import org.glassfish.hk2.utilities.reflection.Pretty;
import org.glassfish.hk2.utilities.reflection.ReflectionHelper;

public class CacheKey {
    private final String removalName;
    private final Type lookupType;
    private final String name;
    private final Annotation[] qualifiers;
    private final Unqualified unqualified;
    private final int hashCode;

    public CacheKey(Type lookupType, String name, Unqualified unqualified, Annotation ... qualifiers) {
        this.lookupType = lookupType;
        Class rawClass = ReflectionHelper.getRawClass((Type)lookupType);
        this.removalName = rawClass != null ? rawClass.getName() : null;
        this.name = name;
        this.qualifiers = qualifiers.length > 0 ? qualifiers : null;
        this.unqualified = unqualified;
        int retVal = 0;
        if (lookupType != null) {
            retVal ^= lookupType.hashCode();
        }
        if (name != null) {
            retVal ^= name.hashCode();
        }
        Object[] objectArray = qualifiers;
        int n = qualifiers.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation anno = objectArray[n2];
            retVal ^= anno.hashCode();
            ++n2;
        }
        if (unqualified != null) {
            retVal ^= 0xFFFFFFFF;
            objectArray = unqualified.value();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object clazz = objectArray[n2];
                retVal ^= clazz.hashCode();
                ++n2;
            }
        }
        this.hashCode = retVal;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof CacheKey)) {
            return false;
        }
        final CacheKey other = (CacheKey)o;
        if (this.hashCode != other.hashCode) {
            return false;
        }
        if (!GeneralUtilities.safeEquals((Object)this.lookupType, (Object)other.lookupType)) {
            return false;
        }
        if (!GeneralUtilities.safeEquals((Object)this.name, (Object)other.name)) {
            return false;
        }
        if (this.qualifiers != null) {
            if (other.qualifiers == null) {
                return false;
            }
            if (this.qualifiers.length != other.qualifiers.length) {
                return false;
            }
            boolean isEqual = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    int lcv = 0;
                    while (lcv < CacheKey.this.qualifiers.length) {
                        if (!GeneralUtilities.safeEquals((Object)CacheKey.this.qualifiers[lcv], (Object)other.qualifiers[lcv])) {
                            return false;
                        }
                        ++lcv;
                    }
                    return true;
                }
            });
            if (!isEqual) {
                return false;
            }
        } else if (other.qualifiers != null) {
            return false;
        }
        if (this.unqualified != null) {
            Class[] otherClazzes;
            if (other.unqualified == null) {
                return false;
            }
            Class[] myClazzes = this.unqualified.value();
            if (myClazzes.length != (otherClazzes = other.unqualified.value()).length) {
                return false;
            }
            int lcv = 0;
            while (lcv < myClazzes.length) {
                if (!GeneralUtilities.safeEquals((Object)myClazzes[lcv], (Object)otherClazzes[lcv])) {
                    return false;
                }
                ++lcv;
            }
        } else if (other.unqualified != null) {
            return false;
        }
        return true;
    }

    public boolean matchesRemovalName(String name) {
        if (this.removalName == null) {
            return false;
        }
        if (name == null) {
            return false;
        }
        return this.removalName.equals(name);
    }

    public String toString() {
        return "CacheKey(" + Pretty.type((Type)this.lookupType) + "," + this.name + "," + (this.qualifiers == null ? 0 : this.qualifiers.length) + "," + System.identityHashCode(this) + "," + this.hashCode + ")";
    }
}

