/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.internal;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Qualifier;
import javax.inject.Scope;
import javax.inject.Singleton;
import org.aopalliance.intercept.ConstructorInterceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.ClassAnalyzer;
import org.glassfish.hk2.api.Context;
import org.glassfish.hk2.api.ContractIndicator;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DescriptorType;
import org.glassfish.hk2.api.DescriptorVisibility;
import org.glassfish.hk2.api.DynamicConfigurationListener;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.ErrorInformation;
import org.glassfish.hk2.api.ErrorService;
import org.glassfish.hk2.api.ErrorType;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.InstanceLifecycleListener;
import org.glassfish.hk2.api.InterceptionService;
import org.glassfish.hk2.api.MethodParameter;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.Proxiable;
import org.glassfish.hk2.api.ProxyCtl;
import org.glassfish.hk2.api.ProxyForSameScope;
import org.glassfish.hk2.api.Rank;
import org.glassfish.hk2.api.Self;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.Unproxiable;
import org.glassfish.hk2.api.Unqualified;
import org.glassfish.hk2.api.UseProxy;
import org.glassfish.hk2.api.ValidationService;
import org.glassfish.hk2.api.Visibility;
import org.glassfish.hk2.api.messaging.SubscribeTo;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.NamedImpl;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.glassfish.hk2.utilities.reflection.ClassReflectionHelper;
import org.glassfish.hk2.utilities.reflection.Constants;
import org.glassfish.hk2.utilities.reflection.MethodWrapper;
import org.glassfish.hk2.utilities.reflection.ParameterizedTypeImpl;
import org.glassfish.hk2.utilities.reflection.Pretty;
import org.glassfish.hk2.utilities.reflection.ReflectionHelper;
import org.glassfish.hk2.utilities.reflection.ScopeInfo;
import org.glassfish.hk2.utilities.reflection.TypeChecker;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.internal.AnnotatedElementAnnotationInfo;
import org.jvnet.hk2.internal.AutoActiveDescriptor;
import org.jvnet.hk2.internal.ClazzCreator;
import org.jvnet.hk2.internal.Collector;
import org.jvnet.hk2.internal.ConstantActiveDescriptor;
import org.jvnet.hk2.internal.ErrorInformationImpl;
import org.jvnet.hk2.internal.ErrorResults;
import org.jvnet.hk2.internal.FactoryCreator;
import org.jvnet.hk2.internal.NarrowResults;
import org.jvnet.hk2.internal.ServiceHandleImpl;
import org.jvnet.hk2.internal.ServiceLocatorImpl;
import org.jvnet.hk2.internal.SystemInjecteeImpl;
import org.jvnet.hk2.internal.ThreeThirtyResolver;

public class Utilities {
    private static final String USE_SOFT_REFERENCE_PROPERTY = "org.jvnet.hk2.properties.useSoftReference";
    static final boolean USE_SOFT_REFERENCE = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.parseBoolean(System.getProperty(Utilities.USE_SOFT_REFERENCE_PROPERTY, "true"));
        }
    });
    private static final AnnotationInformation DEFAULT_ANNOTATION_INFORMATION = new AnnotationInformation(Collections.emptySet(), false, false, null);
    private static final String PROVIDE_METHOD = "provide";
    private static final HashSet<String> NOT_INTERCEPTED = new HashSet();
    private static final Interceptors EMTPY_INTERCEPTORS;
    private static Boolean proxiesAvailable;

    static {
        NOT_INTERCEPTED.add(ServiceLocator.class.getName());
        NOT_INTERCEPTED.add(InstanceLifecycleListener.class.getName());
        NOT_INTERCEPTED.add(InjectionResolver.class.getName());
        NOT_INTERCEPTED.add(ErrorService.class.getName());
        NOT_INTERCEPTED.add(ClassAnalyzer.class.getName());
        NOT_INTERCEPTED.add(DynamicConfigurationListener.class.getName());
        NOT_INTERCEPTED.add(DynamicConfigurationService.class.getName());
        NOT_INTERCEPTED.add(InterceptionService.class.getName());
        NOT_INTERCEPTED.add(ValidationService.class.getName());
        NOT_INTERCEPTED.add(Context.class.getName());
        EMTPY_INTERCEPTORS = new Interceptors(){

            @Override
            public Map<Method, List<MethodInterceptor>> getMethodInterceptors() {
                return null;
            }

            @Override
            public List<ConstructorInterceptor> getConstructorInterceptors() {
                return null;
            }
        };
        proxiesAvailable = null;
    }

    public static ClassAnalyzer getClassAnalyzer(ServiceLocatorImpl sli, String analyzerName, Collector errorCollector) {
        return sli.getAnalyzer(analyzerName, errorCollector);
    }

    public static <T> Constructor<T> getConstructor(Class<T> implClass, ClassAnalyzer analyzer, Collector collector) {
        Constructor element = null;
        try {
            element = analyzer.getConstructor(implClass);
        }
        catch (MultiException me) {
            collector.addMultiException(me);
            return element;
        }
        catch (Throwable th) {
            collector.addThrowable(th);
            return element;
        }
        if (element == null) {
            collector.addThrowable((Throwable)((Object)new AssertionError((Object)("null return from getConstructor method of analyzer " + analyzer + " for class " + implClass.getName()))));
            return element;
        }
        final Constructor result = element;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                result.setAccessible(true);
                return null;
            }
        });
        return element;
    }

    public static Set<Method> getInitMethods(Class<?> implClass, ClassAnalyzer analyzer, Collector collector) {
        Set retVal;
        try {
            retVal = analyzer.getInitializerMethods(implClass);
        }
        catch (MultiException me) {
            collector.addMultiException(me);
            return Collections.emptySet();
        }
        catch (Throwable th) {
            collector.addThrowable(th);
            return Collections.emptySet();
        }
        if (retVal == null) {
            collector.addThrowable((Throwable)((Object)new AssertionError((Object)("null return from getInitializerMethods method of analyzer " + analyzer + " for class " + implClass.getName()))));
            return Collections.emptySet();
        }
        return retVal;
    }

    public static Set<Field> getInitFields(Class<?> implClass, ClassAnalyzer analyzer, Collector collector) {
        Set retVal;
        try {
            retVal = analyzer.getFields(implClass);
        }
        catch (MultiException me) {
            collector.addMultiException(me);
            return Collections.emptySet();
        }
        catch (Throwable th) {
            collector.addThrowable(th);
            return Collections.emptySet();
        }
        if (retVal == null) {
            collector.addThrowable((Throwable)((Object)new AssertionError((Object)("null return from getFields method of analyzer " + analyzer + " for class " + implClass.getName()))));
            return Collections.emptySet();
        }
        return retVal;
    }

    public static Method getPostConstruct(Class<?> implClass, ClassAnalyzer analyzer, Collector collector) {
        try {
            return analyzer.getPostConstructMethod(implClass);
        }
        catch (MultiException me) {
            collector.addMultiException(me);
            return null;
        }
        catch (Throwable th) {
            collector.addThrowable(th);
            return null;
        }
    }

    public static Method getPreDestroy(Class<?> implClass, ClassAnalyzer analyzer, Collector collector) {
        try {
            return analyzer.getPreDestroyMethod(implClass);
        }
        catch (MultiException me) {
            collector.addMultiException(me);
            return null;
        }
        catch (Throwable th) {
            collector.addThrowable(th);
            return null;
        }
    }

    public static Class<?> getFactoryAwareImplementationClass(ActiveDescriptor<?> descriptor) {
        if (descriptor.getDescriptorType().equals((Object)DescriptorType.CLASS)) {
            return descriptor.getImplementationClass();
        }
        return Utilities.getFactoryProductionClass(descriptor);
    }

    public static void checkLookupType(Class<?> checkMe) {
        if (!checkMe.isAnnotation()) {
            return;
        }
        if (checkMe.isAnnotationPresent(Scope.class)) {
            return;
        }
        if (checkMe.isAnnotationPresent(Qualifier.class)) {
            return;
        }
        throw new IllegalArgumentException("Lookup type " + checkMe + " must be a scope or annotation");
    }

    public static Class<?> translatePrimitiveType(Class<?> type) {
        Class translation = (Class)Constants.PRIMITIVE_MAP.get(type);
        if (translation == null) {
            return type;
        }
        return translation;
    }

    /*
     * Unable to fully structure code
     */
    public static void handleErrors(NarrowResults results, LinkedList<ErrorService> callThese) {
        collector = new Collector();
        for (ErrorResults errorResult : results.getErrors()) {
            block4: for (ErrorService eService : callThese) {
                try {
                    eService.onFailure((ErrorInformation)new ErrorInformationImpl(ErrorType.FAILURE_TO_REIFY, (Descriptor)errorResult.getDescriptor(), errorResult.getInjectee(), errorResult.getMe()));
                    continue;
                }
                catch (MultiException me) {
                    ** for (th : me.getErrors())
                }
lbl-1000:
                // 1 sources

                {
                    collector.addThrowable(th);
                    continue;
lbl11:
                    // 1 sources

                    continue block4;
                }
                catch (Throwable th) {
                    collector.addThrowable(th);
                }
            }
        }
        collector.throwIfErrors();
    }

    /*
     * Unable to fully structure code
     */
    public static Class<?> loadClass(String loadMe, Descriptor fromMe, Collector collector) {
        block8: {
            block7: {
                loader = fromMe.getLoader();
                if (loader == null) {
                    cl = Utilities.class.getClassLoader();
                    if (cl == null) {
                        cl = ClassLoader.getSystemClassLoader();
                    }
                    try {
                        return cl.loadClass(loadMe);
                    }
                    catch (Throwable th) {
                        collector.addThrowable(th);
                        return null;
                    }
                }
                try {
                    return loader.loadClass(loadMe);
                }
                catch (Throwable th) {
                    if (!(th instanceof MultiException)) break block7;
                    me = (MultiException)th;
                    ** for (th2 : me.getErrors())
                }
lbl-1000:
                // 1 sources

                {
                    collector.addThrowable(th2);
                    continue;
lbl19:
                    // 1 sources

                    break block8;
                }
            }
            collector.addThrowable(th);
        }
        return null;
    }

    public static Class<?> loadClass(String implementation, Injectee injectee) {
        AnnotatedElement parent;
        ClassLoader loader = injectee != null ? ((parent = injectee.getParent()) instanceof Constructor ? ((Constructor)parent).getDeclaringClass().getClassLoader() : (parent instanceof Method ? ((Method)parent).getDeclaringClass().getClassLoader() : (parent instanceof Field ? ((Field)parent).getDeclaringClass().getClassLoader() : injectee.getClass().getClassLoader()))) : Utilities.class.getClassLoader();
        try {
            return loader.loadClass(implementation);
        }
        catch (Throwable th) {
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            if (ccl != null) {
                try {
                    return ccl.loadClass(implementation);
                }
                catch (Throwable th2) {
                    MultiException me = new MultiException(th);
                    me.addError(th2);
                    throw me;
                }
            }
            throw new MultiException(th);
        }
    }

    public static Class<? extends Annotation> getInjectionResolverType(ActiveDescriptor<?> desc) {
        for (Type advertisedType : desc.getContractTypes()) {
            Class rawClass = ReflectionHelper.getRawClass((Type)advertisedType);
            if (!InjectionResolver.class.equals((Object)rawClass)) continue;
            if (!(advertisedType instanceof ParameterizedType)) {
                return null;
            }
            Type firstType = ReflectionHelper.getFirstTypeArgument((Type)advertisedType);
            if (!(firstType instanceof Class)) {
                return null;
            }
            Class retVal = (Class)firstType;
            if (!Annotation.class.isAssignableFrom(retVal)) {
                return null;
            }
            return retVal;
        }
        return null;
    }

    private static Class<?> getFactoryProductionClass(ActiveDescriptor<?> descriptor) {
        Class factoryClass = descriptor.getImplementationClass();
        Type factoryProvidedType = Utilities.getFactoryProductionType(factoryClass);
        Class retVal = ReflectionHelper.getRawClass((Type)factoryProvidedType);
        if (retVal == null && descriptor.getContractTypes().size() == 1) {
            Type contract = (Type)descriptor.getContractTypes().iterator().next();
            retVal = ReflectionHelper.getRawClass((Type)contract);
        }
        if (retVal == null) {
            throw new MultiException((Throwable)((Object)new AssertionError((Object)("Could not find true produced type of factory " + factoryClass.getName()))));
        }
        return retVal;
    }

    public static Type getFactoryProductionType(Class<?> factoryClass) {
        Set factoryTypes = ReflectionHelper.getTypeClosure(factoryClass, Collections.singleton(Factory.class.getName()));
        ParameterizedType parameterizedType = (ParameterizedType)factoryTypes.iterator().next();
        Type factoryProvidedType = parameterizedType.getActualTypeArguments()[0];
        return factoryProvidedType;
    }

    public static void checkFactoryType(Class<?> factoryClass, Collector collector) {
        Type[] typeArray = factoryClass.getGenericInterfaces();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type firstType;
            Type type = typeArray[n2];
            Class rawClass = ReflectionHelper.getRawClass((Type)type);
            if (rawClass != null && Factory.class.equals((Object)rawClass) && (firstType = ReflectionHelper.getFirstTypeArgument((Type)type)) instanceof WildcardType) {
                collector.addThrowable(new IllegalArgumentException("The class " + Pretty.clazz(factoryClass) + " has a Wildcard as its type"));
            }
            ++n2;
        }
    }

    private static boolean hasContract(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz.isAnnotationPresent(Contract.class)) {
            return true;
        }
        Annotation[] annotationArray = clazz.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation clazzAnnotation = annotationArray[n2];
            if (clazzAnnotation.annotationType().isAnnotationPresent(ContractIndicator.class)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static Set<Type> getAutoAdvertisedTypes(Type t) {
        LinkedHashSet<Type> retVal = new LinkedHashSet<Type>();
        retVal.add(t);
        Class rawClass = ReflectionHelper.getRawClass((Type)t);
        if (rawClass == null) {
            return retVal;
        }
        ContractsProvided provided = rawClass.getAnnotation(ContractsProvided.class);
        if (provided != null) {
            retVal.clear();
            Class[] classArray = provided.value();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class providedContract = classArray[n2];
                retVal.add(providedContract);
                ++n2;
            }
            return retVal;
        }
        Set allTypes = ReflectionHelper.getAllTypes((Type)t);
        for (Type candidate : allTypes) {
            if (!Utilities.hasContract(ReflectionHelper.getRawClass((Type)candidate))) continue;
            retVal.add(candidate);
        }
        return retVal;
    }

    public static <T> AutoActiveDescriptor<T> createAutoDescriptor(Class<T> clazz, ServiceLocatorImpl locator) throws MultiException, IllegalArgumentException, IllegalStateException {
        ProxyForSameScope pfss;
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        Collector collector = new Collector();
        Boolean proxy = null;
        Boolean proxyForSameScope = null;
        String serviceMetadata = null;
        String serviceName = null;
        Service serviceAnno = clazz.getAnnotation(Service.class);
        if (serviceAnno != null) {
            if (!"".equals(serviceAnno.name())) {
                serviceName = serviceAnno.name();
            }
            if (!"".equals(serviceAnno.metadata())) {
                serviceMetadata = serviceAnno.metadata();
            }
        }
        Set<Annotation> qualifiers = ReflectionHelper.getQualifierAnnotations(clazz);
        String name = ReflectionHelper.getNameFromAllQualifiers((Set)qualifiers, clazz);
        if (serviceName != null && name != null) {
            if (!serviceName.equals(name)) {
                throw new IllegalArgumentException("The class " + clazz.getName() + " has an @Service name of " + serviceName + " and has an @Named value of " + name + " which names do not match");
            }
        } else if (name == null && serviceName != null) {
            name = serviceName;
        }
        qualifiers = Utilities.getAllQualifiers(clazz, name, collector);
        Set<Type> contracts = Utilities.getAutoAdvertisedTypes(clazz);
        ScopeInfo scopeInfo = Utilities.getScopeInfo(clazz, null, collector);
        Class scope = scopeInfo.getAnnoType();
        String analyzerName = locator.getPerLocatorUtilities().getAutoAnalyzerName(clazz);
        ClazzCreator creator = new ClazzCreator(locator, clazz);
        HashMap<String, List<String>> metadata = new HashMap<String, List<String>>();
        if (serviceMetadata != null) {
            try {
                ReflectionHelper.readMetadataMap((String)serviceMetadata, metadata);
            }
            catch (IOException iOException) {
                metadata.clear();
                ReflectionHelper.parseServiceMetadataString((String)serviceMetadata, metadata);
            }
        }
        collector.throwIfErrors();
        if (scopeInfo.getScope() != null) {
            BuilderHelper.getMetadataValues((Annotation)scopeInfo.getScope(), metadata);
        }
        for (Annotation qualifier : qualifiers) {
            BuilderHelper.getMetadataValues((Annotation)qualifier, metadata);
        }
        UseProxy useProxy = clazz.getAnnotation(UseProxy.class);
        if (useProxy != null) {
            proxy = useProxy.value();
        }
        if ((pfss = clazz.getAnnotation(ProxyForSameScope.class)) != null) {
            proxyForSameScope = pfss.value();
        }
        DescriptorVisibility visibility = DescriptorVisibility.NORMAL;
        Visibility vi = clazz.getAnnotation(Visibility.class);
        if (vi != null) {
            visibility = vi.value();
        }
        int rank = BuilderHelper.getRank(clazz);
        AutoActiveDescriptor retVal = new AutoActiveDescriptor(clazz, creator, contracts, scope, name, qualifiers, visibility, rank, proxy, proxyForSameScope, analyzerName, metadata, DescriptorType.CLASS, clazz);
        retVal.setScopeAsAnnotation(scopeInfo.getScope());
        creator.initialize((ActiveDescriptor<?>)retVal, analyzerName, collector);
        collector.throwIfErrors();
        return retVal;
    }

    public static <T> AutoActiveDescriptor<T> createAutoFactoryDescriptor(Class<T> parentClazz, ActiveDescriptor<?> factoryDescriptor, ServiceLocatorImpl locator) throws MultiException, IllegalArgumentException, IllegalStateException {
        ProxyForSameScope pfss;
        if (parentClazz == null) {
            throw new IllegalArgumentException();
        }
        Collector collector = new Collector();
        Type factoryProductionType = Utilities.getFactoryProductionType(parentClazz);
        Method provideMethod = Utilities.getFactoryProvideMethod(parentClazz);
        if (provideMethod == null) {
            collector.addThrowable(new IllegalArgumentException("Could not find the provide method on the class " + parentClazz.getName()));
            collector.throwIfErrors();
        }
        Boolean proxy = null;
        Boolean proxyForSameScope = null;
        Set qualifiers = ReflectionHelper.getQualifierAnnotations((AnnotatedElement)provideMethod);
        String name = ReflectionHelper.getNameFromAllQualifiers((Set)qualifiers, (AnnotatedElement)provideMethod);
        Set<Type> contracts = Utilities.getAutoAdvertisedTypes(factoryProductionType);
        ScopeInfo scopeInfo = Utilities.getScopeInfo(provideMethod, null, collector);
        Class scope = scopeInfo.getAnnoType();
        FactoryCreator creator = new FactoryCreator(locator, factoryDescriptor);
        collector.throwIfErrors();
        HashMap<String, List<String>> metadata = new HashMap<String, List<String>>();
        if (scopeInfo.getScope() != null) {
            BuilderHelper.getMetadataValues((Annotation)scopeInfo.getScope(), metadata);
        }
        for (Annotation qualifier : qualifiers) {
            BuilderHelper.getMetadataValues((Annotation)qualifier, metadata);
        }
        UseProxy useProxy = provideMethod.getAnnotation(UseProxy.class);
        if (useProxy != null) {
            proxy = useProxy.value();
        }
        if ((pfss = provideMethod.getAnnotation(ProxyForSameScope.class)) != null) {
            proxyForSameScope = pfss.value();
        }
        DescriptorVisibility visibility = DescriptorVisibility.NORMAL;
        Visibility vi = provideMethod.getAnnotation(Visibility.class);
        if (vi != null) {
            visibility = vi.value();
        }
        int rank = 0;
        Rank ranking = provideMethod.getAnnotation(Rank.class);
        if (ranking != null) {
            rank = ranking.value();
        }
        AutoActiveDescriptor retVal = new AutoActiveDescriptor(factoryDescriptor.getImplementationClass(), creator, contracts, scope, name, qualifiers, visibility, rank, proxy, proxyForSameScope, null, metadata, DescriptorType.PROVIDE_METHOD, null);
        retVal.setScopeAsAnnotation(scopeInfo.getScope());
        collector.throwIfErrors();
        return retVal;
    }

    public static void justPreDestroy(Object preMe, ServiceLocatorImpl locator, String strategy) {
        if (preMe == null) {
            throw new IllegalArgumentException();
        }
        Collector collector = new Collector();
        ClassAnalyzer analyzer = Utilities.getClassAnalyzer(locator, strategy, collector);
        collector.throwIfErrors();
        collector.throwIfErrors();
        Class<?> baseClass = preMe.getClass();
        Method preDestroy = Utilities.getPreDestroy(baseClass, analyzer, collector);
        collector.throwIfErrors();
        if (preDestroy == null) {
            return;
        }
        try {
            ReflectionHelper.invoke((Object)preMe, (Method)preDestroy, (Object[])new Object[0], (boolean)locator.getNeutralContextClassLoader());
        }
        catch (Throwable e) {
            throw new MultiException(e);
        }
    }

    public static void justPostConstruct(Object postMe, ServiceLocatorImpl locator, String strategy) {
        if (postMe == null) {
            throw new IllegalArgumentException();
        }
        Collector collector = new Collector();
        ClassAnalyzer analyzer = Utilities.getClassAnalyzer(locator, strategy, collector);
        collector.throwIfErrors();
        Class<?> baseClass = postMe.getClass();
        Method postConstruct = Utilities.getPostConstruct(baseClass, analyzer, collector);
        collector.throwIfErrors();
        if (postConstruct == null) {
            return;
        }
        try {
            ReflectionHelper.invoke((Object)postMe, (Method)postConstruct, (Object[])new Object[0], (boolean)locator.getNeutralContextClassLoader());
        }
        catch (Throwable e) {
            throw new MultiException(e);
        }
    }

    public static Object justAssistedInject(Object injectMe, Method method, ServiceLocatorImpl locator, ServiceHandle<?> root, MethodParameter ... givenValues) {
        if (injectMe == null || method == null) {
            throw new IllegalArgumentException("injectMe=" + injectMe + " method=" + method);
        }
        if (givenValues == null) {
            givenValues = new MethodParameter[]{};
        }
        int numParameters = method.getParameterTypes().length;
        HashMap<Integer, MethodParameter> knownValues = new HashMap<Integer, MethodParameter>();
        MethodParameter[] methodParameterArray = givenValues;
        int n = givenValues.length;
        int n2 = 0;
        while (n2 < n) {
            MethodParameter mp = methodParameterArray[n2];
            int index = mp.getParameterPosition();
            if (knownValues.containsKey(index)) {
                throw new IllegalArgumentException("The given values contain more than one value for index " + index);
            }
            knownValues.put(index, mp);
            if (index < 0 || index >= numParameters) {
                throw new IllegalArgumentException("Index of " + mp + " is out of range of the method parameters " + method);
            }
            ++n2;
        }
        List<SystemInjecteeImpl> injectees = Utilities.getMethodInjectees(injectMe.getClass(), method, null, knownValues);
        Object[] args = new Object[numParameters];
        int lcv = 0;
        while (lcv < injectees.size()) {
            SystemInjecteeImpl injectee = injectees.get(lcv);
            if (injectee == null) {
                MethodParameter mp = (MethodParameter)knownValues.get(lcv);
                if (mp == null) {
                    throw new AssertionError((Object)("Error getting values " + lcv + " method=" + method + " injectMe=" + injectMe + " knownValues=" + knownValues));
                }
                args[lcv] = mp.getParameterValue();
            } else {
                InjectionResolver<?> resolver = locator.getPerLocatorUtilities().getInjectionResolver(locator, injectee);
                args[lcv] = resolver.resolve((Injectee)injectee, root);
            }
            ++lcv;
        }
        try {
            return ReflectionHelper.invoke((Object)injectMe, (Method)method, (Object[])args, (boolean)locator.getNeutralContextClassLoader());
        }
        catch (MultiException me) {
            throw me;
        }
        catch (Throwable e) {
            throw new MultiException(e);
        }
    }

    public static void justInject(Object injectMe, ServiceLocatorImpl locator, String strategy) {
        if (injectMe == null) {
            throw new IllegalArgumentException();
        }
        Collector collector = new Collector();
        ClassAnalyzer analyzer = Utilities.getClassAnalyzer(locator, strategy, collector);
        collector.throwIfErrors();
        Class<?> baseClass = injectMe.getClass();
        Set<Field> fields = Utilities.getInitFields(baseClass, analyzer, collector);
        Set<Method> methods = Utilities.getInitMethods(baseClass, analyzer, collector);
        collector.throwIfErrors();
        for (Field field : fields) {
            InjectionResolver<?> resolver = locator.getPerLocatorUtilities().getInjectionResolver(locator, field);
            List<SystemInjecteeImpl> injecteeFields = Utilities.getFieldInjectees(baseClass, field, null);
            Utilities.validateSelfInjectees(null, injecteeFields, collector);
            collector.throwIfErrors();
            Injectee injectee = injecteeFields.get(0);
            Object fieldValue = resolver.resolve(injectee, null);
            try {
                ReflectionHelper.setField((Field)field, (Object)injectMe, (Object)fieldValue);
            }
            catch (MultiException me) {
                throw me;
            }
            catch (Throwable th) {
                throw new MultiException(th);
            }
        }
        for (Method method : methods) {
            List<SystemInjecteeImpl> injectees = Utilities.getMethodInjectees(baseClass, method, null);
            Utilities.validateSelfInjectees(null, injectees, collector);
            collector.throwIfErrors();
            Object[] args = new Object[injectees.size()];
            for (SystemInjecteeImpl systemInjecteeImpl : injectees) {
                InjectionResolver<?> resolver = locator.getPerLocatorUtilities().getInjectionResolver(locator, systemInjecteeImpl);
                args[systemInjecteeImpl.getPosition()] = resolver.resolve((Injectee)systemInjecteeImpl, null);
            }
            try {
                ReflectionHelper.invoke((Object)injectMe, (Method)method, (Object[])args, (boolean)locator.getNeutralContextClassLoader());
            }
            catch (MultiException multiException) {
                throw multiException;
            }
            catch (Throwable throwable) {
                throw new MultiException(throwable);
            }
        }
    }

    public static <T> T justCreate(Class<T> createMe, ServiceLocatorImpl locator, String strategy) {
        if (createMe == null) {
            throw new IllegalArgumentException();
        }
        Collector collector = new Collector();
        ClassAnalyzer analyzer = Utilities.getClassAnalyzer(locator, strategy, collector);
        collector.throwIfErrors();
        Constructor<T> c = Utilities.getConstructor(createMe, analyzer, collector);
        collector.throwIfErrors();
        List<SystemInjecteeImpl> injectees = Utilities.getConstructorInjectees(c, null);
        Utilities.validateSelfInjectees(null, injectees, collector);
        collector.throwIfErrors();
        Object[] args = new Object[injectees.size()];
        for (SystemInjecteeImpl injectee : injectees) {
            InjectionResolver<?> resolver = locator.getPerLocatorUtilities().getInjectionResolver(locator, injectee);
            args[injectee.getPosition()] = resolver.resolve((Injectee)injectee, null);
        }
        try {
            return (T)ReflectionHelper.makeMe(c, (Object[])args, (boolean)locator.getNeutralContextClassLoader());
        }
        catch (Throwable th) {
            throw new MultiException(th);
        }
    }

    public static Class<?>[] getInterfacesForProxy(Set<Type> contracts) {
        LinkedList<Class> retVal = new LinkedList<Class>();
        retVal.add(ProxyCtl.class);
        for (Type type : contracts) {
            Class rawClass = ReflectionHelper.getRawClass((Type)type);
            if (rawClass == null || !rawClass.isInterface()) continue;
            retVal.add(rawClass);
        }
        return retVal.toArray(new Class[retVal.size()]);
    }

    public static boolean isProxiableScope(Class<? extends Annotation> scope) {
        return scope.isAnnotationPresent(Proxiable.class);
    }

    public static boolean isUnproxiableScope(Class<? extends Annotation> scope) {
        return scope.isAnnotationPresent(Unproxiable.class);
    }

    private static boolean isProxiable(ActiveDescriptor<?> desc, Injectee injectee) {
        Boolean directed = desc.isProxiable();
        if (directed != null) {
            if (injectee == null) {
                return directed;
            }
            if (!directed.booleanValue()) {
                return false;
            }
            ActiveDescriptor injecteeDescriptor = injectee.getInjecteeDescriptor();
            if (injecteeDescriptor == null) {
                return true;
            }
            Boolean sameScope = desc.isProxyForSameScope();
            if (sameScope == null || sameScope.booleanValue()) {
                return true;
            }
            return !desc.getScope().equals(injecteeDescriptor.getScope());
        }
        Class scopeAnnotation = desc.getScopeAnnotation();
        if (!scopeAnnotation.isAnnotationPresent(Proxiable.class)) {
            return false;
        }
        if (injectee == null) {
            return true;
        }
        ActiveDescriptor injecteeDescriptor = injectee.getInjecteeDescriptor();
        if (injecteeDescriptor == null) {
            return true;
        }
        Proxiable proxiable = scopeAnnotation.getAnnotation(Proxiable.class);
        Boolean proxyForSameScope = desc.isProxyForSameScope();
        if (proxyForSameScope != null ? proxyForSameScope != false : proxiable == null || proxiable.proxyForSameScope()) {
            return true;
        }
        return !desc.getScope().equals(injecteeDescriptor.getScope());
    }

    public static <T> T getFirstThingInList(List<T> set) {
        Iterator<T> iterator = set.iterator();
        if (iterator.hasNext()) {
            T t = iterator.next();
            return t;
        }
        return null;
    }

    public static ActiveDescriptor<ServiceLocator> getLocatorDescriptor(ServiceLocator locator) {
        HashSet<Type> contracts = new HashSet<Type>();
        contracts.add((Type)((Object)ServiceLocator.class));
        Set<Annotation> qualifiers = Collections.emptySet();
        ConstantActiveDescriptor<ServiceLocator> retVal = new ConstantActiveDescriptor<ServiceLocator>(locator, contracts, PerLookup.class, null, qualifiers, DescriptorVisibility.LOCAL, 0, null, null, null, locator.getLocatorId(), null);
        return retVal;
    }

    public static ActiveDescriptor<InjectionResolver<Inject>> getThreeThirtyDescriptor(ServiceLocatorImpl locator) {
        ThreeThirtyResolver threeThirtyResolver = new ThreeThirtyResolver(locator);
        HashSet<Type> contracts = new HashSet<Type>();
        Type[] actuals = new Type[]{Inject.class};
        contracts.add((Type)new ParameterizedTypeImpl(InjectionResolver.class, actuals));
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        qualifiers.add((Annotation)new NamedImpl("SystemInjectResolver"));
        ConstantActiveDescriptor<ThreeThirtyResolver> retVal = new ConstantActiveDescriptor<ThreeThirtyResolver>(threeThirtyResolver, contracts, Singleton.class, "SystemInjectResolver", qualifiers, DescriptorVisibility.LOCAL, 0, null, null, null, locator.getLocatorId(), null);
        return retVal;
    }

    public static Constructor<?> findProducerConstructor(Class<?> annotatedType, ServiceLocatorImpl locator, Collector collector) {
        Constructor<?> zeroArgConstructor = null;
        Constructor<?> aConstructorWithInjectAnnotation = null;
        Set<Constructor<?>> allConstructors = Utilities.getAllConstructors(annotatedType);
        for (Constructor<?> constructor : allConstructors) {
            Type[] rawParameters = constructor.getGenericParameterTypes();
            if (rawParameters.length <= 0) {
                zeroArgConstructor = constructor;
            }
            if (locator.hasInjectAnnotation(constructor)) {
                if (aConstructorWithInjectAnnotation != null) {
                    collector.addThrowable(new IllegalArgumentException("There is more than one constructor on class " + Pretty.clazz(annotatedType)));
                    return null;
                }
                aConstructorWithInjectAnnotation = constructor;
            }
            if (Utilities.isProperConstructor(constructor)) continue;
            collector.addThrowable(new IllegalArgumentException("The constructor for " + Pretty.clazz(annotatedType) + " may not have an annotation as a parameter"));
            return null;
        }
        if (aConstructorWithInjectAnnotation != null) {
            return aConstructorWithInjectAnnotation;
        }
        if (zeroArgConstructor == null) {
            collector.addThrowable(new NoSuchMethodException("The class " + Pretty.clazz(annotatedType) + " has no constructor marked @Inject and no zero argument constructor"));
            return null;
        }
        return zeroArgConstructor;
    }

    private static boolean isProperConstructor(Constructor<?> c) {
        Class<?>[] classArray = c.getParameterTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> pClazz = classArray[n2];
            if (pClazz.isAnnotation()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static Set<Constructor<?>> getAllConstructors(final Class<?> clazz) {
        Constructor<?>[] constructors;
        LinkedHashSet retVal = new LinkedHashSet();
        Constructor<?>[] constructorArray = constructors = AccessController.doPrivileged(new PrivilegedAction<Constructor<?>[]>(){

            @Override
            public Constructor<?>[] run() {
                return clazz.getDeclaredConstructors();
            }
        });
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> constructor = constructorArray[n2];
            retVal.add(constructor);
            ++n2;
        }
        return retVal;
    }

    private static boolean hasSubscribeToAnnotation(Method method) {
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        int outer = 0;
        while (outer < paramAnnotations.length) {
            Annotation[] paramAnnos = paramAnnotations[outer];
            int inner = 0;
            while (inner < paramAnnos.length) {
                if (SubscribeTo.class.equals(paramAnnos[inner].annotationType())) {
                    return true;
                }
                ++inner;
            }
            ++outer;
        }
        return false;
    }

    public static Set<Method> findInitializerMethods(Class<?> annotatedType, ServiceLocatorImpl locator, Collector errorCollector) {
        LinkedHashSet<Method> retVal = new LinkedHashSet<Method>();
        ClassReflectionHelper crh = locator.getClassReflectionHelper();
        for (MethodWrapper methodWrapper : crh.getAllMethods(annotatedType)) {
            Method method = methodWrapper.getMethod();
            if (!locator.hasInjectAnnotation(method) || method.isSynthetic() || method.isBridge() || Utilities.hasSubscribeToAnnotation(method)) continue;
            if (!Utilities.isProperMethod(method)) {
                errorCollector.addThrowable(new IllegalArgumentException("An initializer method " + Pretty.method((Method)method) + " is static, abstract or has a parameter that is an annotation"));
                continue;
            }
            retVal.add(method);
        }
        return retVal;
    }

    public static Method findPostConstruct(Class<?> clazz, ServiceLocatorImpl locator, Collector collector) {
        try {
            return locator.getClassReflectionHelper().findPostConstruct(clazz, PostConstruct.class);
        }
        catch (IllegalArgumentException iae) {
            collector.addThrowable(iae);
            return null;
        }
    }

    public static Method findPreDestroy(Class<?> clazz, ServiceLocatorImpl locator, Collector collector) {
        try {
            return locator.getClassReflectionHelper().findPreDestroy(clazz, PreDestroy.class);
        }
        catch (IllegalArgumentException iae) {
            collector.addThrowable(iae);
            return null;
        }
    }

    public static Set<Field> findInitializerFields(Class<?> annotatedType, ServiceLocatorImpl locator, Collector errorCollector) {
        LinkedHashSet<Field> retVal = new LinkedHashSet<Field>();
        ClassReflectionHelper crh = locator.getClassReflectionHelper();
        Set fields = crh.getAllFields(annotatedType);
        for (Field field : fields) {
            if (!locator.hasInjectAnnotation(field)) continue;
            if (!Utilities.isProperField(field)) {
                errorCollector.addThrowable(new IllegalArgumentException("The field " + Pretty.field((Field)field) + " may not be static, final or have an Annotation type"));
                continue;
            }
            retVal.add(field);
        }
        return retVal;
    }

    static AnnotatedElementAnnotationInfo computeAEAI(AnnotatedElement annotatedElement) {
        if (annotatedElement instanceof Method) {
            Method m = (Method)annotatedElement;
            return new AnnotatedElementAnnotationInfo(m.getAnnotations(), true, m.getParameterAnnotations(), false);
        }
        if (annotatedElement instanceof Constructor) {
            Constructor c = (Constructor)annotatedElement;
            return new AnnotatedElementAnnotationInfo(c.getAnnotations(), true, c.getParameterAnnotations(), true);
        }
        return new AnnotatedElementAnnotationInfo(annotatedElement.getAnnotations(), false, new Annotation[0][], false);
    }

    private static boolean isProperMethod(Method member) {
        if (ReflectionHelper.isStatic((Member)member)) {
            return false;
        }
        if (Utilities.isAbstract(member)) {
            return false;
        }
        Class<?>[] classArray = member.getParameterTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> paramClazz = classArray[n2];
            if (paramClazz.isAnnotation()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean isProperField(Field field) {
        if (ReflectionHelper.isStatic((Member)field)) {
            return false;
        }
        if (Utilities.isFinal(field)) {
            return false;
        }
        Class<?> type = field.getType();
        return !type.isAnnotation();
    }

    public static boolean isAbstract(Member member) {
        int modifiers = member.getModifiers();
        return (modifiers & 0x400) != 0;
    }

    public static boolean isFinal(Member member) {
        int modifiers = member.getModifiers();
        return (modifiers & 0x10) != 0;
    }

    private static boolean isFinal(Class<?> clazz) {
        int modifiers = clazz.getModifiers();
        return (modifiers & 0x10) != 0;
    }

    private static ScopeInfo getScopeInfo(AnnotatedElement annotatedGuy, Descriptor defaultScope, Collector collector) {
        Class<?> descScope;
        Class topLevelElement = annotatedGuy;
        Annotation winnerScope = null;
        block0: while (annotatedGuy != null) {
            Annotation current = Utilities.internalGetScopeAnnotationType(annotatedGuy, collector);
            if (current != null) {
                if (annotatedGuy.equals(topLevelElement)) {
                    winnerScope = current;
                    break;
                }
                if (!current.annotationType().isAnnotationPresent(Inherited.class)) break;
                winnerScope = current;
                break;
            }
            if (annotatedGuy instanceof Class) {
                annotatedGuy = ((Class)annotatedGuy).getSuperclass();
                continue;
            }
            Method theMethod = (Method)annotatedGuy;
            Class<?> methodClass = theMethod.getDeclaringClass();
            annotatedGuy = null;
            Class<?> methodSuperclass = methodClass.getSuperclass();
            while (methodSuperclass != null) {
                if (Factory.class.isAssignableFrom(methodSuperclass)) {
                    annotatedGuy = Utilities.getFactoryProvideMethod(methodSuperclass);
                    continue block0;
                }
                methodSuperclass = methodSuperclass.getSuperclass();
            }
        }
        if (winnerScope != null) {
            return new ScopeInfo(winnerScope, winnerScope.annotationType());
        }
        if (topLevelElement.isAnnotationPresent(Service.class)) {
            return new ScopeInfo((Annotation)ServiceLocatorUtilities.getSingletonAnnotation(), Singleton.class);
        }
        if (defaultScope != null && defaultScope.getScope() != null && (descScope = Utilities.loadClass(defaultScope.getScope(), defaultScope, collector)) != null) {
            return new ScopeInfo(null, descScope);
        }
        return new ScopeInfo((Annotation)ServiceLocatorUtilities.getPerLookupAnnotation(), PerLookup.class);
    }

    public static Class<? extends Annotation> getScopeAnnotationType(Class<?> fromThis, Descriptor defaultScope) {
        Collector collector = new Collector();
        ScopeInfo si = Utilities.getScopeInfo(fromThis, defaultScope, collector);
        collector.throwIfErrors();
        return si.getAnnoType();
    }

    public static ScopeInfo getScopeAnnotationType(AnnotatedElement annotatedGuy, Descriptor defaultScope, Collector collector) {
        ScopeInfo si = Utilities.getScopeInfo(annotatedGuy, defaultScope, collector);
        return si;
    }

    private static Annotation internalGetScopeAnnotationType(AnnotatedElement annotatedGuy, Collector collector) {
        boolean epicFail = false;
        Annotation retVal = null;
        Annotation[] annotationArray = annotatedGuy.getDeclaredAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType().isAnnotationPresent(Scope.class)) {
                if (retVal != null) {
                    collector.addThrowable(new IllegalArgumentException("The type " + annotatedGuy + " may not have more than one scope.  It has at least " + Pretty.clazz(retVal.annotationType()) + " and " + Pretty.clazz(annotation.annotationType())));
                    epicFail = true;
                } else {
                    retVal = annotation;
                }
            }
            ++n2;
        }
        if (epicFail) {
            return null;
        }
        return retVal;
    }

    public static Method getFactoryProvideMethod(Class<?> clazz) {
        try {
            return clazz.getMethod(PROVIDE_METHOD, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static String getDefaultNameFromMethod(Method parent, Collector collector) {
        Named named = parent.getAnnotation(Named.class);
        if (named == null) {
            return null;
        }
        if (named.value() == null || named.value().equals("")) {
            collector.addThrowable(new IllegalArgumentException("@Named on the provide method of a factory must have an explicit value"));
        }
        return named.value();
    }

    public static Set<Annotation> getAllQualifiers(AnnotatedElement annotatedGuy, String name, Collector collector) {
        Named namedQualifier = null;
        Set retVal = ReflectionHelper.getQualifierAnnotations((AnnotatedElement)annotatedGuy);
        for (Annotation anno : retVal) {
            if (!(anno instanceof Named)) continue;
            namedQualifier = (Named)anno;
            break;
        }
        if (name == null) {
            if (namedQualifier != null) {
                collector.addThrowable(new IllegalArgumentException("No name was in the descriptor, but this element(" + annotatedGuy + " has a Named annotation with value: " + namedQualifier.value()));
                retVal.remove(namedQualifier);
            }
            return retVal;
        }
        if (namedQualifier == null || namedQualifier.value().equals("")) {
            if (namedQualifier != null) {
                retVal.remove(namedQualifier);
            }
            namedQualifier = new NamedImpl(name);
            retVal.add(namedQualifier);
        }
        if (!name.equals(namedQualifier.value())) {
            collector.addThrowable(new IllegalArgumentException("The class had an @Named qualifier that was inconsistent.  The expected name is " + name + " but the annotation has name " + namedQualifier.value()));
        }
        return retVal;
    }

    private static AnnotationInformation getParamInformation(Annotation[] memberAnnotations) {
        boolean useDefault = true;
        Set<Annotation> qualifiers = null;
        boolean optional = false;
        boolean self = false;
        Unqualified unqualified = null;
        Annotation[] annotationArray = memberAnnotations;
        int n = memberAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation anno = annotationArray[n2];
            if (ReflectionHelper.isAnnotationAQualifier((Annotation)anno)) {
                if (qualifiers == null) {
                    qualifiers = new HashSet<Annotation>();
                }
                qualifiers.add(anno);
                useDefault = false;
            } else if (Optional.class.equals(anno.annotationType())) {
                optional = true;
                useDefault = false;
            } else if (Self.class.equals(anno.annotationType())) {
                self = true;
                useDefault = false;
            } else if (Unqualified.class.equals(anno.annotationType())) {
                unqualified = (Unqualified)anno;
                useDefault = false;
            }
            ++n2;
        }
        if (useDefault) {
            return DEFAULT_ANNOTATION_INFORMATION;
        }
        if (qualifiers == null) {
            qualifiers = Utilities.DEFAULT_ANNOTATION_INFORMATION.qualifiers;
        }
        return new AnnotationInformation(qualifiers, optional, self, unqualified);
    }

    public static List<SystemInjecteeImpl> getConstructorInjectees(Constructor<?> c, ActiveDescriptor<?> injecteeDescriptor) {
        Type[] genericTypeParams = c.getGenericParameterTypes();
        Annotation[][] paramAnnotations = c.getParameterAnnotations();
        LinkedList<SystemInjecteeImpl> retVal = new LinkedList<SystemInjecteeImpl>();
        int lcv = 0;
        while (lcv < genericTypeParams.length) {
            AnnotationInformation ai = Utilities.getParamInformation(paramAnnotations[lcv]);
            retVal.add(new SystemInjecteeImpl(genericTypeParams[lcv], ai.qualifiers, lcv, c, ai.optional, ai.self, ai.unqualified, injecteeDescriptor));
            ++lcv;
        }
        return retVal;
    }

    public static List<SystemInjecteeImpl> getMethodInjectees(Class<?> actualClass, Method c, ActiveDescriptor<?> injecteeDescriptor) {
        return Utilities.getMethodInjectees(actualClass, c, injecteeDescriptor, Collections.emptyMap());
    }

    public static List<SystemInjecteeImpl> getMethodInjectees(Class<?> actualClass, Method c, ActiveDescriptor<?> injecteeDescriptor, Map<Integer, MethodParameter> knownValues) {
        Type[] genericTypeParams = c.getGenericParameterTypes();
        Annotation[][] paramAnnotations = c.getParameterAnnotations();
        ArrayList<SystemInjecteeImpl> retVal = new ArrayList<SystemInjecteeImpl>();
        Class<?> declaringClass = c.getDeclaringClass();
        int lcv = 0;
        while (lcv < genericTypeParams.length) {
            if (knownValues.containsKey(lcv)) {
                retVal.add(null);
            } else {
                AnnotationInformation ai = Utilities.getParamInformation(paramAnnotations[lcv]);
                Type adjustedType = ReflectionHelper.resolveMember(actualClass, (Type)genericTypeParams[lcv], declaringClass);
                retVal.add(new SystemInjecteeImpl(adjustedType, ai.qualifiers, lcv, c, ai.optional, ai.self, ai.unqualified, injecteeDescriptor));
            }
            ++lcv;
        }
        return retVal;
    }

    private static Set<Annotation> getFieldAdjustedQualifierAnnotations(Field f, Set<Annotation> qualifiers) {
        Named n = f.getAnnotation(Named.class);
        if (n == null) {
            return qualifiers;
        }
        if (n.value() != null && !"".equals(n.value())) {
            return qualifiers;
        }
        HashSet<Annotation> retVal = new HashSet<Annotation>();
        for (Annotation qualifier : qualifiers) {
            if (qualifier.annotationType().equals(Named.class)) {
                retVal.add((Annotation)new NamedImpl(f.getName()));
                continue;
            }
            retVal.add(qualifier);
        }
        return retVal;
    }

    public static List<SystemInjecteeImpl> getFieldInjectees(Class<?> actualClass, Field f, ActiveDescriptor<?> injecteeDescriptor) {
        LinkedList<SystemInjecteeImpl> retVal = new LinkedList<SystemInjecteeImpl>();
        AnnotationInformation ai = Utilities.getParamInformation(f.getAnnotations());
        Type adjustedType = ReflectionHelper.resolveField(actualClass, (Field)f);
        retVal.add(new SystemInjecteeImpl(adjustedType, Utilities.getFieldAdjustedQualifierAnnotations(f, ai.qualifiers), -1, f, ai.optional, ai.self, ai.unqualified, injecteeDescriptor));
        return retVal;
    }

    public static void validateSelfInjectees(ActiveDescriptor<?> givenDescriptor, List<SystemInjecteeImpl> injectees, Collector collector) {
        for (Injectee injectee : injectees) {
            if (!injectee.isSelf()) continue;
            Class requiredRawClass = ReflectionHelper.getRawClass((Type)injectee.getRequiredType());
            if (requiredRawClass == null || !ActiveDescriptor.class.equals((Object)requiredRawClass)) {
                collector.addThrowable(new IllegalArgumentException("Injection point " + injectee + " does not have the required type of ActiveDescriptor"));
            }
            if (injectee.isOptional()) {
                collector.addThrowable(new IllegalArgumentException("Injection point " + injectee + " is marked both @Optional and @Self"));
            }
            if (!injectee.getRequiredQualifiers().isEmpty()) {
                collector.addThrowable(new IllegalArgumentException("Injection point " + injectee + " is marked @Self but has other qualifiers"));
            }
            if (givenDescriptor != null) continue;
            collector.addThrowable(new IllegalArgumentException("A class with injection point " + injectee + " is being created or injected via the non-managed ServiceLocator API"));
        }
    }

    public static Set<Annotation> fixAndCheckQualifiers(Annotation[] qualifiers, String name) {
        HashSet<Annotation> retVal = new HashSet<Annotation>();
        HashSet<String> dupChecker = new HashSet<String>();
        Named named = null;
        Annotation[] annotationArray = qualifiers;
        int n = qualifiers.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation qualifier = annotationArray[n2];
            String annotationType = qualifier.annotationType().getName();
            if (dupChecker.contains(annotationType)) {
                throw new IllegalArgumentException(String.valueOf(annotationType) + " appears more than once in the qualifier list");
            }
            dupChecker.add(annotationType);
            retVal.add(qualifier);
            if (qualifier instanceof Named) {
                named = (Named)qualifier;
                if (named.value().equals("")) {
                    throw new IllegalArgumentException("The @Named qualifier must have a value");
                }
                if (name != null && !name.equals(named.value())) {
                    throw new IllegalArgumentException("The name passed to the method (" + name + ") does not match the value of the @Named qualifier (" + named.value() + ")");
                }
            }
            ++n2;
        }
        if (named == null && name != null) {
            retVal.add((Annotation)new NamedImpl(name));
        }
        return retVal;
    }

    public static <T> T createService(ActiveDescriptor<T> root, Injectee injectee, ServiceLocatorImpl locator, ServiceHandle<T> handle, Class<?> requestedClass) {
        Context<?> context;
        if (root == null) {
            throw new IllegalArgumentException();
        }
        Object service = null;
        if (!root.isReified()) {
            root = locator.reifyDescriptor((Descriptor)root, injectee);
        }
        if (Utilities.isProxiable(root, injectee)) {
            if (!Utilities.proxiesAvailable()) {
                throw new IllegalStateException("A descriptor " + root + " requires a proxy, but the proxyable library is not on the classpath");
            }
            return locator.getPerLocatorUtilities().getProxyUtilities().generateProxy(requestedClass, locator, root, (ServiceHandleImpl)handle, injectee);
        }
        try {
            context = locator.resolveContext(root.getScopeAnnotation());
        }
        catch (Throwable th) {
            if (injectee != null && injectee.isOptional()) {
                return null;
            }
            IllegalStateException addMe = new IllegalStateException("While attempting to create a service for " + root + " in scope " + root.getScope() + " an error occured while locating the context");
            if (th instanceof MultiException) {
                MultiException me = (MultiException)th;
                me.addError((Throwable)addMe);
                throw me;
            }
            MultiException me = new MultiException(th);
            me.addError((Throwable)addMe);
            throw me;
        }
        try {
            service = context.findOrCreate(root, handle);
        }
        catch (MultiException me) {
            throw me;
        }
        catch (Throwable th) {
            throw new MultiException(th);
        }
        if (service == null && !context.supportsNullCreation()) {
            throw new MultiException((Throwable)new IllegalStateException("Context " + context + " findOrCreate returned a null for descriptor " + root + " and handle " + handle));
        }
        return (T)service;
    }

    static Interceptors getAllInterceptors(ServiceLocatorImpl impl, ActiveDescriptor<?> descriptor, Class<?> clazz, Constructor<?> c) {
        if (descriptor == null || clazz == null || Utilities.isFinal(clazz)) {
            return EMTPY_INTERCEPTORS;
        }
        ClassReflectionHelper crh = impl.getClassReflectionHelper();
        List<InterceptionService> interceptionServices = impl.getInterceptionServices();
        if (interceptionServices == null || interceptionServices.isEmpty()) {
            return EMTPY_INTERCEPTORS;
        }
        for (String contract : descriptor.getAdvertisedContracts()) {
            if (!NOT_INTERCEPTED.contains(contract)) continue;
            return EMTPY_INTERCEPTORS;
        }
        final LinkedHashMap retVal = new LinkedHashMap();
        final ArrayList cRetVal = new ArrayList();
        for (InterceptionService interceptionService : interceptionServices) {
            Filter filter = interceptionService.getDescriptorFilter();
            if (!BuilderHelper.filterMatches(descriptor, (Filter)filter)) continue;
            for (MethodWrapper methodWrapper : crh.getAllMethods(clazz)) {
                List interceptors;
                Method method = methodWrapper.getMethod();
                if (Utilities.isFinal(method) || (interceptors = interceptionService.getMethodInterceptors(method)) == null || interceptors.isEmpty()) continue;
                ArrayList addToMe = (ArrayList)retVal.get(method);
                if (addToMe == null) {
                    addToMe = new ArrayList();
                    retVal.put(method, addToMe);
                }
                addToMe.addAll(interceptors);
            }
            List cInterceptors = interceptionService.getConstructorInterceptors(c);
            if (cInterceptors == null || cInterceptors.isEmpty()) continue;
            cRetVal.addAll(cInterceptors);
        }
        return new Interceptors(){

            @Override
            public Map<Method, List<MethodInterceptor>> getMethodInterceptors() {
                return retVal;
            }

            @Override
            public List<ConstructorInterceptor> getConstructorInterceptors() {
                return cRetVal;
            }
        };
    }

    public static boolean isTypeSafe(Type requiredType, Type beanType) {
        if (TypeChecker.isRawTypeSafe((Type)requiredType, (Type)beanType)) {
            return true;
        }
        Class requiredClass = ReflectionHelper.getRawClass((Type)requiredType);
        if (requiredClass == null) {
            return false;
        }
        if (!requiredClass.isAnnotation()) {
            return false;
        }
        Class beanClass = ReflectionHelper.getRawClass((Type)beanType);
        if (beanClass == null) {
            return false;
        }
        if (beanClass.isAnnotationPresent(requiredClass)) {
            return true;
        }
        Class<? extends Annotation> trueScope = Utilities.getScopeAnnotationType(beanClass, null);
        return trueScope.equals(requiredClass);
    }

    public static synchronized boolean proxiesAvailable() {
        if (proxiesAvailable != null) {
            return proxiesAvailable;
        }
        ClassLoader loader = Utilities.class.getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        try {
            loader.loadClass("javassist.util.proxy.MethodHandler");
            proxiesAvailable = true;
            return true;
        }
        catch (Throwable throwable) {
            proxiesAvailable = false;
            return false;
        }
    }

    private static class AnnotationInformation {
        private final Set<Annotation> qualifiers;
        private final boolean optional;
        private final boolean self;
        private final Unqualified unqualified;

        private AnnotationInformation(Set<Annotation> qualifiers, boolean optional, boolean self, Unqualified unqualified) {
            this.qualifiers = qualifiers;
            this.optional = optional;
            this.self = self;
            this.unqualified = unqualified;
        }
    }

    public static interface Interceptors {
        public Map<Method, List<MethodInterceptor>> getMethodInterceptors();

        public List<ConstructorInterceptor> getConstructorInterceptors();
    }
}

