/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.regex.Pattern;

public final class Tokenizer {
    public static final String COMMON_DELIMITERS = " ,;\n";

    private Tokenizer() {
    }

    public static String[] tokenize(String[] entries) {
        return Tokenizer.tokenize(entries, COMMON_DELIMITERS);
    }

    public static String[] tokenize(String[] entries, String delimiters) {
        LinkedList<String> tokens = new LinkedList<String>();
        String[] stringArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            if (entry != null && !entry.isEmpty() && !(entry = entry.trim()).isEmpty()) {
                Tokenizer.tokenize(entry, delimiters, tokens);
            }
            ++n2;
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static String[] tokenize(String entry) {
        return Tokenizer.tokenize(entry, COMMON_DELIMITERS);
    }

    public static String[] tokenize(String entry, String delimiters) {
        Collection<String> tokens = Tokenizer.tokenize(entry, delimiters, new LinkedList<String>());
        return tokens.toArray(new String[tokens.size()]);
    }

    private static Collection<String> tokenize(String entry, String delimiters, Collection<String> tokens) {
        String[] tokenArray;
        StringBuilder regexpBuilder = new StringBuilder(delimiters.length() * 3);
        regexpBuilder.append('[');
        char[] cArray = delimiters.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            regexpBuilder.append(Pattern.quote(String.valueOf(c)));
            ++n2;
        }
        regexpBuilder.append(']');
        String[] stringArray = tokenArray = entry.split(regexpBuilder.toString());
        int n3 = tokenArray.length;
        n = 0;
        while (n < n3) {
            String token = stringArray[n];
            if (token != null && !token.isEmpty() && !(token = token.trim()).isEmpty()) {
                tokens.add(token);
            }
            ++n;
        }
        return tokens;
    }
}

