/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

final class GrammarUtil {
    public static final int TOKEN = 0;
    public static final int QUOTED_STRING = 1;
    public static final int COMMENT = 2;
    public static final int SEPARATOR = 3;
    public static final int CONTROL = 4;
    private static final char[] WHITE_SPACE = new char[]{'\t', '\r', '\n', ' '};
    private static final char[] SEPARATORS = new char[]{'(', ')', '<', '>', '@', ',', ';', ':', '\\', '\"', '/', '[', ']', '?', '=', '{', '}', ' ', '\t'};
    private static final int[] TYPE_TABLE = GrammarUtil.createEventTable();
    private static final boolean[] IS_WHITE_SPACE = GrammarUtil.createWhiteSpaceTable();
    private static final boolean[] IS_TOKEN = GrammarUtil.createTokenTable();

    private static int[] createEventTable() {
        char c;
        int[] table = new int[128];
        int i = 0;
        while (i < 32) {
            table[i] = 4;
            ++i;
        }
        table[127] = 4;
        i = 32;
        while (i < 127) {
            table[i] = 0;
            ++i;
        }
        char[] cArray = SEPARATORS;
        int n = SEPARATORS.length;
        int n2 = 0;
        while (n2 < n) {
            c = cArray[n2];
            table[c] = 3;
            ++n2;
        }
        table[40] = 2;
        table[34] = 1;
        cArray = WHITE_SPACE;
        n = WHITE_SPACE.length;
        n2 = 0;
        while (n2 < n) {
            c = cArray[n2];
            table[c] = -1;
            ++n2;
        }
        return table;
    }

    private static boolean[] createWhiteSpaceTable() {
        boolean[] table = new boolean[128];
        char[] cArray = WHITE_SPACE;
        int n = WHITE_SPACE.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            table[c] = true;
            ++n2;
        }
        return table;
    }

    private static boolean[] createTokenTable() {
        boolean[] table = new boolean[128];
        int i = 0;
        while (i <= 127) {
            table[i] = TYPE_TABLE[i] == 0;
            ++i;
        }
        return table;
    }

    public static boolean isWhiteSpace(char c) {
        return c <= '\u007f' && IS_WHITE_SPACE[c];
    }

    public static boolean isToken(char c) {
        return c <= '\u007f' && IS_TOKEN[c];
    }

    public static int getType(char c) {
        if (c > '\u007f') {
            throw new IllegalArgumentException("Unsupported character - ordinal value too high: " + c);
        }
        return TYPE_TABLE[c];
    }

    public static boolean isSeparator(char c) {
        return c <= '\u007f' && TYPE_TABLE[c] == 3;
    }

    public static boolean isTokenString(String s) {
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!GrammarUtil.isToken(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean containsWhiteSpace(String s) {
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (GrammarUtil.isWhiteSpace(c)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String filterToken(CharSequence s, int start, int end) {
        return GrammarUtil.filterToken(s, start, end, false);
    }

    public static String filterToken(CharSequence s, int start, int end, boolean preserveBackslash) {
        StringBuilder sb = new StringBuilder();
        boolean gotEscape = false;
        boolean gotCR = false;
        int i = start;
        while (i < end) {
            char c = s.charAt(i);
            if (c == '\n' && gotCR) {
                gotCR = false;
            } else {
                gotCR = false;
                if (!gotEscape) {
                    if (!preserveBackslash && c == '\\') {
                        gotEscape = true;
                    } else if (c == '\r') {
                        gotCR = true;
                    } else {
                        sb.append(c);
                    }
                } else {
                    sb.append(c);
                    gotEscape = false;
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private GrammarUtil() {
    }
}

