/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.hk2;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ErrorInformation;
import org.glassfish.hk2.api.ErrorService;
import org.glassfish.hk2.api.ErrorType;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.inject.hk2.LocalizationMessages;
import org.glassfish.jersey.internal.Errors;

public final class JerseyErrorService
implements ErrorService {
    public void onFailure(final ErrorInformation error) throws MultiException {
        final String msg = switch (error.getErrorType()) {
            case ErrorType.FAILURE_TO_REIFY -> LocalizationMessages.HK_2_REIFICATION_ERROR(error.getDescriptor().getImplementation(), this.printStackTrace(error.getAssociatedException()));
            default -> LocalizationMessages.HK_2_UNKNOWN_ERROR(this.printStackTrace(error.getAssociatedException()));
        };
        try {
            Errors.warning((Object)error.getInjectee(), (String)msg);
        }
        catch (IllegalStateException illegalStateException) {
            Errors.process((Runnable)new Runnable(){

                @Override
                public void run() {
                    Errors.warning((Object)this, (String)LocalizationMessages.HK_2_FAILURE_OUTSIDE_ERROR_SCOPE());
                    Errors.warning((Object)error.getInjectee(), (String)msg);
                }
            });
        }
    }

    private String printStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static final class Binder
    extends AbstractBinder {
        protected void configure() {
            this.bind(JerseyErrorService.class).to(ErrorService.class).in(Singleton.class);
        }
    }
}

