/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.intf.cli;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.jasypt.commons.CommonUtils;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;

final class CLIUtils {
    static void showEnvironment(boolean verbose) {
        if (verbose) {
            System.out.println("\n----ENVIRONMENT-----------------\n");
            System.out.println("Runtime: " + System.getProperty("java.vm.vendor") + " " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + " ");
            System.out.println("\n");
        }
    }

    static void showArgumentDescription(Properties argumentValues, boolean verbose) {
        if (verbose) {
            System.out.println("\n----ARGUMENTS-------------------\n");
            for (Map.Entry<Object, Object> entry : argumentValues.entrySet()) {
                System.out.println(entry.getKey() + ": " + entry.getValue());
            }
            System.out.println("\n");
        }
    }

    static void showOutput(String output, boolean verbose) {
        if (verbose) {
            System.out.println("\n----OUTPUT----------------------\n");
            System.out.println(output);
            System.out.println("\n");
        } else {
            System.out.println(output);
        }
    }

    static void showError(Throwable t, boolean verbose) {
        if (verbose) {
            System.err.println("\n----ERROR-----------------------\n");
            if (t instanceof EncryptionOperationNotPossibleException) {
                System.err.println("Operation not possible (Bad input or parameters)");
            } else if (t.getMessage() != null) {
                System.err.println(t.getMessage());
            } else {
                System.err.println(t.getClass().getName());
            }
            System.err.println("\n");
        } else {
            System.err.print("ERROR: ");
            if (t instanceof EncryptionOperationNotPossibleException) {
                System.err.println("Operation not possible (Bad input or parameters)");
            } else if (t.getMessage() != null) {
                System.err.println(t.getMessage());
            } else {
                System.err.println(t.getClass().getName());
            }
        }
    }

    static boolean getVerbosity(String[] args) {
        int i = 0;
        while (i < args.length) {
            String key = CommonUtils.substringBefore(args[i], "=");
            String value = CommonUtils.substringAfter(args[i], "=");
            if (!CommonUtils.isEmpty(key) && !CommonUtils.isEmpty(value) && "verbose".equals(key)) {
                Boolean verbosity = CommonUtils.getStandardBooleanValue(value);
                return verbosity != null ? verbosity : false;
            }
            ++i;
        }
        return true;
    }

    static Properties getArgumentValues(String appName, String[] args, String[][] requiredArgNames, String[][] optionalArgNames) {
        HashSet<String> argNames = new HashSet<String>();
        int i = 0;
        while (i < requiredArgNames.length) {
            argNames.addAll(Arrays.asList(requiredArgNames[i]));
            ++i;
        }
        i = 0;
        while (i < optionalArgNames.length) {
            argNames.addAll(Arrays.asList(optionalArgNames[i]));
            ++i;
        }
        Properties argumentValues = new Properties();
        int i2 = 0;
        while (i2 < args.length) {
            String key = CommonUtils.substringBefore(args[i2], "=");
            String value = CommonUtils.substringAfter(args[i2], "=");
            if (CommonUtils.isEmpty(key) || CommonUtils.isEmpty(value)) {
                throw new IllegalArgumentException("Bad argument: " + args[i2]);
            }
            if (argNames.contains(key)) {
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    argumentValues.setProperty(key, value.substring(1, value.length() - 1));
                } else {
                    argumentValues.setProperty(key, value);
                }
            } else {
                throw new IllegalArgumentException("Bad argument: " + args[i2]);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < requiredArgNames.length) {
            boolean found = false;
            int j = 0;
            while (j < requiredArgNames[i2].length) {
                if (argumentValues.containsKey(requiredArgNames[i2][j])) {
                    found = true;
                }
                ++j;
            }
            if (!found) {
                CLIUtils.showUsageAndExit(appName, requiredArgNames, optionalArgNames);
            }
            ++i2;
        }
        return argumentValues;
    }

    static void showUsageAndExit(String appName, String[][] requiredArgNames, String[][] optionalArgNames) {
        int j;
        System.err.println("\nUSAGE: " + appName + " [ARGUMENTS]\n");
        System.err.println("  * Arguments must apply to format:\n");
        System.err.println("      \"arg1=value1 arg2=value2 arg3=value3 ...\"");
        System.err.println();
        System.err.println("  * Required arguments:\n");
        int i = 0;
        while (i < requiredArgNames.length) {
            System.err.print("      ");
            if (requiredArgNames[i].length == 1) {
                System.err.print(requiredArgNames[i][0]);
            } else {
                System.err.print("(");
                j = 0;
                while (j < requiredArgNames[i].length) {
                    if (j > 0) {
                        System.err.print(" | ");
                    }
                    System.err.print(requiredArgNames[i][j]);
                    ++j;
                }
                System.err.print(")");
            }
            System.err.println();
            ++i;
        }
        System.err.println();
        System.err.println("  * Optional arguments:\n");
        i = 0;
        while (i < optionalArgNames.length) {
            System.err.print("      ");
            if (optionalArgNames[i].length == 1) {
                System.err.print(optionalArgNames[i][0]);
            } else {
                System.err.print("(");
                j = 0;
                while (j < optionalArgNames[i].length) {
                    if (j > 0) {
                        System.err.print(" | ");
                    }
                    System.err.print(optionalArgNames[i][j]);
                    ++j;
                }
                System.err.print(")");
            }
            System.err.println();
            ++i;
        }
        System.exit(1);
    }

    private CLIUtils() {
    }
}

