/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues;

import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.SpscArrayQueueL3Pad;
import org.jctools.util.UnsafeRefArrayAccess;

public class SpscArrayQueue<E>
extends SpscArrayQueueL3Pad<E> {
    public SpscArrayQueue(int capacity) {
        super(Math.max(capacity, 4));
    }

    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        Object[] buffer = this.buffer;
        long mask = this.mask;
        long producerIndex = this.lpProducerIndex();
        if (producerIndex >= this.producerLimit && !this.offerSlowPath(buffer, mask, producerIndex)) {
            return false;
        }
        long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(producerIndex, mask);
        UnsafeRefArrayAccess.soRefElement(buffer, offset, e);
        this.soProducerIndex(producerIndex + 1L);
        return true;
    }

    private boolean offerSlowPath(E[] buffer, long mask, long producerIndex) {
        int lookAheadStep = this.lookAheadStep;
        if (UnsafeRefArrayAccess.lvRefElement(buffer, UnsafeRefArrayAccess.calcCircularRefElementOffset(producerIndex + (long)lookAheadStep, mask)) == null) {
            this.producerLimit = producerIndex + (long)lookAheadStep;
        } else {
            long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(producerIndex, mask);
            if (UnsafeRefArrayAccess.lvRefElement(buffer, offset) != null) {
                return false;
            }
        }
        return true;
    }

    @Override
    public E poll() {
        Object[] buffer = this.buffer;
        long consumerIndex = this.lpConsumerIndex();
        long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(consumerIndex, this.mask);
        Object e = UnsafeRefArrayAccess.lvRefElement(buffer, offset);
        if (e == null) {
            return null;
        }
        UnsafeRefArrayAccess.soRefElement(buffer, offset, null);
        this.soConsumerIndex(consumerIndex + 1L);
        return (E)e;
    }

    @Override
    public E peek() {
        return (E)UnsafeRefArrayAccess.lvRefElement(this.buffer, UnsafeRefArrayAccess.calcCircularRefElementOffset(this.lpConsumerIndex(), this.mask));
    }

    @Override
    public boolean relaxedOffer(E message) {
        return this.offer(message);
    }

    @Override
    public E relaxedPoll() {
        return this.poll();
    }

    @Override
    public E relaxedPeek() {
        return this.peek();
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c) {
        return this.drain(c, this.capacity());
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        return this.fill(s, this.capacity());
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c, int limit) {
        if (c == null) {
            throw new IllegalArgumentException("c is null");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit is negative: " + limit);
        }
        if (limit == 0) {
            return 0;
        }
        Object[] buffer = this.buffer;
        long mask = this.mask;
        long consumerIndex = this.lpConsumerIndex();
        int i = 0;
        while (i < limit) {
            long index = consumerIndex + (long)i;
            long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(index, mask);
            Object e = UnsafeRefArrayAccess.lvRefElement(buffer, offset);
            if (e == null) {
                return i;
            }
            UnsafeRefArrayAccess.soRefElement(buffer, offset, null);
            this.soConsumerIndex(index + 1L);
            c.accept(e);
            ++i;
        }
        return limit;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s, int limit) {
        if (s == null) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit is negative:" + limit);
        }
        if (limit == 0) {
            return 0;
        }
        Object[] buffer = this.buffer;
        long mask = this.mask;
        int lookAheadStep = this.lookAheadStep;
        long producerIndex = this.lpProducerIndex();
        int i = 0;
        while (i < limit) {
            long index = producerIndex + (long)i;
            long lookAheadElementOffset = UnsafeRefArrayAccess.calcCircularRefElementOffset(index + (long)lookAheadStep, mask);
            if (UnsafeRefArrayAccess.lvRefElement(buffer, lookAheadElementOffset) == null) {
                int lookAheadLimit = Math.min(lookAheadStep, limit - i);
                int j = 0;
                while (j < lookAheadLimit) {
                    long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(index + (long)j, mask);
                    UnsafeRefArrayAccess.soRefElement(buffer, offset, s.get());
                    this.soProducerIndex(index + (long)j + 1L);
                    ++j;
                }
                i += lookAheadLimit - 1;
            } else {
                long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(index, mask);
                if (UnsafeRefArrayAccess.lvRefElement(buffer, offset) != null) {
                    return i;
                }
                UnsafeRefArrayAccess.soRefElement(buffer, offset, s.get());
                this.soProducerIndex(index + 1L);
            }
            ++i;
        }
        return limit;
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition exit) {
        if (c == null) {
            throw new IllegalArgumentException("c is null");
        }
        if (w == null) {
            throw new IllegalArgumentException("wait is null");
        }
        if (exit == null) {
            throw new IllegalArgumentException("exit condition is null");
        }
        Object[] buffer = this.buffer;
        long mask = this.mask;
        long consumerIndex = this.lpConsumerIndex();
        int counter = 0;
        while (exit.keepRunning()) {
            int i = 0;
            while (i < 4096) {
                long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(consumerIndex, mask);
                Object e = UnsafeRefArrayAccess.lvRefElement(buffer, offset);
                if (e == null) {
                    counter = w.idle(counter);
                } else {
                    counter = 0;
                    UnsafeRefArrayAccess.soRefElement(buffer, offset, null);
                    this.soConsumerIndex(++consumerIndex);
                    c.accept(e);
                }
                ++i;
            }
        }
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> s, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition e) {
        if (w == null) {
            throw new IllegalArgumentException("waiter is null");
        }
        if (e == null) {
            throw new IllegalArgumentException("exit condition is null");
        }
        if (s == null) {
            throw new IllegalArgumentException("supplier is null");
        }
        Object[] buffer = this.buffer;
        long mask = this.mask;
        int lookAheadStep = this.lookAheadStep;
        long producerIndex = this.lpProducerIndex();
        int counter = 0;
        while (e.keepRunning()) {
            long lookAheadElementOffset = UnsafeRefArrayAccess.calcCircularRefElementOffset(producerIndex + (long)lookAheadStep, mask);
            if (UnsafeRefArrayAccess.lvRefElement(buffer, lookAheadElementOffset) == null) {
                int j = 0;
                while (j < lookAheadStep) {
                    long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(producerIndex, mask);
                    UnsafeRefArrayAccess.soRefElement(buffer, offset, s.get());
                    this.soProducerIndex(++producerIndex);
                    ++j;
                }
                continue;
            }
            long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(producerIndex, mask);
            if (UnsafeRefArrayAccess.lvRefElement(buffer, offset) != null) {
                counter = w.idle(counter);
                continue;
            }
            counter = 0;
            UnsafeRefArrayAccess.soRefElement(buffer, offset, s.get());
            this.soProducerIndex(++producerIndex);
        }
    }
}

