/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues;

import org.jctools.queues.BaseSpscLinkedArrayQueue;
import org.jctools.queues.MessagePassingQueue;
import org.jctools.util.Pow2;
import org.jctools.util.RangeUtil;
import org.jctools.util.UnsafeRefArrayAccess;

public class SpscChunkedArrayQueue<E>
extends BaseSpscLinkedArrayQueue<E> {
    private final int maxQueueCapacity;
    private long producerQueueLimit;

    public SpscChunkedArrayQueue(int capacity) {
        this(Math.max(8, Pow2.roundToPowerOfTwo(capacity / 8)), capacity);
    }

    public SpscChunkedArrayQueue(int chunkSize, int capacity) {
        RangeUtil.checkGreaterThanOrEqual(capacity, 16, "capacity");
        RangeUtil.checkGreaterThanOrEqual(chunkSize, 8, "chunkSize");
        this.maxQueueCapacity = Pow2.roundToPowerOfTwo(capacity);
        int chunkCapacity = Pow2.roundToPowerOfTwo(chunkSize);
        RangeUtil.checkLessThan(chunkCapacity, this.maxQueueCapacity, "chunkCapacity");
        long mask = chunkCapacity - 1;
        E[] buffer = UnsafeRefArrayAccess.allocateRefArray(chunkCapacity + 1);
        this.producerBuffer = buffer;
        this.producerMask = mask;
        this.consumerBuffer = buffer;
        this.consumerMask = mask;
        this.producerBufferLimit = mask - 1L;
        this.producerQueueLimit = this.maxQueueCapacity;
    }

    @Override
    final boolean offerColdPath(E[] buffer, long mask, long pIndex, long offset, E v, MessagePassingQueue.Supplier<? extends E> s) {
        long lookAheadStep = (mask + 1L) / 4L;
        long pBufferLimit = pIndex + lookAheadStep;
        long pQueueLimit = this.producerQueueLimit;
        if (pIndex >= pQueueLimit) {
            long cIndex = this.lvConsumerIndex();
            this.producerQueueLimit = pQueueLimit = cIndex + (long)this.maxQueueCapacity;
            if (pIndex >= pQueueLimit) {
                return false;
            }
        }
        if (pBufferLimit - pQueueLimit > 0L) {
            pBufferLimit = pQueueLimit;
        }
        if (pBufferLimit > pIndex + 1L && UnsafeRefArrayAccess.lvRefElement(buffer, UnsafeRefArrayAccess.calcCircularRefElementOffset(pBufferLimit, mask)) == null) {
            this.producerBufferLimit = pBufferLimit - 1L;
            this.writeToQueue(buffer, v == null ? s.get() : v, pIndex, offset);
        } else if (UnsafeRefArrayAccess.lvRefElement(buffer, UnsafeRefArrayAccess.calcCircularRefElementOffset(pIndex + 1L, mask)) == null) {
            this.writeToQueue(buffer, v == null ? s.get() : v, pIndex, offset);
        } else {
            E[] newBuffer = UnsafeRefArrayAccess.allocateRefArray((int)(mask + 2L));
            this.producerBuffer = newBuffer;
            this.linkOldToNew(pIndex, buffer, offset, newBuffer, offset, v == null ? s.get() : v);
        }
        return true;
    }

    @Override
    public int capacity() {
        return this.maxQueueCapacity;
    }
}

