/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues.atomic;

import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.atomic.AtomicQueueUtil;
import org.jctools.queues.atomic.SpscAtomicArrayQueueL3Pad;

public class SpscAtomicArrayQueue<E>
extends SpscAtomicArrayQueueL3Pad<E> {
    public SpscAtomicArrayQueue(int capacity) {
        super(Math.max(capacity, 4));
    }

    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        AtomicReferenceArray buffer = this.buffer;
        int mask = this.mask;
        long producerIndex = this.lpProducerIndex();
        if (producerIndex >= this.producerLimit && !this.offerSlowPath(buffer, mask, producerIndex)) {
            return false;
        }
        int offset = AtomicQueueUtil.calcCircularRefElementOffset(producerIndex, mask);
        AtomicQueueUtil.soRefElement(buffer, offset, e);
        this.soProducerIndex(producerIndex + 1L);
        return true;
    }

    private boolean offerSlowPath(AtomicReferenceArray<E> buffer, int mask, long producerIndex) {
        int lookAheadStep = this.lookAheadStep;
        if (AtomicQueueUtil.lvRefElement(buffer, AtomicQueueUtil.calcCircularRefElementOffset(producerIndex + (long)lookAheadStep, mask)) == null) {
            this.producerLimit = producerIndex + (long)lookAheadStep;
        } else {
            int offset = AtomicQueueUtil.calcCircularRefElementOffset(producerIndex, mask);
            if (AtomicQueueUtil.lvRefElement(buffer, offset) != null) {
                return false;
            }
        }
        return true;
    }

    @Override
    public E poll() {
        AtomicReferenceArray buffer = this.buffer;
        long consumerIndex = this.lpConsumerIndex();
        int offset = AtomicQueueUtil.calcCircularRefElementOffset(consumerIndex, this.mask);
        Object e = AtomicQueueUtil.lvRefElement(buffer, offset);
        if (e == null) {
            return null;
        }
        AtomicQueueUtil.soRefElement(buffer, offset, null);
        this.soConsumerIndex(consumerIndex + 1L);
        return e;
    }

    @Override
    public E peek() {
        return AtomicQueueUtil.lvRefElement(this.buffer, AtomicQueueUtil.calcCircularRefElementOffset(this.lpConsumerIndex(), this.mask));
    }

    @Override
    public boolean relaxedOffer(E message) {
        return this.offer(message);
    }

    @Override
    public E relaxedPoll() {
        return this.poll();
    }

    @Override
    public E relaxedPeek() {
        return this.peek();
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c) {
        return this.drain(c, this.capacity());
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        return this.fill(s, this.capacity());
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c, int limit) {
        if (c == null) {
            throw new IllegalArgumentException("c is null");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit is negative: " + limit);
        }
        if (limit == 0) {
            return 0;
        }
        AtomicReferenceArray buffer = this.buffer;
        int mask = this.mask;
        long consumerIndex = this.lpConsumerIndex();
        int i = 0;
        while (i < limit) {
            long index = consumerIndex + (long)i;
            int offset = AtomicQueueUtil.calcCircularRefElementOffset(index, mask);
            Object e = AtomicQueueUtil.lvRefElement(buffer, offset);
            if (e == null) {
                return i;
            }
            AtomicQueueUtil.soRefElement(buffer, offset, null);
            this.soConsumerIndex(index + 1L);
            c.accept(e);
            ++i;
        }
        return limit;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s, int limit) {
        if (s == null) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit is negative:" + limit);
        }
        if (limit == 0) {
            return 0;
        }
        AtomicReferenceArray buffer = this.buffer;
        int mask = this.mask;
        int lookAheadStep = this.lookAheadStep;
        long producerIndex = this.lpProducerIndex();
        int i = 0;
        while (i < limit) {
            long index = producerIndex + (long)i;
            int lookAheadElementOffset = AtomicQueueUtil.calcCircularRefElementOffset(index + (long)lookAheadStep, mask);
            if (AtomicQueueUtil.lvRefElement(buffer, lookAheadElementOffset) == null) {
                int lookAheadLimit = Math.min(lookAheadStep, limit - i);
                int j = 0;
                while (j < lookAheadLimit) {
                    int offset = AtomicQueueUtil.calcCircularRefElementOffset(index + (long)j, mask);
                    AtomicQueueUtil.soRefElement(buffer, offset, s.get());
                    this.soProducerIndex(index + (long)j + 1L);
                    ++j;
                }
                i += lookAheadLimit - 1;
            } else {
                int offset = AtomicQueueUtil.calcCircularRefElementOffset(index, mask);
                if (AtomicQueueUtil.lvRefElement(buffer, offset) != null) {
                    return i;
                }
                AtomicQueueUtil.soRefElement(buffer, offset, s.get());
                this.soProducerIndex(index + 1L);
            }
            ++i;
        }
        return limit;
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition exit) {
        if (c == null) {
            throw new IllegalArgumentException("c is null");
        }
        if (w == null) {
            throw new IllegalArgumentException("wait is null");
        }
        if (exit == null) {
            throw new IllegalArgumentException("exit condition is null");
        }
        AtomicReferenceArray buffer = this.buffer;
        int mask = this.mask;
        long consumerIndex = this.lpConsumerIndex();
        int counter = 0;
        while (exit.keepRunning()) {
            int i = 0;
            while (i < 4096) {
                int offset = AtomicQueueUtil.calcCircularRefElementOffset(consumerIndex, mask);
                Object e = AtomicQueueUtil.lvRefElement(buffer, offset);
                if (e == null) {
                    counter = w.idle(counter);
                } else {
                    counter = 0;
                    AtomicQueueUtil.soRefElement(buffer, offset, null);
                    this.soConsumerIndex(++consumerIndex);
                    c.accept(e);
                }
                ++i;
            }
        }
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> s, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition e) {
        if (w == null) {
            throw new IllegalArgumentException("waiter is null");
        }
        if (e == null) {
            throw new IllegalArgumentException("exit condition is null");
        }
        if (s == null) {
            throw new IllegalArgumentException("supplier is null");
        }
        AtomicReferenceArray buffer = this.buffer;
        int mask = this.mask;
        int lookAheadStep = this.lookAheadStep;
        long producerIndex = this.lpProducerIndex();
        int counter = 0;
        while (e.keepRunning()) {
            int lookAheadElementOffset = AtomicQueueUtil.calcCircularRefElementOffset(producerIndex + (long)lookAheadStep, mask);
            if (AtomicQueueUtil.lvRefElement(buffer, lookAheadElementOffset) == null) {
                int j = 0;
                while (j < lookAheadStep) {
                    int offset = AtomicQueueUtil.calcCircularRefElementOffset(producerIndex, mask);
                    AtomicQueueUtil.soRefElement(buffer, offset, s.get());
                    this.soProducerIndex(++producerIndex);
                    ++j;
                }
                continue;
            }
            int offset = AtomicQueueUtil.calcCircularRefElementOffset(producerIndex, mask);
            if (AtomicQueueUtil.lvRefElement(buffer, offset) != null) {
                counter = w.idle(counter);
                continue;
            }
            counter = 0;
            AtomicQueueUtil.soRefElement(buffer, offset, s.get());
            this.soProducerIndex(++producerIndex);
        }
    }
}

