/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.jfree.chart.plot;

import de.elpro.jfree.chart.plot.StyledXYPlot;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.SeriesRenderingOrder;
import org.jfree.chart.renderer.RendererUtils;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.data.general.DatasetUtils;
import org.jfree.data.xy.XYDataset;

public class EfficientXYPlot
extends StyledXYPlot {
    private static final long serialVersionUID = 417001957104599918L;

    public EfficientXYPlot() {
    }

    public EfficientXYPlot(XYDataset dataset, ValueAxis domainAxis, ValueAxis rangeAxis, XYItemRenderer renderer) {
        super(dataset, domainAxis, rangeAxis, renderer);
    }

    @Override
    public boolean render(Graphics2D g2, Rectangle2D dataArea, int index, PlotRenderingInfo info, CrosshairState crosshairState) {
        boolean foundData;
        block18: {
            int seriesCount;
            int passCount;
            XYItemRendererState state;
            XYItemRenderer renderer;
            ValueAxis yAxis;
            ValueAxis xAxis;
            XYDataset dataset;
            block19: {
                foundData = false;
                dataset = this.getDataset(index);
                if (DatasetUtils.isEmptyOrNull(dataset)) break block18;
                foundData = true;
                xAxis = this.getDomainAxisForDataset(index);
                yAxis = this.getRangeAxisForDataset(index);
                if (xAxis == null || yAxis == null) {
                    return foundData;
                }
                renderer = this.getRenderer(index);
                if (renderer == null && (renderer = this.getRenderer()) == null) {
                    return foundData;
                }
                state = renderer.initialise(g2, dataArea, this, dataset, info);
                passCount = renderer.getPassCount();
                seriesCount = dataset.getSeriesCount();
                SeriesRenderingOrder seriesOrder = this.getSeriesRenderingOrder();
                if (seriesOrder != SeriesRenderingOrder.REVERSE) break block19;
                int series = seriesCount - 1;
                while (series >= 0) {
                    boolean[] skippingIndexes = null;
                    int pass = 0;
                    while (pass < passCount) {
                        block20: {
                            int firstItem = 0;
                            int lastItem = dataset.getItemCount(series) - 1;
                            if (lastItem == -1) break block20;
                            if (state.getProcessVisibleItemsOnly()) {
                                int[] itemBounds = RendererUtils.findLiveItems(dataset, series, xAxis.getLowerBound(), xAxis.getUpperBound());
                                firstItem = Math.max(itemBounds[0] - 1, 0);
                                lastItem = Math.min(itemBounds[1] + 1, lastItem);
                            }
                            state.startSeriesPass(dataset, series, firstItem, lastItem, pass, passCount);
                            Object beforeItem = renderer.beforeDrawItems(g2, state, dataArea, info, this, xAxis, yAxis, dataset, series, crosshairState, pass);
                            if (pass == 0) {
                                skippingIndexes = new boolean[lastItem - firstItem + 1];
                            }
                            double prevTransX1 = Double.NEGATIVE_INFINITY;
                            double prevTransY1 = Double.NEGATIVE_INFINITY;
                            int item = firstItem;
                            while (item <= lastItem) {
                                block23: {
                                    block24: {
                                        block21: {
                                            double transY1;
                                            double transX1;
                                            block22: {
                                                if (pass != 0) break block21;
                                                RectangleEdge xAxisLocation = this.getDomainAxisEdge();
                                                RectangleEdge yAxisLocation = this.getRangeAxisEdge();
                                                double x1 = dataset.getXValue(series, item);
                                                double y1 = dataset.getYValue(series, item);
                                                transX1 = xAxis.valueToJava2D(x1, dataArea, xAxisLocation);
                                                transY1 = yAxis.valueToJava2D(y1, dataArea, yAxisLocation);
                                                if (!(Math.abs(transX1 - prevTransX1) < 0.5) || !(Math.abs(transY1 - prevTransY1) < 0.5) || item == lastItem) break block22;
                                                skippingIndexes[item - firstItem] = true;
                                                break block23;
                                            }
                                            prevTransX1 = transX1;
                                            prevTransY1 = transY1;
                                            break block24;
                                        }
                                        if (skippingIndexes[item - firstItem]) break block23;
                                    }
                                    renderer.drawItem(g2, state, dataArea, info, this, xAxis, yAxis, dataset, series, item, crosshairState, pass);
                                }
                                ++item;
                            }
                            renderer.afterDrawItems(g2, state, dataArea, info, this, xAxis, yAxis, dataset, series, lastItem, crosshairState, pass, beforeItem);
                            state.endSeriesPass(dataset, series, firstItem, lastItem, pass, passCount);
                        }
                        ++pass;
                    }
                    --series;
                }
                break block18;
            }
            int series = 0;
            while (series < seriesCount) {
                boolean[] skippingIndexes = null;
                int pass = 0;
                while (pass < passCount) {
                    int firstItem = 0;
                    int lastItem = dataset.getItemCount(series) - 1;
                    if (state.getProcessVisibleItemsOnly()) {
                        int[] itemBounds = RendererUtils.findLiveItems(dataset, series, xAxis.getLowerBound(), xAxis.getUpperBound());
                        firstItem = Math.max(itemBounds[0] - 1, 0);
                        lastItem = Math.min(itemBounds[1] + 1, lastItem);
                    }
                    state.startSeriesPass(dataset, series, firstItem, lastItem, pass, passCount);
                    Object beforeItem = renderer.beforeDrawItems(g2, state, dataArea, info, this, xAxis, yAxis, dataset, series, crosshairState, pass);
                    if (pass == 0) {
                        skippingIndexes = new boolean[lastItem - firstItem + 1];
                    }
                    double prevTransX1 = Double.NEGATIVE_INFINITY;
                    double prevTransY1 = Double.NEGATIVE_INFINITY;
                    int item = firstItem;
                    while (item <= lastItem) {
                        block27: {
                            block28: {
                                block25: {
                                    double transY1;
                                    double transX1;
                                    block26: {
                                        if (pass != 0) break block25;
                                        RectangleEdge xAxisLocation = this.getDomainAxisEdge();
                                        RectangleEdge yAxisLocation = this.getRangeAxisEdge();
                                        double x1 = dataset.getXValue(series, item);
                                        double y1 = dataset.getYValue(series, item);
                                        transX1 = xAxis.valueToJava2D(x1, dataArea, xAxisLocation);
                                        transY1 = yAxis.valueToJava2D(y1, dataArea, yAxisLocation);
                                        if (!(Math.abs(transX1 - prevTransX1) < 0.1) || !(Math.abs(transY1 - prevTransY1) < 0.1) || item == lastItem) break block26;
                                        skippingIndexes[item - firstItem] = true;
                                        break block27;
                                    }
                                    prevTransX1 = transX1;
                                    prevTransY1 = transY1;
                                    break block28;
                                }
                                if (skippingIndexes[item - firstItem]) break block27;
                            }
                            renderer.drawItem(g2, state, dataArea, info, this, xAxis, yAxis, dataset, series, item, crosshairState, pass);
                        }
                        ++item;
                    }
                    renderer.afterDrawItems(g2, state, dataArea, info, this, xAxis, yAxis, dataset, series, lastItem, crosshairState, pass, beforeItem);
                    state.endSeriesPass(dataset, series, firstItem, lastItem, pass, passCount);
                    ++pass;
                }
                ++series;
            }
        }
        return foundData;
    }
}

