/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.jfree.chart.plot;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.data.xy.XYDataset;

public class StyledXYPlot
extends XYPlot {
    private static final long serialVersionUID = 3712194931979219129L;

    public StyledXYPlot() {
    }

    public StyledXYPlot(XYDataset dataset, ValueAxis domainAxis, ValueAxis rangeAxis, XYItemRenderer renderer) {
        super(dataset, domainAxis, rangeAxis, renderer);
    }

    @Override
    protected void drawDomainCrosshair(Graphics2D g2, Rectangle2D dataArea, PlotOrientation orientation, double value, ValueAxis axis, Stroke stroke, Paint paint) {
        Rectangle2D.Double r;
        Line2D.Double line;
        if (!axis.getRange().contains(value)) {
            return;
        }
        double margin = 5.0;
        if (orientation == PlotOrientation.VERTICAL) {
            double xx = axis.valueToJava2D(value, dataArea, RectangleEdge.BOTTOM);
            line = new Line2D.Double(xx, dataArea.getMinY(), xx, dataArea.getMaxY());
            r = new Rectangle2D.Double(xx - margin - 1.0, dataArea.getMinY(), margin * 2.0 + 1.0, dataArea.getHeight());
        } else {
            double yy = axis.valueToJava2D(value, dataArea, RectangleEdge.LEFT);
            line = new Line2D.Double(dataArea.getMinX(), yy, dataArea.getMaxX(), yy);
            r = new Rectangle2D.Double(dataArea.getMinY(), yy - margin, dataArea.getWidth(), margin * 2.0);
        }
        Object saved = g2.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        if (paint instanceof Color) {
            Color color = (Color)paint;
            g2.setPaint(new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)((double)color.getAlpha() * 0.25)));
        } else {
            g2.setPaint(new Color(0.0f, 0.0f, 1.0f, 0.15f));
        }
        g2.fill(r);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        g2.setStroke(stroke);
        g2.setPaint(paint);
        g2.draw(line);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, saved);
    }

    @Override
    protected void drawRangeCrosshair(Graphics2D g2, Rectangle2D dataArea, PlotOrientation orientation, double value, ValueAxis axis, Stroke stroke, Paint paint) {
        Rectangle2D.Double r;
        Line2D.Double line;
        if (axis.getRange() == null || !axis.getRange().contains(value)) {
            return;
        }
        Object saved = g2.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        double margin = 5.0;
        if (orientation == PlotOrientation.HORIZONTAL) {
            double xx = axis.valueToJava2D(value, dataArea, RectangleEdge.BOTTOM);
            line = new Line2D.Double(xx, dataArea.getMinY(), xx, dataArea.getMaxY());
            r = new Rectangle2D.Double(xx - margin - 1.0, dataArea.getMinY(), margin * 2.0 + 1.0, dataArea.getHeight());
        } else {
            double yy = axis.valueToJava2D(value, dataArea, RectangleEdge.LEFT);
            line = new Line2D.Double(dataArea.getMinX(), yy, dataArea.getMaxX(), yy);
            r = new Rectangle2D.Double(dataArea.getMinY(), yy - margin - 1.0, dataArea.getMaxX(), margin * 2.0 + 1.0);
        }
        if (paint instanceof Color) {
            Color color = (Color)paint;
            g2.setPaint(new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)((double)color.getAlpha() * 0.25)));
        } else {
            g2.setPaint(new Color(0.0f, 0.0f, 1.0f, 0.15f));
        }
        g2.fill(r);
        g2.setStroke(stroke);
        g2.setPaint(paint);
        g2.draw(line);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, saved);
    }
}

