/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.jfree.chart.plot;

import de.elpro.jfree.chart.axis.UnzoomableNumberAxis;
import de.elpro.jfree.chart.plot.EfficientXYPlot;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;

public class UnzoomableXYPlot
extends EfficientXYPlot {
    private static final long serialVersionUID = 5340604674241287350L;
    private final ArrayList<ZoomSettings> rangeAxisZoomHistory = new ArrayList();
    private final ArrayList<ZoomSettings> domainAxisZoomHistory = new ArrayList();

    public UnzoomableXYPlot() {
    }

    @Override
    public void zoomDomainAxes(double factor, PlotRenderingInfo info, Point2D source) {
        this.zoomDomainAxes(true, factor, info, source);
    }

    private void zoomDomainAxes(boolean clearHistory, double factor, PlotRenderingInfo info, Point2D source) {
        if (factor == 0.0) {
            int i = 0;
            while (i < this.getDomainAxisCount()) {
                ValueAxis axis = this.getDomainAxis(i);
                if (axis != null) {
                    UnzoomableNumberAxis numberAxis;
                    axis.setAutoRange(true);
                    if (axis instanceof UnzoomableNumberAxis && (numberAxis = (UnzoomableNumberAxis)axis).getOriginalLowerBound() != null && numberAxis.getOriginalUpperBound() != null && numberAxis.getOriginalLowerBound() < numberAxis.getOriginalUpperBound()) {
                        numberAxis.setAutoRange(false);
                        numberAxis.setLowerBound(numberAxis.getOriginalLowerBound());
                        numberAxis.setUpperBound(numberAxis.getOriginalUpperBound());
                    }
                }
                ++i;
            }
            if (clearHistory) {
                this.domainAxisZoomHistory.clear();
            }
        } else {
            super.zoomDomainAxes(factor, info, source);
        }
    }

    @Override
    public void zoomRangeAxes(double factor, PlotRenderingInfo info, Point2D source) {
        this.zoomRangeAxes(true, factor, info, source);
    }

    private void zoomRangeAxes(boolean clearHistory, double factor, PlotRenderingInfo info, Point2D source) {
        if (factor == 0.0) {
            int i = 0;
            while (i < this.getRangeAxisCount()) {
                ValueAxis axis = this.getRangeAxis(i);
                if (axis != null) {
                    UnzoomableNumberAxis numberAxis;
                    axis.setAutoRange(true);
                    if (axis instanceof UnzoomableNumberAxis && (numberAxis = (UnzoomableNumberAxis)axis).getOriginalLowerBound() != null && numberAxis.getOriginalUpperBound() != null && numberAxis.getOriginalLowerBound() < numberAxis.getOriginalUpperBound()) {
                        numberAxis.setAutoRange(false);
                        numberAxis.setLowerBound(numberAxis.getOriginalLowerBound());
                        numberAxis.setUpperBound(numberAxis.getOriginalUpperBound());
                    }
                }
                ++i;
            }
            if (clearHistory) {
                this.rangeAxisZoomHistory.clear();
            }
        } else {
            super.zoomRangeAxes(factor, info, source);
        }
    }

    public UnzoomableXYPlot(XYDataset dataset, ValueAxis domainAxis, ValueAxis rangeAxis, XYItemRenderer renderer) {
        super(dataset, domainAxis, rangeAxis, renderer);
    }

    @Override
    public void zoomDomainAxes(double lowerPercent, double upperPercent, PlotRenderingInfo info, Point2D source) {
        super.zoomDomainAxes(lowerPercent, upperPercent, info, source);
        this.domainAxisZoomHistory.add(new ZoomSettings(lowerPercent, upperPercent));
    }

    @Override
    public void zoomRangeAxes(double lowerPercent, double upperPercent, PlotRenderingInfo info, Point2D source) {
        super.zoomRangeAxes(lowerPercent, upperPercent, info, source);
        this.rangeAxisZoomHistory.add(new ZoomSettings(lowerPercent, upperPercent));
    }

    public boolean canUnzoom() {
        return !this.domainAxisZoomHistory.isEmpty() || !this.rangeAxisZoomHistory.isEmpty();
    }

    public void unzoomAxes() {
        boolean saved = this.isNotify();
        this.setNotify(false);
        if (this.domainAxisZoomHistory.size() > 1 && this.rangeAxisZoomHistory.size() > 1) {
            this.domainAxisZoomHistory.remove(this.domainAxisZoomHistory.size() - 1);
            this.rangeAxisZoomHistory.remove(this.rangeAxisZoomHistory.size() - 1);
            this.applyLastZoom();
        } else {
            this.resetAxesZoom();
        }
        this.setNotify(saved);
    }

    public void resetAxesZoom() {
        boolean saved = this.isNotify();
        this.setNotify(false);
        this.zoomDomainAxes(true, 0.0, null, null);
        this.zoomRangeAxes(true, 0.0, null, null);
        this.setNotify(saved);
    }

    public void applyLastZoom() {
        boolean saved = this.isNotify();
        this.setNotify(false);
        this.zoomDomainAxes(false, 0.0, null, null);
        this.zoomRangeAxes(false, 0.0, null, null);
        int size = Math.min(this.domainAxisZoomHistory.size(), this.rangeAxisZoomHistory.size());
        int i = 0;
        while (i < size) {
            ZoomSettings state = this.domainAxisZoomHistory.get(i);
            super.zoomDomainAxes(state.getLowerPercent(), state.getUpperPercent(), null, null);
            state = this.rangeAxisZoomHistory.get(i);
            super.zoomRangeAxes(state.getLowerPercent(), state.getUpperPercent(), null, null);
            ++i;
        }
        this.setNotify(saved);
    }

    private class ZoomSettings {
        private final double lowerPercent;
        private final double upperPercent;

        public ZoomSettings(double lowerPercent, double upperPercent) {
            this.lowerPercent = lowerPercent;
            this.upperPercent = upperPercent;
        }

        public double getLowerPercent() {
            return this.lowerPercent;
        }

        public double getUpperPercent() {
            return this.upperPercent;
        }
    }
}

