/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.jfree.data;

import de.elpro.jfree.data.SeriesPoint;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public final class SeriesPointList
implements List<SeriesPoint> {
    private int size = 0;
    private final int maxSize;
    private long[] timestamp;
    private double[] xValue;
    private double[] yValue;
    private double[] metaValue;

    public SeriesPointList(int maxSize) {
        this.maxSize = maxSize;
        this.timestamp = new long[maxSize];
        this.xValue = new double[maxSize];
        this.yValue = new double[maxSize];
        this.metaValue = null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<SeriesPoint> iterator() {
        return new SeriesPointListIterator(this, 0);
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(SeriesPoint e) {
        if (this.size + 1 >= this.maxSize) {
            throw new IndexOutOfBoundsException();
        }
        this.timestamp[this.size] = SeriesPointList.toLong(e.getTimestamp());
        this.xValue[this.size] = SeriesPointList.toDouble(e.getXValue());
        this.yValue[this.size] = SeriesPointList.toDouble(e.getYValue());
        if (this.metaValue != null) {
            this.metaValue[this.size] = Double.NaN;
        }
        ++this.size;
        return true;
    }

    public boolean add(Long timestamp, Double xValue, Double yValue, Double metaValue) {
        if (this.size + 1 > this.maxSize) {
            throw new IndexOutOfBoundsException();
        }
        this.timestamp[this.size] = SeriesPointList.toLong(timestamp);
        this.xValue[this.size] = SeriesPointList.toDouble(xValue);
        this.yValue[this.size] = SeriesPointList.toDouble(yValue);
        if (metaValue != null && this.metaValue == null) {
            this.metaValue = new double[this.timestamp.length];
        }
        if (this.metaValue != null) {
            this.metaValue[this.size] = SeriesPointList.toDouble(metaValue);
        }
        ++this.size;
        return true;
    }

    public double getMetaValue(int index) {
        return this.metaValue == null ? Double.NaN : this.metaValue[index];
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends SeriesPoint> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends SeriesPoint> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.timestamp = new long[this.maxSize];
        this.xValue = new double[this.maxSize];
        this.yValue = new double[this.maxSize];
        this.metaValue = null;
        this.size = 0;
    }

    @Override
    public SeriesPoint get(int index) {
        if (index < 0 || index >= this.size || index >= this.maxSize) {
            throw new IndexOutOfBoundsException();
        }
        return new SeriesPoint(SeriesPointList.fromLong(this.timestamp[index]), SeriesPointList.fromDouble(this.xValue[index]), SeriesPointList.fromDouble(this.yValue[index]));
    }

    @Override
    public SeriesPoint set(int index, SeriesPoint e) {
        if (index < 0 || index >= this.size || index >= this.maxSize) {
            throw new IndexOutOfBoundsException();
        }
        SeriesPoint oldElements = new SeriesPoint(SeriesPointList.fromLong(this.timestamp[index]), SeriesPointList.fromDouble(this.xValue[index]), SeriesPointList.fromDouble(this.yValue[index]));
        this.timestamp[this.size] = SeriesPointList.toLong(e.getTimestamp());
        this.xValue[this.size] = SeriesPointList.toDouble(e.getXValue());
        this.yValue[this.size] = SeriesPointList.toDouble(e.getYValue());
        if (this.metaValue != null) {
            this.metaValue[this.size] = Double.NaN;
        }
        return oldElements;
    }

    @Override
    public void add(int index, SeriesPoint element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SeriesPoint remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<SeriesPoint> listIterator() {
        return new SeriesPointListIterator(this, 0);
    }

    @Override
    public ListIterator<SeriesPoint> listIterator(int index) {
        return new SeriesPointListIterator(this, index);
    }

    @Override
    public List<SeriesPoint> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    private static Long fromLong(long l) {
        if (l == Long.MIN_VALUE) {
            return null;
        }
        return l;
    }

    private static long toLong(Long l) {
        if (l == null) {
            return Long.MIN_VALUE;
        }
        return l;
    }

    private static Double fromDouble(double d) {
        if (Double.isFinite(d)) {
            return d;
        }
        return null;
    }

    private static double toDouble(Double d) {
        if (d == null) {
            return Double.NaN;
        }
        return d;
    }

    private static class SeriesPointListIterator
    implements ListIterator<SeriesPoint> {
        private final SeriesPointList list;
        private int position;

        public SeriesPointListIterator(SeriesPointList list, int position) {
            this.list = list;
            this.position = position;
        }

        @Override
        public boolean hasNext() {
            return this.position < this.list.size;
        }

        @Override
        public SeriesPoint next() {
            if (this.position >= this.list.size) {
                throw new NoSuchElementException();
            }
            SeriesPoint point = new SeriesPoint(SeriesPointList.fromLong(this.list.timestamp[this.position]), SeriesPointList.fromDouble(this.list.xValue[this.position]), SeriesPointList.fromDouble(this.list.yValue[this.position]));
            ++this.position;
            return point;
        }

        @Override
        public boolean hasPrevious() {
            return this.position > 0;
        }

        @Override
        public SeriesPoint previous() {
            if (this.position <= 0) {
                throw new NoSuchElementException();
            }
            int position = this.position - 1;
            SeriesPoint point = new SeriesPoint(SeriesPointList.fromLong(this.list.timestamp[position]), SeriesPointList.fromDouble(this.list.xValue[position]), SeriesPointList.fromDouble(this.list.yValue[position]));
            this.position = position;
            return point;
        }

        @Override
        public int nextIndex() {
            return this.position + 1;
        }

        @Override
        public int previousIndex() {
            return this.position - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(SeriesPoint e) {
            this.list.timestamp[this.position] = SeriesPointList.toLong(e.getTimestamp());
            this.list.xValue[this.position] = SeriesPointList.toDouble(e.getXValue());
            this.list.yValue[this.position] = SeriesPointList.toDouble(e.getYValue());
            if (this.list.metaValue != null) {
                this.list.metaValue[this.position] = Double.NaN;
            }
        }

        @Override
        public void add(SeriesPoint e) {
            throw new UnsupportedOperationException();
        }
    }
}

