/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.jfree.data.time;

import de.elpro.jfree.data.SeriesPoint;
import java.io.Serializable;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import org.jfree.chart.util.ObjectUtils;
import org.jfree.data.Range;
import org.jfree.data.general.Series;
import org.jfree.data.time.TimePeriodAnchor;

public class FixedLengthTimeSeries
extends Series
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -5032960206869675528L;
    protected static final String DEFAULT_DOMAIN_DESCRIPTION = "Time";
    protected static final String DEFAULT_RANGE_DESCRIPTION = "Value";
    private String domain;
    private String range;
    protected Class timePeriodClass;
    int length;
    long[] endTimestamps;
    double[] values;
    private int maximumItemCount;
    private long maximumItemAge;
    private double minY;
    private double maxY;

    public FixedLengthTimeSeries(List<SeriesPoint> seriesPoints, Comparable name) {
        this(seriesPoints, name, DEFAULT_DOMAIN_DESCRIPTION, DEFAULT_RANGE_DESCRIPTION);
    }

    public FixedLengthTimeSeries(List<SeriesPoint> seriesPoints, Comparable name, String domain, String range) {
        super(name);
        this.domain = domain;
        this.range = range;
        this.timePeriodClass = null;
        this.maximumItemCount = Integer.MAX_VALUE;
        this.maximumItemAge = Long.MAX_VALUE;
        this.minY = Double.NaN;
        this.maxY = Double.NaN;
        this.length = seriesPoints.size();
        this.endTimestamps = new long[this.length];
        this.values = new double[this.length];
        int index = 0;
        for (SeriesPoint sp : seriesPoints) {
            this.endTimestamps[index] = sp.getTimestamp();
            this.values[index] = sp.getYValue() != null ? sp.getYValue() : Double.NaN;
            if (sp.getYValue() != null && Double.isFinite(sp.getYValue())) {
                if (Double.isNaN(this.minY)) {
                    this.minY = sp.getYValue();
                    this.maxY = sp.getYValue();
                } else {
                    Math.min(this.minY, sp.getYValue());
                    Math.max(this.maxY, sp.getYValue());
                }
            }
            ++index;
        }
    }

    public String getDomainDescription() {
        return this.domain;
    }

    public void setDomainDescription(String description) {
        String old = this.domain;
        this.domain = description;
        this.firePropertyChange("Domain", old, description);
    }

    public String getRangeDescription() {
        return this.range;
    }

    public void setRangeDescription(String description) {
        String old = this.range;
        this.range = description;
        this.firePropertyChange("Range", old, description);
    }

    @Override
    public int getItemCount() {
        return this.values.length;
    }

    public List getItems() {
        throw new UnsupportedOperationException();
    }

    public int getMaximumItemCount() {
        return this.maximumItemCount;
    }

    public void setMaximumItemCount(int maximum) {
        throw new UnsupportedOperationException();
    }

    public long getMaximumItemAge() {
        return this.maximumItemAge;
    }

    public void setMaximumItemAge(long periods) {
        throw new UnsupportedOperationException();
    }

    public Range findValueRange() {
        if (this.length == 0) {
            return null;
        }
        return new Range(this.minY, this.maxY);
    }

    public Range findValueRange(Range xRange, TimeZone timeZone) {
        return this.findValueRange(xRange, TimePeriodAnchor.MIDDLE, timeZone);
    }

    public Range findValueRange(Range xRange, TimePeriodAnchor xAnchor, TimeZone zone) {
        if (this.length == 0) {
            return null;
        }
        Calendar.getInstance(zone);
        double lowY = Double.POSITIVE_INFINITY;
        double highY = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.length) {
            double v;
            long millis = this.endTimestamps[i];
            if (xRange.contains(millis) && !Double.isNaN(v = this.values[i])) {
                lowY = Math.min(lowY, v);
                highY = Math.max(highY, v);
            }
            ++i;
        }
        if (Double.isInfinite(lowY) && Double.isInfinite(highY)) {
            if (lowY < highY) {
                return new Range(lowY, highY);
            }
            return new Range(Double.NaN, Double.NaN);
        }
        return new Range(lowY, highY);
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public Class getTimePeriodClass() {
        return this.timePeriodClass;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FixedLengthTimeSeries clone = (FixedLengthTimeSeries)super.clone();
        clone.length = this.length;
        clone.endTimestamps = new long[this.length];
        clone.values = new double[this.length];
        clone.minY = this.minY;
        clone.maxY = this.maxY;
        int i = 0;
        while (i < this.length) {
            clone.endTimestamps[i] = this.endTimestamps[i];
            clone.values[i] = this.values[i];
            ++i;
        }
        return clone;
    }

    public FixedLengthTimeSeries createCopy(int start, int end) throws CloneNotSupportedException {
        if (start < 0) {
            throw new IllegalArgumentException("Requires start >= 0.");
        }
        if (end < start) {
            throw new IllegalArgumentException("Requires start <= end.");
        }
        FixedLengthTimeSeries copy = (FixedLengthTimeSeries)super.clone();
        copy.minY = Double.NaN;
        copy.maxY = Double.NaN;
        copy.length = this.length;
        copy.endTimestamps = new long[this.length];
        copy.values = new double[this.length];
        copy.minY = this.minY;
        copy.maxY = this.maxY;
        int i = 0;
        while (i < this.length) {
            copy.endTimestamps[i] = this.endTimestamps[i];
            copy.values[i] = this.values[i];
            ++i;
        }
        return copy;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FixedLengthTimeSeries)) {
            return false;
        }
        FixedLengthTimeSeries that = (FixedLengthTimeSeries)obj;
        if (!ObjectUtils.equal(this.getDomainDescription(), that.getDomainDescription())) {
            return false;
        }
        if (!ObjectUtils.equal(this.getRangeDescription(), that.getRangeDescription())) {
            return false;
        }
        if (!ObjectUtils.equal(this.timePeriodClass, that.timePeriodClass)) {
            return false;
        }
        if (this.getMaximumItemAge() != that.getMaximumItemAge()) {
            return false;
        }
        if (this.getMaximumItemCount() != that.getMaximumItemCount()) {
            return false;
        }
        int count = this.getItemCount();
        if (count != that.getItemCount()) {
            return false;
        }
        if (this.length != that.length) {
            return false;
        }
        int i = 0;
        while (i < this.length) {
            if (this.endTimestamps[i] != that.endTimestamps[i]) {
                return false;
            }
            if ((Double.isFinite(this.values[i]) || Double.isFinite(that.values[i])) && this.values[i] != that.values[i]) {
                return false;
            }
            ++i;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.domain != null ? this.domain.hashCode() : 0);
        result = 29 * result + (this.range != null ? this.range.hashCode() : 0);
        result = 29 * result + (this.timePeriodClass != null ? this.timePeriodClass.hashCode() : 0);
        this.getItemCount();
        result = 29 * result + this.maximumItemCount;
        result = 29 * result + (int)this.maximumItemAge;
        return result;
    }
}

