/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.jfree.data.time;

import de.elpro.jfree.data.time.FixedLengthTimeSeries;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import org.jfree.chart.util.ObjectUtils;
import org.jfree.data.DomainInfo;
import org.jfree.data.DomainOrder;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.Series;
import org.jfree.data.time.TimePeriodAnchor;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYDomainInfo;
import org.jfree.data.xy.XYRangeInfo;

public class FixedLengthTimeSeriesCollection
extends AbstractIntervalXYDataset
implements XYDataset,
IntervalXYDataset,
DomainInfo,
XYDomainInfo,
XYRangeInfo,
VetoableChangeListener,
Serializable {
    private static final long serialVersionUID = 1542976972124070531L;
    private List<FixedLengthTimeSeries> data;
    private Calendar workingCalendar;
    private TimePeriodAnchor xPosition;
    private boolean domainIsPointsInTime;

    public FixedLengthTimeSeriesCollection() {
        this(null, TimeZone.getDefault());
    }

    public FixedLengthTimeSeriesCollection(TimeZone zone) {
        this(null, zone);
    }

    public FixedLengthTimeSeriesCollection(FixedLengthTimeSeries series) {
        this(series, TimeZone.getDefault());
    }

    public FixedLengthTimeSeriesCollection(FixedLengthTimeSeries series, TimeZone zone) {
        if (zone == null) {
            zone = TimeZone.getDefault();
        }
        this.workingCalendar = Calendar.getInstance(zone);
        this.data = new ArrayList<FixedLengthTimeSeries>();
        if (series != null) {
            this.data.add(series);
            series.addChangeListener(this);
        }
        this.xPosition = TimePeriodAnchor.START;
        this.domainIsPointsInTime = true;
    }

    public boolean getDomainIsPointsInTime() {
        return this.domainIsPointsInTime;
    }

    public void setDomainIsPointsInTime(boolean flag) {
        this.domainIsPointsInTime = flag;
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    @Override
    public DomainOrder getDomainOrder() {
        return DomainOrder.ASCENDING;
    }

    public TimePeriodAnchor getXPosition() {
        return this.xPosition;
    }

    public void setXPosition(TimePeriodAnchor anchor) {
        this.xPosition = anchor;
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    public List getSeries() {
        return Collections.unmodifiableList(this.data);
    }

    @Override
    public int getSeriesCount() {
        return this.data.size();
    }

    public int indexOf(FixedLengthTimeSeries series) {
        return this.data.indexOf(series);
    }

    public FixedLengthTimeSeries getSeries(int series) {
        if (series < 0 || series >= this.getSeriesCount()) {
            throw new IllegalArgumentException("The 'series' argument is out of bounds (" + series + ").");
        }
        return this.data.get(series);
    }

    public FixedLengthTimeSeries getSeries(Comparable key) {
        FixedLengthTimeSeries result = null;
        for (FixedLengthTimeSeries series : this.data) {
            Comparable k = series.getKey();
            if (k == null || !k.equals(key)) continue;
            result = series;
        }
        return result;
    }

    @Override
    public Comparable getSeriesKey(int series) {
        return this.getSeries(series).getKey();
    }

    public int getSeriesIndex(Comparable key) {
        int seriesCount = this.getSeriesCount();
        int i = 0;
        while (i < seriesCount) {
            FixedLengthTimeSeries series = this.data.get(i);
            if (key.equals(series.getKey())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void addSeries(FixedLengthTimeSeries series) {
        this.data.add(series);
        series.addChangeListener(this);
        series.addVetoableChangeListener(this);
        this.fireDatasetChanged();
    }

    public void removeSeries(FixedLengthTimeSeries series) {
        this.data.remove(series);
        series.removeChangeListener(this);
        series.removeVetoableChangeListener(this);
        this.fireDatasetChanged();
    }

    public void removeSeries(int index) {
        FixedLengthTimeSeries series = this.getSeries(index);
        if (series != null) {
            this.removeSeries(series);
        }
    }

    public void removeAllSeries() {
        int i = 0;
        while (i < this.data.size()) {
            FixedLengthTimeSeries series = this.data.get(i);
            series.removeChangeListener(this);
            series.removeVetoableChangeListener(this);
            ++i;
        }
        this.data.clear();
        this.fireDatasetChanged();
    }

    @Override
    public int getItemCount(int series) {
        return this.getSeries(series).getItemCount();
    }

    @Override
    public double getXValue(int series, int item) {
        FixedLengthTimeSeries s = this.data.get(series);
        return s.endTimestamps[item];
    }

    @Override
    public Number getX(int series, int item) {
        FixedLengthTimeSeries s = this.data.get(series);
        return s.endTimestamps[item];
    }

    @Override
    public synchronized Number getStartX(int series, int item) {
        FixedLengthTimeSeries ts = this.data.get(series);
        return ts.endTimestamps[item];
    }

    @Override
    public synchronized Number getEndX(int series, int item) {
        FixedLengthTimeSeries ts = this.data.get(series);
        return ts.endTimestamps[item];
    }

    @Override
    public Number getY(int series, int item) {
        FixedLengthTimeSeries ts = this.data.get(series);
        return ts.values[item];
    }

    @Override
    public Number getStartY(int series, int item) {
        return this.getY(series, item);
    }

    @Override
    public Number getEndY(int series, int item) {
        return this.getY(series, item);
    }

    public int[] getSurroundingItems(int series, long milliseconds) {
        int[] result = new int[]{-1, -1};
        FixedLengthTimeSeries timeSeries = this.getSeries(series);
        int i = 0;
        while (i < timeSeries.getItemCount()) {
            Number x = this.getX(series, i);
            long m = x.longValue();
            if (m <= milliseconds) {
                result[0] = i;
            }
            if (m >= milliseconds) {
                result[1] = i;
                break;
            }
            ++i;
        }
        return result;
    }

    @Override
    public double getDomainLowerBound(boolean includeInterval) {
        double result = Double.NaN;
        Range r = this.getDomainBounds(includeInterval);
        if (r != null) {
            result = r.getLowerBound();
        }
        return result;
    }

    @Override
    public double getDomainUpperBound(boolean includeInterval) {
        double result = Double.NaN;
        Range r = this.getDomainBounds(includeInterval);
        if (r != null) {
            result = r.getUpperBound();
        }
        return result;
    }

    @Override
    public Range getDomainBounds(boolean includeInterval) {
        Range result = null;
        for (FixedLengthTimeSeries series : this.data) {
            int count = series.getItemCount();
            if (count <= 0) continue;
            Range temp = new Range(series.endTimestamps[0], series.endTimestamps[count - 1]);
            result = Range.combine(result, temp);
        }
        return result;
    }

    @Override
    public Range getDomainBounds(List visibleSeriesKeys, boolean includeInterval) {
        Range result = null;
        for (Comparable seriesKey : visibleSeriesKeys) {
            FixedLengthTimeSeries series = this.getSeries(seriesKey);
            int count = series.getItemCount();
            if (count <= 0) continue;
            Range temp = new Range(series.endTimestamps[0], series.endTimestamps[count - 1]);
            result = Range.combine(result, temp);
        }
        return result;
    }

    public Range getRangeBounds(boolean includeInterval) {
        Range result = null;
        for (FixedLengthTimeSeries series : this.data) {
            Range r = new Range(series.getMinY(), series.getMaxY());
            result = Range.combineIgnoringNaN(result, r);
        }
        return result;
    }

    @Override
    public Range getRangeBounds(List visibleSeriesKeys, Range xRange, boolean includeInterval) {
        Range result = null;
        for (Comparable seriesKey : visibleSeriesKeys) {
            FixedLengthTimeSeries series = this.getSeries(seriesKey);
            Range r = series.findValueRange(xRange, this.xPosition, this.workingCalendar.getTimeZone());
            result = Range.combineIgnoringNaN(result, r);
        }
        return result;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        if (!"Key".equals(e.getPropertyName())) {
            return;
        }
        Series s = (Series)e.getSource();
        if (this.getSeriesIndex(s.getKey()) == -1) {
            throw new IllegalStateException("Receiving events from a series that does not belong to this collection.");
        }
        Comparable key = (Comparable)e.getNewValue();
        if (this.getSeriesIndex(key) >= 0) {
            throw new PropertyVetoException("Duplicate key2", e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FixedLengthTimeSeriesCollection)) {
            return false;
        }
        FixedLengthTimeSeriesCollection that = (FixedLengthTimeSeriesCollection)obj;
        if (this.xPosition != that.xPosition) {
            return false;
        }
        if (this.domainIsPointsInTime != that.domainIsPointsInTime) {
            return false;
        }
        return ObjectUtils.equal(this.data, that.data);
    }

    public int hashCode() {
        int result = this.data.hashCode();
        result = 29 * result + (this.workingCalendar != null ? this.workingCalendar.hashCode() : 0);
        result = 29 * result + (this.xPosition != null ? this.xPosition.hashCode() : 0);
        result = 29 * result + (this.domainIsPointsInTime ? 1 : 0);
        return result;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FixedLengthTimeSeriesCollection clone = (FixedLengthTimeSeriesCollection)super.clone();
        clone.data = (List)ObjectUtils.deepClone(this.data);
        clone.workingCalendar = (Calendar)this.workingCalendar.clone();
        return clone;
    }
}

