/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.jfree.data.time;

import de.elpro.jfree.data.time.FixedLengthTimeSeries;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.jfree.chart.util.ObjectUtils;
import org.jfree.data.DomainInfo;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.time.TimePeriodAnchor;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.TableXYDataset;

public class FixedLengthTimeTableXYDataset
extends AbstractIntervalXYDataset
implements Cloneable,
IntervalXYDataset,
DomainInfo,
TableXYDataset {
    private List<FixedLengthTimeSeries> data = new ArrayList<FixedLengthTimeSeries>();
    private boolean domainIsPointsInTime;
    private TimePeriodAnchor xPosition;
    private Calendar workingCalendar;

    public FixedLengthTimeTableXYDataset() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    public FixedLengthTimeTableXYDataset(TimeZone zone) {
        this(zone, Locale.getDefault());
    }

    public FixedLengthTimeTableXYDataset(TimeZone zone, Locale locale) {
        this.workingCalendar = Calendar.getInstance(zone, locale);
        this.xPosition = TimePeriodAnchor.START;
    }

    public boolean getDomainIsPointsInTime() {
        return this.domainIsPointsInTime;
    }

    public void setDomainIsPointsInTime(boolean flag) {
        this.domainIsPointsInTime = flag;
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    public TimePeriodAnchor getXPosition() {
        return this.xPosition;
    }

    public void setXPosition(TimePeriodAnchor anchor) {
        this.xPosition = anchor;
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    public List getSeries() {
        return Collections.unmodifiableList(this.data);
    }

    @Override
    public int getSeriesCount() {
        return this.data.size();
    }

    public int indexOf(FixedLengthTimeSeries series) {
        return this.data.indexOf(series);
    }

    public FixedLengthTimeSeries getSeries(int series) {
        if (series < 0 || series >= this.getSeriesCount()) {
            throw new IllegalArgumentException("The 'series' argument is out of bounds (" + series + ").");
        }
        return this.data.get(series);
    }

    public FixedLengthTimeSeries getSeries(Comparable key) {
        FixedLengthTimeSeries result = null;
        for (FixedLengthTimeSeries series : this.data) {
            Comparable k = series.getKey();
            if (k == null || !k.equals(key)) continue;
            result = series;
        }
        return result;
    }

    @Override
    public Comparable getSeriesKey(int series) {
        return this.getSeries(series).getKey();
    }

    public int getSeriesIndex(Comparable key) {
        int seriesCount = this.getSeriesCount();
        int i = 0;
        while (i < seriesCount) {
            FixedLengthTimeSeries series = this.data.get(i);
            if (key.equals(series.getKey())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void addSeries(FixedLengthTimeSeries series) {
        if (!this.data.isEmpty() && this.data.get((int)(this.data.size() - 1)).length != series.length) {
            throw new UnsupportedOperationException("Series not of the same length");
        }
        this.data.add(series);
        series.addChangeListener(this);
        this.fireDatasetChanged();
    }

    public void removeSeries(FixedLengthTimeSeries series) {
        this.data.remove(series);
        series.removeChangeListener(this);
        this.fireDatasetChanged();
    }

    public void removeSeries(int index) {
        FixedLengthTimeSeries series = this.getSeries(index);
        if (series != null) {
            this.removeSeries(series);
        }
    }

    public void removeAllSeries() {
        int i = 0;
        while (i < this.data.size()) {
            FixedLengthTimeSeries series = this.data.get(i);
            series.removeChangeListener(this);
            ++i;
        }
        this.data.clear();
        this.fireDatasetChanged();
    }

    @Override
    public Number getX(int series, int item) {
        return new Double(this.getXValue(series, item));
    }

    @Override
    public double getXValue(int series, int item) {
        FixedLengthTimeSeries s = this.data.get(series);
        return s.endTimestamps[item];
    }

    @Override
    public Number getStartX(int series, int item) {
        return new Double(this.getStartXValue(series, item));
    }

    @Override
    public double getStartXValue(int series, int item) {
        FixedLengthTimeSeries s = this.data.get(series);
        return s.endTimestamps[item];
    }

    @Override
    public Number getEndX(int series, int item) {
        return new Double(this.getEndXValue(series, item));
    }

    @Override
    public double getEndXValue(int series, int item) {
        FixedLengthTimeSeries s = this.data.get(series);
        return s.endTimestamps[item];
    }

    @Override
    public Number getY(int series, int item) {
        FixedLengthTimeSeries ts = this.data.get(series);
        return ts.values[item];
    }

    @Override
    public Number getStartY(int series, int item) {
        return this.getY(series, item);
    }

    @Override
    public Number getEndY(int series, int item) {
        return this.getY(series, item);
    }

    @Override
    public double getDomainLowerBound(boolean includeInterval) {
        double result = Double.NaN;
        Range r = this.getDomainBounds(includeInterval);
        if (r != null) {
            result = r.getLowerBound();
        }
        return result;
    }

    @Override
    public double getDomainUpperBound(boolean includeInterval) {
        double result = Double.NaN;
        Range r = this.getDomainBounds(includeInterval);
        if (r != null) {
            result = r.getUpperBound();
        }
        return result;
    }

    @Override
    public Range getDomainBounds(boolean includeInterval) {
        int items = this.getItemCount();
        return new Range(this.getXValue(0, 0), this.getXValue(0, items));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FixedLengthTimeTableXYDataset)) {
            return false;
        }
        FixedLengthTimeTableXYDataset that = (FixedLengthTimeTableXYDataset)obj;
        if (this.domainIsPointsInTime != that.domainIsPointsInTime) {
            return false;
        }
        if (this.xPosition != that.xPosition) {
            return false;
        }
        if (!this.workingCalendar.getTimeZone().equals(that.workingCalendar.getTimeZone())) {
            return false;
        }
        return ObjectUtils.equal(this.data, that.data);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FixedLengthTimeTableXYDataset clone = (FixedLengthTimeTableXYDataset)super.clone();
        clone.data = (List)ObjectUtils.deepClone(this.data);
        clone.workingCalendar = (Calendar)this.workingCalendar.clone();
        return clone;
    }

    @Override
    public int getItemCount(int series) {
        return this.getItemCount();
    }

    @Override
    public int getItemCount() {
        if (this.data.isEmpty()) {
            return 0;
        }
        return this.data.get((int)0).length;
    }
}

