/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import org.jfree.chart.util.Args;

public class CompassFormat
extends NumberFormat {
    public final String[] directions;

    public CompassFormat() {
        this("N", "E", "S", "W");
    }

    public CompassFormat(String n, String e, String s, String w) {
        this(new String[]{n, String.valueOf(n) + n + e, String.valueOf(n) + e, String.valueOf(e) + n + e, e, String.valueOf(e) + s + e, String.valueOf(s) + e, String.valueOf(s) + s + e, s, String.valueOf(s) + s + w, String.valueOf(s) + w, String.valueOf(w) + s + w, w, String.valueOf(w) + n + w, String.valueOf(n) + w, String.valueOf(n) + n + w});
    }

    public CompassFormat(String[] directions) {
        Args.nullNotPermitted(directions, "directions");
        if (directions.length != 16) {
            throw new IllegalArgumentException("The 'directions' array must contain exactly 16 elements");
        }
        this.directions = directions;
    }

    public String getDirectionCode(double direction) {
        if ((direction %= 360.0) < 0.0) {
            direction += 360.0;
        }
        int index = ((int)Math.floor(direction / 11.25) + 1) / 2;
        return this.directions[index];
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        return toAppendTo.append(this.getDirectionCode(number));
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        return toAppendTo.append(this.getDirectionCode(number));
    }

    @Override
    public Number parse(String source, ParsePosition parsePosition) {
        return null;
    }
}

