/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYAreaRenderer2;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.Range;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;

public class StackedXYAreaRendererFast
extends XYAreaRenderer2
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -1068407842423253906L;
    private GeneralPath hotspot = null;
    private double[] prevSeriesY = null;
    private double prevTransX1 = 0.0;
    private Integer firstNotNullIndex = null;
    private boolean roundXCoordinates = true;

    public StackedXYAreaRendererFast() {
        this(null, null);
    }

    public StackedXYAreaRendererFast(XYToolTipGenerator labelGenerator, XYURLGenerator urlGenerator) {
        super(labelGenerator, urlGenerator);
    }

    public boolean getRoundXCoordinates() {
        return this.roundXCoordinates;
    }

    public void setRoundXCoordinates(boolean round) {
        this.roundXCoordinates = round;
        this.fireChangeEvent();
    }

    @Override
    public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        if (!this.getItemVisible(series, item)) {
            return;
        }
        double x1 = dataset.getXValue(series, item);
        double y1 = dataset.getYValue(series, item);
        double transX1 = (float)domainAxis.valueToJava2D(x1, dataArea, plot.getDomainAxisEdge());
        if (item == 0) {
            this.prevTransX1 = transX1;
        }
        if (Double.isNaN(y1) || y1 == 0.0) {
            y1 = 0.0;
            if (this.firstNotNullIndex != null) {
                this.closePath(this.hotspot, g2, dataset, domainAxis, rangeAxis, dataArea, plot, series, item);
                this.firstNotNullIndex = null;
                this.hotspot = null;
            }
        } else {
            EntityCollection entities;
            PlotOrientation orientation;
            if (this.firstNotNullIndex == null) {
                this.firstNotNullIndex = item;
                this.hotspot = this.beginPath(dataset, dataArea, plot, domainAxis, rangeAxis, series, item);
            }
            double transY1 = rangeAxis.valueToJava2D(y1 += this.prevSeriesY[item], dataArea, plot.getRangeAxisEdge());
            if (this.roundXCoordinates) {
                transX1 = Math.round(transX1);
            }
            if ((orientation = plot.getOrientation()) == PlotOrientation.HORIZONTAL) {
                StackedXYAreaRendererFast.lineTo(this.hotspot, transY1, transX1);
            } else {
                StackedXYAreaRendererFast.lineTo(this.hotspot, transX1, transY1);
            }
            if (state.getInfo() != null && (entities = state.getEntityCollection()) != null) {
                String tip = null;
                XYToolTipGenerator generator = this.getToolTipGenerator(series, item);
                if (generator != null) {
                    tip = generator.generateToolTip(dataset, series, item);
                }
                String url = null;
                if (this.getURLGenerator() != null) {
                    url = this.getURLGenerator().generateURL(dataset, series, item);
                }
                double transPrevY1 = rangeAxis.valueToJava2D(this.prevSeriesY[item], dataArea, plot.getRangeAxisEdge());
                GeneralPath gp = new GeneralPath();
                gp.moveTo(this.prevTransX1, transPrevY1);
                gp.lineTo(this.prevTransX1, transY1);
                gp.lineTo(transX1, transY1);
                gp.lineTo(transX1, transPrevY1);
                gp.closePath();
                XYItemEntity entity = new XYItemEntity(gp, dataset, series, item, tip, url);
                entities.add(entity);
            }
            int domainAxisIndex = plot.getDomainAxisIndex(domainAxis);
            this.updateCrosshairValues(crosshairState, x1, y1, domainAxisIndex, transX1, transY1, orientation);
        }
        this.prevTransX1 = transX1;
    }

    @Override
    public Object beforeDrawItems(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, CrosshairState crosshairState, int pass) {
        int itemsCount = dataset.getItemCount(series);
        this.prevSeriesY = new double[itemsCount];
        int i = 0;
        while (i < this.prevSeriesY.length) {
            this.prevSeriesY[i] = 0.0;
            int s = 0;
            while (s < series) {
                double prevY = dataset.getYValue(s, i);
                if (Double.isNaN(prevY)) {
                    prevY = 0.0;
                }
                int n = i;
                this.prevSeriesY[n] = this.prevSeriesY[n] + prevY;
                ++s;
            }
            ++i;
        }
        this.firstNotNullIndex = null;
        return null;
    }

    @Override
    public void afterDrawItems(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int lastItem, CrosshairState crosshairState, int pass, Object object) {
        if (this.firstNotNullIndex == null) {
            return;
        }
        this.closePath(this.hotspot, g2, dataset, domainAxis, rangeAxis, dataArea, plot, series, lastItem);
        if (this.isOutline()) {
            g2.setStroke(this.lookupSeriesOutlineStroke(series));
            g2.setPaint(this.lookupSeriesOutlinePaint(series));
            g2.draw(this.hotspot);
        }
        this.firstNotNullIndex = null;
        this.hotspot = null;
    }

    private GeneralPath beginPath(XYDataset dataset, Rectangle2D dataArea, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, int series, int item) {
        GeneralPath hotspot = new GeneralPath();
        double x0 = dataset.getXValue(series, item);
        double transX0 = domainAxis.valueToJava2D(x0, dataArea, plot.getDomainAxisEdge());
        double transZero = rangeAxis.valueToJava2D(0.0, dataArea, plot.getRangeAxisEdge());
        if (plot.getOrientation() == PlotOrientation.HORIZONTAL) {
            StackedXYAreaRendererFast.moveTo(hotspot, transZero, transX0);
        } else {
            StackedXYAreaRendererFast.moveTo(hotspot, transX0, transZero);
        }
        return hotspot;
    }

    private void closePath(GeneralPath hotspot, Graphics2D g2, XYDataset dataset, ValueAxis domainAxis, ValueAxis rangeAxis, Rectangle2D dataArea, XYPlot plot, int series, int lastItem) {
        double prevTransX1 = 0.0;
        int i = lastItem;
        while (i >= this.firstNotNullIndex) {
            double x1 = dataset.getXValue(series, i);
            double prevY1 = this.prevSeriesY[i];
            float transX1 = (float)domainAxis.valueToJava2D(x1, dataArea, plot.getDomainAxisEdge());
            if (this.roundXCoordinates) {
                transX1 = Math.round(transX1);
            }
            double transPrevY1 = rangeAxis.valueToJava2D(prevY1, dataArea, plot.getRangeAxisEdge());
            if (i + 1 <= lastItem && prevY1 == 0.0 && this.prevSeriesY[i + 1] != 0.0) {
                if (plot.getOrientation() == PlotOrientation.HORIZONTAL) {
                    StackedXYAreaRendererFast.lineTo(hotspot, transPrevY1, prevTransX1);
                } else {
                    StackedXYAreaRendererFast.lineTo(hotspot, prevTransX1, transPrevY1);
                }
            }
            if (plot.getOrientation() == PlotOrientation.HORIZONTAL) {
                StackedXYAreaRendererFast.lineTo(hotspot, transPrevY1, transX1);
            } else {
                StackedXYAreaRendererFast.lineTo(hotspot, transX1, transPrevY1);
            }
            prevTransX1 = transX1;
            --i;
        }
        hotspot.closePath();
        Paint paint = this.getItemPaint(series, 0);
        Stroke stroke = this.getItemStroke(series, 0);
        g2.setPaint(paint);
        g2.setStroke(stroke);
        g2.fill(hotspot);
    }

    @Override
    public Range findRangeBounds(XYDataset dataset) {
        if (dataset == null) {
            return null;
        }
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        TableXYDataset d = (TableXYDataset)dataset;
        int itemCount = d.getItemCount();
        int i = 0;
        while (i < itemCount) {
            double[] stackValues = this.getStackValues((TableXYDataset)dataset, d.getSeriesCount(), i);
            min = Math.min(min, stackValues[0]);
            max = Math.max(max, stackValues[1]);
            ++i;
        }
        if (min == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(min, max);
    }

    private double[] getStackValues(TableXYDataset dataset, int series, int index) {
        double[] result = new double[2];
        int i = 0;
        while (i < series) {
            double v = dataset.getYValue(i, index);
            if (!Double.isNaN(v)) {
                if (v >= 0.0) {
                    result[1] = result[1] + v;
                } else {
                    result[0] = result[0] + v;
                }
            }
            ++i;
        }
        return result;
    }

    @Override
    public int getPassCount() {
        return 1;
    }
}

