/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYAreaRenderer2;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.XYDataset;

public class XYAreaRendererFast
extends XYAreaRenderer2 {
    private static final long serialVersionUID = -239256297161271969L;
    private GeneralPath hotspot = null;
    private double transZero = 0.0;
    private double prevTransX = 0.0;
    private Integer firstNotNullIndex = null;

    @Override
    public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        if (!this.getItemVisible(series, item)) {
            return;
        }
        double x1 = dataset.getXValue(series, item);
        double y1 = dataset.getYValue(series, item);
        double transX1 = (float)domainAxis.valueToJava2D(x1, dataArea, plot.getDomainAxisEdge());
        if (item == 0) {
            this.prevTransX = transX1;
        }
        if (Double.isNaN(y1) || y1 == 0.0) {
            y1 = 0.0;
            if (this.firstNotNullIndex != null) {
                this.closePath(this.hotspot, g2, dataset, domainAxis, rangeAxis, dataArea, plot, series, item);
                this.firstNotNullIndex = null;
                this.hotspot = null;
            }
        } else {
            EntityCollection entities;
            if (this.firstNotNullIndex == null) {
                this.firstNotNullIndex = item;
                this.hotspot = this.beginPath(dataset, dataArea, plot, domainAxis, rangeAxis, series, item);
            }
            double transY1 = rangeAxis.valueToJava2D(y1, dataArea, plot.getRangeAxisEdge());
            PlotOrientation orientation = plot.getOrientation();
            if (orientation == PlotOrientation.HORIZONTAL) {
                XYAreaRendererFast.lineTo(this.hotspot, transY1, transX1);
            } else {
                XYAreaRendererFast.lineTo(this.hotspot, transX1, transY1);
            }
            if (state.getInfo() != null && (entities = state.getEntityCollection()) != null) {
                String tip = null;
                XYToolTipGenerator generator = this.getToolTipGenerator(series, item);
                if (generator != null) {
                    tip = generator.generateToolTip(dataset, series, item);
                }
                String url = null;
                if (this.getURLGenerator() != null) {
                    url = this.getURLGenerator().generateURL(dataset, series, item);
                }
                GeneralPath gp = new GeneralPath();
                gp.moveTo(this.prevTransX, this.transZero);
                gp.lineTo(this.prevTransX, transY1);
                gp.lineTo(transX1, transY1);
                gp.lineTo(transX1, this.transZero);
                gp.closePath();
                XYItemEntity entity = new XYItemEntity(gp, dataset, series, item, tip, url);
                entities.add(entity);
            }
        }
        this.prevTransX = transX1;
    }

    @Override
    public Object beforeDrawItems(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, CrosshairState crosshairState, int pass) {
        this.firstNotNullIndex = null;
        return null;
    }

    @Override
    public void afterDrawItems(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int lastItem, CrosshairState crosshairState, int pass, Object object) {
        if (this.firstNotNullIndex == null) {
            return;
        }
        this.closePath(this.hotspot, g2, dataset, domainAxis, rangeAxis, dataArea, plot, series, lastItem);
        if (this.isOutline()) {
            g2.setStroke(this.lookupSeriesOutlineStroke(series));
            g2.setPaint(this.lookupSeriesOutlinePaint(series));
            g2.draw(this.hotspot);
        }
        this.firstNotNullIndex = null;
        this.hotspot = null;
    }

    private GeneralPath beginPath(XYDataset dataset, Rectangle2D dataArea, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, int series, int item) {
        GeneralPath hotspot = new GeneralPath();
        double x0 = dataset.getXValue(series, item);
        double transX0 = domainAxis.valueToJava2D(x0, dataArea, plot.getDomainAxisEdge());
        double transZero = rangeAxis.valueToJava2D(0.0, dataArea, plot.getRangeAxisEdge());
        if (plot.getOrientation() == PlotOrientation.HORIZONTAL) {
            XYAreaRendererFast.moveTo(hotspot, transZero, transX0);
        } else {
            XYAreaRendererFast.moveTo(hotspot, transX0, transZero);
        }
        return hotspot;
    }

    private void closePath(GeneralPath hotspot, Graphics2D g2, XYDataset dataset, ValueAxis domainAxis, ValueAxis rangeAxis, Rectangle2D dataArea, XYPlot plot, int series, int lastItem) {
        double lastX = dataset.getXValue(series, lastItem);
        double transLastX = domainAxis.valueToJava2D(lastX, dataArea, plot.getDomainAxisEdge());
        double transZero = rangeAxis.valueToJava2D(0.0, dataArea, plot.getRangeAxisEdge());
        if (plot.getOrientation() == PlotOrientation.HORIZONTAL) {
            XYAreaRendererFast.lineTo(hotspot, transZero, transLastX);
        } else {
            XYAreaRendererFast.lineTo(hotspot, transLastX, transZero);
        }
        hotspot.closePath();
        Paint paint = this.getItemPaint(series, 0);
        Stroke stroke = this.getItemStroke(series, 0);
        g2.setPaint(paint);
        g2.setStroke(stroke);
        g2.fill(hotspot);
    }
}

