/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import org.jfree.chart.util.PublicCloneable;

public final class ObjectUtils {
    private ObjectUtils() {
    }

    public static boolean equal(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 != null) {
            return o1.equals(o2);
        }
        return false;
    }

    public static int hashCode(Object object) {
        int result = 0;
        if (object != null) {
            result = object.hashCode();
        }
        return result;
    }

    public static Object clone(Object object) throws CloneNotSupportedException {
        if (object == null) {
            throw new IllegalArgumentException("Null 'object' argument.");
        }
        if (object instanceof PublicCloneable) {
            PublicCloneable pc = (PublicCloneable)object;
            return pc.clone();
        }
        try {
            Method method = object.getClass().getMethod("clone", null);
            if (Modifier.isPublic(method.getModifiers())) {
                return method.invoke(object, null);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new CloneNotSupportedException("Object without clone() method is impossible.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CloneNotSupportedException("Object.clone(): unable to call method.");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new CloneNotSupportedException("Object without clone() method is impossible.");
        }
        throw new CloneNotSupportedException("Failed to clone.");
    }

    public static Collection deepClone(Collection collection) throws CloneNotSupportedException {
        if (collection == null) {
            throw new IllegalArgumentException("Null 'collection' argument.");
        }
        Collection result = (Collection)ObjectUtils.clone(collection);
        result.clear();
        for (Object item : collection) {
            if (item != null) {
                result.add(ObjectUtils.clone(item));
                continue;
            }
            result.add(null);
        }
        return result;
    }
}

