/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics;

import org.jfree.chart.util.Args;
import org.jfree.data.xy.XYDataset;

public abstract class Regression {
    public static double[] getOLSRegression(double[][] data) {
        int n = data.length;
        if (n < 2) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double sumX = 0.0;
        double sumY = 0.0;
        double sumXX = 0.0;
        double sumXY = 0.0;
        int i = 0;
        while (i < n) {
            double x = data[i][0];
            double y = data[i][1];
            sumX += x;
            sumY += y;
            double xx = x * x;
            sumXX += xx;
            double xy = x * y;
            sumXY += xy;
            ++i;
        }
        double sxx = sumXX - sumX * sumX / (double)n;
        double sxy = sumXY - sumX * sumY / (double)n;
        double xbar = sumX / (double)n;
        double ybar = sumY / (double)n;
        double[] result = new double[2];
        result[1] = sxy / sxx;
        result[0] = ybar - result[1] * xbar;
        return result;
    }

    public static double[] getOLSRegression(XYDataset data, int series) {
        int n = data.getItemCount(series);
        if (n < 2) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double sumX = 0.0;
        double sumY = 0.0;
        double sumXX = 0.0;
        double sumXY = 0.0;
        int i = 0;
        while (i < n) {
            double x = data.getXValue(series, i);
            double y = data.getYValue(series, i);
            sumX += x;
            sumY += y;
            double xx = x * x;
            sumXX += xx;
            double xy = x * y;
            sumXY += xy;
            ++i;
        }
        double sxx = sumXX - sumX * sumX / (double)n;
        double sxy = sumXY - sumX * sumY / (double)n;
        double xbar = sumX / (double)n;
        double ybar = sumY / (double)n;
        double[] result = new double[2];
        result[1] = sxy / sxx;
        result[0] = ybar - result[1] * xbar;
        return result;
    }

    public static double[] getPowerRegression(double[][] data) {
        int n = data.length;
        if (n < 2) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double sumX = 0.0;
        double sumY = 0.0;
        double sumXX = 0.0;
        double sumXY = 0.0;
        int i = 0;
        while (i < n) {
            double x = Math.log(data[i][0]);
            double y = Math.log(data[i][1]);
            sumX += x;
            sumY += y;
            double xx = x * x;
            sumXX += xx;
            double xy = x * y;
            sumXY += xy;
            ++i;
        }
        double sxx = sumXX - sumX * sumX / (double)n;
        double sxy = sumXY - sumX * sumY / (double)n;
        double xbar = sumX / (double)n;
        double ybar = sumY / (double)n;
        double[] result = new double[2];
        result[1] = sxy / sxx;
        result[0] = Math.pow(Math.exp(1.0), ybar - result[1] * xbar);
        return result;
    }

    public static double[] getPowerRegression(XYDataset data, int series) {
        int n = data.getItemCount(series);
        if (n < 2) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double sumX = 0.0;
        double sumY = 0.0;
        double sumXX = 0.0;
        double sumXY = 0.0;
        int i = 0;
        while (i < n) {
            double x = Math.log(data.getXValue(series, i));
            double y = Math.log(data.getYValue(series, i));
            sumX += x;
            sumY += y;
            double xx = x * x;
            sumXX += xx;
            double xy = x * y;
            sumXY += xy;
            ++i;
        }
        double sxx = sumXX - sumX * sumX / (double)n;
        double sxy = sumXY - sumX * sumY / (double)n;
        double xbar = sumX / (double)n;
        double ybar = sumY / (double)n;
        double[] result = new double[2];
        result[1] = sxy / sxx;
        result[0] = Math.pow(Math.exp(1.0), ybar - result[1] * xbar);
        return result;
    }

    public static double[] getPolynomialRegression(XYDataset dataset, int series, int order) {
        double rSquare;
        int coe;
        int eq;
        Args.nullNotPermitted(dataset, "dataset");
        int itemCount = dataset.getItemCount(series);
        if (itemCount < order + 1) {
            throw new IllegalArgumentException("Not enough data.");
        }
        int validItems = 0;
        double[][] data = new double[2][itemCount];
        int item = 0;
        while (item < itemCount) {
            double x = dataset.getXValue(series, item);
            double y = dataset.getYValue(series, item);
            if (!Double.isNaN(x) && !Double.isNaN(y)) {
                data[0][validItems] = x;
                data[1][validItems] = y;
                ++validItems;
            }
            ++item;
        }
        if (validItems < order + 1) {
            throw new IllegalArgumentException("Not enough data.");
        }
        int equations = order + 1;
        int coefficients = order + 2;
        double[] result = new double[equations + 1];
        double[][] matrix = new double[equations][coefficients];
        double sumY = 0.0;
        int item2 = 0;
        while (item2 < validItems) {
            double cfr_ignored_0 = data[0][item2];
            sumY += data[1][item2];
            eq = 0;
            while (eq < equations) {
                coe = 0;
                while (coe < coefficients - 1) {
                    double[] dArray = matrix[eq];
                    int n = coe;
                    dArray[n] = dArray[n] + Math.pow(data[0][item2], eq + coe);
                    ++coe;
                }
                double[] dArray = matrix[eq];
                int n = coefficients - 1;
                dArray[n] = dArray[n] + data[1][item2] * Math.pow(data[0][item2], eq);
                ++eq;
            }
            ++item2;
        }
        double[][] subMatrix = Regression.calculateSubMatrix(matrix);
        eq = 1;
        while (eq < equations) {
            matrix[eq][0] = 0.0;
            coe = 1;
            while (coe < coefficients) {
                matrix[eq][coe] = subMatrix[eq - 1][coe - 1];
                ++coe;
            }
            ++eq;
        }
        eq = equations - 1;
        while (eq > -1) {
            double value = matrix[eq][coefficients - 1];
            int coe2 = eq;
            while (coe2 < coefficients - 1) {
                value -= matrix[eq][coe2] * result[coe2];
                ++coe2;
            }
            result[eq] = value / matrix[eq][eq];
            --eq;
        }
        double meanY = sumY / (double)validItems;
        double yObsSquare = 0.0;
        double yRegSquare = 0.0;
        int item3 = 0;
        while (item3 < validItems) {
            double yCalc = 0.0;
            int eq2 = 0;
            while (eq2 < equations) {
                yCalc += result[eq2] * Math.pow(data[0][item3], eq2);
                ++eq2;
            }
            yRegSquare += Math.pow(yCalc - meanY, 2.0);
            yObsSquare += Math.pow(data[1][item3] - meanY, 2.0);
            ++item3;
        }
        result[equations] = rSquare = yRegSquare / yObsSquare;
        return result;
    }

    private static double[][] calculateSubMatrix(double[][] matrix) {
        int equations = matrix.length;
        int coefficients = matrix[0].length;
        double[][] result = new double[equations - 1][coefficients - 1];
        int eq = 1;
        while (eq < equations) {
            double factor = matrix[0][0] / matrix[eq][0];
            int coe = 1;
            while (coe < coefficients) {
                result[eq - 1][coe - 1] = matrix[0][coe] - matrix[eq][coe] * factor;
                ++coe;
            }
            ++eq;
        }
        if (equations == 1) {
            return result;
        }
        if (result[0][0] == 0.0) {
            boolean found = false;
            int i = 0;
            while (i < result.length) {
                if (result[i][0] != 0.0) {
                    found = true;
                    double[] temp = result[0];
                    System.arraycopy(result[i], 0, result[0], 0, result[i].length);
                    System.arraycopy(temp, 0, result[i], 0, temp.length);
                    break;
                }
                ++i;
            }
            if (!found) {
                return new double[equations - 1][coefficients - 1];
            }
        }
        double[][] subMatrix = Regression.calculateSubMatrix(result);
        int eq2 = 1;
        while (eq2 < equations - 1) {
            result[eq2][0] = 0.0;
            int coe = 1;
            while (coe < coefficients - 1) {
                result[eq2][coe] = subMatrix[eq2 - 1][coe - 1];
                ++coe;
            }
            ++eq2;
        }
        return result;
    }
}

