/*
 * Decompiled with CFR 0.152.
 */
import com.castortech.mdbxjni.Cursor;
import com.castortech.mdbxjni.CursorOp;
import com.castortech.mdbxjni.Database;
import com.castortech.mdbxjni.Entry;
import com.castortech.mdbxjni.Env;
import com.castortech.mdbxjni.EnvConfig;
import com.castortech.mdbxjni.EnvInfo;
import com.castortech.mdbxjni.JNI;
import com.castortech.mdbxjni.Transaction;

public class TestMDBX {
    static Env env;
    static Database db;

    public static void main(String[] args) throws Exception {
        System.out.println(String.valueOf(JNI.MDBX_VERSION_MAJOR) + "." + JNI.MDBX_VERSION_MINOR);
        EnvConfig envConfig = new EnvConfig();
        env = new Env();
        try {
            EnvInfo info;
            Transaction tx;
            Transaction tx22;
            long mbSize = 0x100000L;
            long sizeLower = mbSize * 10L;
            long sizeUpper = mbSize * 1000L * 100L;
            long growthStep = mbSize * 100L;
            long shrinkThreshold = (long)((double)growthStep * 1.2);
            envConfig.setMapLower(sizeLower);
            envConfig.setMapUpper(sizeUpper);
            envConfig.setMapGrowth(growthStep);
            envConfig.setMapShrink(shrinkThreshold);
            env.open("C:/MyDB", envConfig);
            db = env.openDatabase();
            int index = 0;
            int rounds = 1000;
            String valuePrefix = "";
            int i = 0;
            while (i < 200) {
                valuePrefix = String.valueOf(valuePrefix) + "value" + i + "_";
                ++i;
            }
            long ts = System.nanoTime();
            Throwable throwable = null;
            Throwable throwable2 = null;
            try {
                tx22 = env.createReadTransaction();
                try {
                    EnvInfo info2 = env.info(tx22);
                    System.out.println("Size " + info2.getGeo().getCurrent());
                }
                finally {
                    if (tx22 != null) {
                        tx22.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            int i2 = 0;
            while (i2 < rounds) {
                index = TestMDBX.addValues(index, valuePrefix, 1000);
                if (i2 % 1 == 0) {
                    throwable2 = null;
                    tx22 = null;
                    try {
                        tx = env.createReadTransaction();
                        try {
                            info = env.info(tx);
                            System.out.println("Size " + info.getGeo().getCurrent());
                        }
                        finally {
                            if (tx != null) {
                                tx.close();
                            }
                        }
                    }
                    catch (Throwable tx22) {
                        if (throwable2 == null) {
                            throwable2 = tx22;
                        } else if (throwable2 != tx22) {
                            throwable2.addSuppressed(tx22);
                        }
                        throw throwable2;
                    }
                }
                ++i2;
            }
            System.err.println(String.format("Write Op done in: %.2fms", (double)(System.nanoTime() - ts) / 1000000.0));
            ts = System.nanoTime();
            index = 0;
            i2 = 0;
            while (i2 < rounds) {
                index = TestMDBX.validateValues(index, valuePrefix, 1000);
                ++i2;
            }
            System.err.println(String.format("Read Single Op done in: %.2fms", (double)(System.nanoTime() - ts) / 1000000.0));
            ts = System.nanoTime();
            Throwable i22 = null;
            throwable2 = null;
            try {
                tx22 = env.createReadTransaction();
                try {
                    Cursor cursor = db.openCursor(tx22);
                    Entry entry = cursor.get(CursorOp.FIRST);
                    while ((entry = cursor.get(CursorOp.NEXT, entry.getKey())) != null) {
                    }
                }
                finally {
                    if (tx22 != null) {
                        tx22.close();
                    }
                }
            }
            catch (Throwable throwable4) {
                if (i22 == null) {
                    i22 = throwable4;
                } else if (i22 != throwable4) {
                    i22.addSuppressed(throwable4);
                }
                throw i22;
            }
            System.err.println(String.format("Read Cursor Op done in: %.2fms", (double)(System.nanoTime() - ts) / 1000000.0));
            ts = System.nanoTime();
            index = 0;
            i = 0;
            while (i < rounds) {
                index = TestMDBX.deleteValues(index, 1000);
                if (i % 100 == 0) {
                    throwable2 = null;
                    Object var19_23 = null;
                    try {
                        tx = env.createReadTransaction();
                        try {
                            info = env.info(tx);
                            System.out.println("Size " + info.getGeo().getCurrent());
                        }
                        finally {
                            if (tx != null) {
                                tx.close();
                            }
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                ++i;
            }
            System.err.println(String.format("Delete Op done in: %.2fms", (double)(System.nanoTime() - ts) / 1000000.0));
            ts = System.nanoTime();
            db.close();
        }
        finally {
            env.close();
        }
    }

    public static int addValues(int index, String valuePrefix, int count) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Transaction tx = env.createTransaction(false);){
            int i = 0;
            while (i < count) {
                String key = "key_" + index;
                String value = String.valueOf(valuePrefix) + index;
                db.put(tx, key.getBytes(), value.getBytes());
                ++index;
                ++i;
            }
            tx.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return index;
    }

    public static int validateValues(int index, String valuePrefix, int count) throws Exception {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Transaction tx = env.createTransaction(true);){
            int i = 0;
            while (i < count) {
                String key = "key_" + index;
                String cfr_ignored_0 = String.valueOf(valuePrefix) + index;
                byte[] valueBytes = db.get(tx, key.getBytes());
                new String(valueBytes);
                ++index;
                ++i;
            }
            tx.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return index;
    }

    public static int deleteValues(int index, int count) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Transaction tx = env.createTransaction(false);){
            int i = 0;
            while (i < count) {
                String key = "key_" + index;
                db.delete(tx, key.getBytes());
                ++index;
                ++i;
            }
            tx.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return index;
    }
}

