/*
 * Decompiled with CFR 0.152.
 */
package com.castortech.mdbxjni;

import com.castortech.mdbxjni.CursorOp;
import com.castortech.mdbxjni.Database;
import com.castortech.mdbxjni.DatabaseEntry;
import com.castortech.mdbxjni.Entry;
import com.castortech.mdbxjni.Env;
import com.castortech.mdbxjni.JNI;
import com.castortech.mdbxjni.NativeBuffer;
import com.castortech.mdbxjni.NativeObject;
import com.castortech.mdbxjni.OperationStatus;
import com.castortech.mdbxjni.SecondaryDatabase;
import com.castortech.mdbxjni.SecondaryDbConfig;
import com.castortech.mdbxjni.Transaction;
import com.castortech.mdbxjni.Util;
import com.castortech.mdbxjni.Value;
import java.util.HashSet;

public class Cursor
extends NativeObject
implements AutoCloseable {
    private final Env env;
    private final Transaction tx;
    private final Database db;

    Cursor(Env env, long self, Transaction tx, Database db) {
        super(self);
        this.env = env;
        this.tx = tx;
        this.db = db;
    }

    @Override
    public void close() {
        if (this.self != 0L) {
            JNI.mdbx_cursor_close(this.self);
            this.self = 0L;
        }
    }

    public void renew(Transaction tx) {
        Util.checkErrorCode(this.env, JNI.mdbx_cursor_renew(tx.pointer(), this.pointer()));
    }

    public Entry get(CursorOp op) {
        Util.checkArgNotNull((Object)op, "op");
        Value key = new Value();
        Value value = new Value();
        int rc = JNI.mdbx_cursor_get(this.pointer(), key, value, op.getValue());
        if (rc == JNI.MDBX_NOTFOUND) {
            return null;
        }
        Util.checkErrorCode(this.env, rc);
        return new Entry(key.toByteArray(), value.toByteArray());
    }

    public Entry get(CursorOp op, byte[] key) {
        Util.checkArgNotNull((Object)op, "op");
        NativeBuffer keyBuffer = NativeBuffer.create(key);
        try {
            Value keyValue = new Value(keyBuffer);
            Value value = new Value();
            int rc = JNI.mdbx_cursor_get(this.pointer(), keyValue, value, op.getValue());
            if (rc == JNI.MDBX_NOTFOUND) {
                return null;
            }
            Util.checkErrorCode(this.env, rc);
            Entry entry = new Entry(keyValue.toByteArray(), value.toByteArray());
            return entry;
        }
        finally {
            if (keyBuffer != null) {
                keyBuffer.delete();
            }
        }
    }

    public Entry get(CursorOp op, byte[] key, byte[] value) {
        Util.checkArgNotNull((Object)op, "op");
        NativeBuffer keyBuffer = NativeBuffer.create(key);
        NativeBuffer valBuffer = NativeBuffer.create(value);
        try {
            Value keyValue = keyBuffer != null ? new Value(keyBuffer) : new Value();
            Value valValue = valBuffer != null ? new Value(valBuffer) : new Value();
            int rc = JNI.mdbx_cursor_get(this.pointer(), keyValue, valValue, op.getValue());
            if (rc == JNI.MDBX_NOTFOUND) {
                return null;
            }
            Util.checkErrorCode(this.env, rc);
            Entry entry = new Entry(keyValue.toByteArray(), valValue.toByteArray());
            return entry;
        }
        finally {
            if (keyBuffer != null) {
                keyBuffer.delete();
            }
            if (valBuffer != null) {
                valBuffer.delete();
            }
        }
    }

    public OperationStatus get(CursorOp op, DatabaseEntry key, DatabaseEntry value) {
        Util.checkArgNotNull((Object)op, "op");
        NativeBuffer keyBuffer = NativeBuffer.create(key.getData());
        NativeBuffer valBuffer = NativeBuffer.create(value.getData());
        try {
            Value keyValue = keyBuffer != null ? new Value(keyBuffer) : new Value();
            Value valValue = valBuffer != null ? new Value(valBuffer) : new Value();
            int rc = JNI.mdbx_cursor_get(this.pointer(), keyValue, valValue, op.getValue());
            if (rc == JNI.MDBX_NOTFOUND) {
                OperationStatus operationStatus = OperationStatus.NOTFOUND;
                return operationStatus;
            }
            Util.checkErrorCode(this.env, rc);
            key.setData(keyValue.toByteArray());
            value.setData(valValue.toByteArray());
            OperationStatus operationStatus = OperationStatus.SUCCESS;
            return operationStatus;
        }
        finally {
            if (keyBuffer != null) {
                keyBuffer.delete();
            }
            if (valBuffer != null) {
                valBuffer.delete();
            }
        }
    }

    public byte[] put(byte[] key, byte[] value, int flags) {
        Util.checkArgNotNull(key, "key");
        Util.checkArgNotNull(value, "value");
        NativeBuffer keyBuffer = NativeBuffer.create(key);
        try {
            NativeBuffer valBuffer = NativeBuffer.create(value);
            try {
                byte[] byArray = this.put(keyBuffer, valBuffer, flags);
                if (valBuffer != null) {
                    valBuffer.delete();
                }
                return byArray;
            }
            catch (Throwable throwable) {
                if (valBuffer != null) {
                    valBuffer.delete();
                }
                throw throwable;
            }
        }
        finally {
            if (keyBuffer != null) {
                keyBuffer.delete();
            }
        }
    }

    private byte[] put(NativeBuffer keyBuffer, NativeBuffer valueBuffer, int flags) {
        return this.put(new Value(keyBuffer), new Value(valueBuffer), flags);
    }

    private byte[] put(Value keySlice, Value valueSlice, int flags) {
        boolean hasSec = this.db.getSecondaries() != null;
        HashSet<Value> valueSlices = new HashSet<Value>();
        if (hasSec && (flags & JNI.MDBX_NOOVERWRITE) == 0 && (flags & JNI.MDBX_NODUPDATA) == 0) {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Cursor cursor = this.db.openCursor(this.tx);){
                byte[] key = keySlice.toByteArray();
                Entry entry = cursor.get(CursorOp.SET, key);
                if (entry != null) {
                    NativeBuffer valueBuffer = NativeBuffer.create(entry.getValue());
                    valueSlices.add(Value.create(valueBuffer));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        int rc = JNI.mdbx_cursor_put(this.pointer(), keySlice, valueSlice, flags);
        if (((flags & JNI.MDBX_NOOVERWRITE) != 0 || (flags & JNI.MDBX_NODUPDATA) != 0) && rc == JNI.MDBX_KEYEXIST) {
            return valueSlice.toByteArray();
        }
        Util.checkErrorCode(this.env, rc);
        if (!valueSlices.isEmpty()) {
            this.db.deleteSecondaries(this.tx, keySlice, valueSlices);
        }
        this.db.putSecondaries(this.tx, keySlice, valueSlice);
        return valueSlice.toByteArray();
    }

    public void delete() {
        boolean hasSec = this.db.getSecondaries() != null;
        Entry entry = null;
        if (hasSec) {
            entry = this.get(CursorOp.GET_CURRENT);
        }
        int rc = JNI.mdbx_cursor_del(this.pointer(), 0);
        Util.checkErrorCode(this.env, rc);
        if (hasSec) {
            for (SecondaryDatabase secDb : this.db.getSecondaries()) {
                SecondaryDbConfig secConfig = (SecondaryDbConfig)secDb.getConfig();
                byte[] pKey = entry.getKey();
                byte[] secKey = secConfig.getKeyCreator().createSecondaryKey(secDb, pKey, entry.getValue());
                secDb.delete(this.tx, secKey, pKey);
            }
        }
    }

    public void deleteIncludingDups() {
        Util.checkErrorCode(this.env, JNI.mdbx_cursor_del(this.pointer(), JNI.MDBX_NODUPDATA));
    }

    public long count() {
        long[] rc = new long[1];
        Util.checkErrorCode(this.env, JNI.mdbx_cursor_count(this.pointer(), rc));
        return rc[0];
    }

    public Database getDatabase() {
        return this.db;
    }

    public Transaction getTransaction() {
        return this.tx;
    }
}

