/*
 * Decompiled with CFR 0.152.
 */
package com.castortech.mdbxjni;

import com.castortech.mdbxjni.Cursor;
import com.castortech.mdbxjni.CursorOp;
import com.castortech.mdbxjni.DatabaseConfig;
import com.castortech.mdbxjni.Entry;
import com.castortech.mdbxjni.EntryCount;
import com.castortech.mdbxjni.Env;
import com.castortech.mdbxjni.FlagState;
import com.castortech.mdbxjni.JNI;
import com.castortech.mdbxjni.MDBXException;
import com.castortech.mdbxjni.NativeBuffer;
import com.castortech.mdbxjni.NativeObject;
import com.castortech.mdbxjni.SecondaryCursor;
import com.castortech.mdbxjni.SecondaryDatabase;
import com.castortech.mdbxjni.SecondaryDbConfig;
import com.castortech.mdbxjni.Stat;
import com.castortech.mdbxjni.Transaction;
import com.castortech.mdbxjni.Util;
import com.castortech.mdbxjni.Value;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Database
extends NativeObject
implements Closeable {
    private final Env env;
    private final String name;
    private List<SecondaryDatabase> secondaries = null;

    Database(Env env, long self, String name) {
        super(self);
        this.env = env;
        this.name = name;
    }

    @Override
    public void close() {
        if (this.self != 0L) {
            JNI.mdbx_dbi_close(this.env.pointer(), this.self);
            this.self = 0L;
        }
    }

    public Stat stat() {
        Transaction tx = this.env.createTransaction();
        try {
            Stat stat = new Stat(this.stat(tx));
            return stat;
        }
        finally {
            tx.commit();
        }
    }

    public Stat stat(Transaction tx) {
        Util.checkArgNotNull(tx, "tx");
        JNI.MDBX_stat rc = new JNI.MDBX_stat();
        JNI.mdbx_dbi_stat(tx.pointer(), this.pointer(), rc, JNI.SIZEOF_STAT);
        return new Stat(rc);
    }

    public void drop(boolean delete) {
        Transaction tx = this.env.createTransaction();
        try {
            this.drop(tx, delete);
        }
        finally {
            tx.commit();
        }
    }

    public void drop(Transaction tx, boolean delete) {
        Util.checkArgNotNull(tx, "tx");
        JNI.mdbx_drop(tx.pointer(), this.pointer(), delete ? 1 : 0);
        if (delete) {
            this.self = 0L;
        }
    }

    public String getName() {
        return this.name;
    }

    public List<SecondaryDatabase> getSecondaries() {
        return this.secondaries;
    }

    public byte[] get(byte[] key) {
        Util.checkArgNotNull(key, "key");
        Transaction tx = this.env.createTransaction();
        try {
            byte[] byArray = this.get(tx, key);
            return byArray;
        }
        finally {
            tx.commit();
        }
    }

    public EntryCount getEx(byte[] key) {
        Util.checkArgNotNull(key, "key");
        Transaction tx = this.env.createTransaction();
        try {
            EntryCount entryCount = this.getEx(tx, key);
            return entryCount;
        }
        finally {
            tx.commit();
        }
    }

    public Entry getEqOrGE(byte[] key) {
        Util.checkArgNotNull(key, "key");
        Transaction tx = this.env.createTransaction();
        try {
            Entry entry = this.getEqOrGE(tx, key);
            return entry;
        }
        finally {
            tx.commit();
        }
    }

    public byte[] get(Transaction tx, byte[] key) {
        Util.checkArgNotNull(key, "key");
        if (tx == null) {
            return this.get(key);
        }
        Util.checkArgNotNull(tx, "tx");
        NativeBuffer keyBuffer = NativeBuffer.create(key);
        try {
            byte[] byArray = this.get(tx, keyBuffer);
            return byArray;
        }
        finally {
            keyBuffer.delete();
        }
    }

    public EntryCount getEx(Transaction tx, byte[] key) {
        Util.checkArgNotNull(key, "key");
        if (tx == null) {
            return this.getEx(key);
        }
        Util.checkArgNotNull(tx, "tx");
        NativeBuffer keyBuffer = NativeBuffer.create(key);
        try {
            EntryCount entryCount = this.getEx(tx, keyBuffer);
            return entryCount;
        }
        finally {
            keyBuffer.delete();
        }
    }

    public Entry getEqOrGE(Transaction tx, byte[] key) {
        Util.checkArgNotNull(key, "key");
        if (tx == null) {
            return this.getEqOrGE(key);
        }
        Util.checkArgNotNull(tx, "tx");
        NativeBuffer keyBuffer = NativeBuffer.create(key);
        try {
            Entry entry = this.getEqOrGE(tx, keyBuffer);
            return entry;
        }
        finally {
            keyBuffer.delete();
        }
    }

    private byte[] get(Transaction tx, NativeBuffer keyBuffer) {
        return this.get(tx, new Value(keyBuffer));
    }

    private EntryCount getEx(Transaction tx, NativeBuffer keyBuffer) {
        return this.getEx(tx, new Value(keyBuffer));
    }

    private Entry getEqOrGE(Transaction tx, NativeBuffer keyBuffer) {
        return this.getEqOrGE(tx, new Value(keyBuffer));
    }

    byte[] get(Transaction tx, Value key) {
        Value value = new Value();
        int rc = JNI.mdbx_get(tx.pointer(), this.pointer(), key, value);
        if (rc == JNI.MDBX_NOTFOUND) {
            return null;
        }
        Util.checkErrorCode(this.env, rc);
        return value.toByteArray();
    }

    EntryCount getEx(Transaction tx, Value key) {
        Value value = new Value();
        long[] valCnt = new long[1];
        int rc = JNI.mdbx_get_ex(tx.pointer(), this.pointer(), key, value, valCnt);
        if (rc == JNI.MDBX_NOTFOUND) {
            return null;
        }
        Util.checkErrorCode(this.env, rc);
        return new EntryCount(key.toByteArray(), value.toByteArray(), valCnt[0]);
    }

    Entry getEqOrGE(Transaction tx, Value key) {
        Value value = new Value();
        int rc = JNI.mdbx_get_equal_or_great(tx.pointer(), this.pointer(), key, value);
        if (rc == JNI.MDBX_NOTFOUND) {
            return null;
        }
        Util.checkErrorCode(this.env, rc);
        return new Entry(key.toByteArray(), value.toByteArray());
    }

    public byte[] put(byte[] key, byte[] value) {
        return this.put(key, value, 0);
    }

    public byte[] put(byte[] key, byte[] value, int flags) {
        Util.checkArgNotNull(key, "key");
        Transaction tx = this.env.createTransaction();
        try {
            byte[] byArray = this.put(tx, key, value, flags);
            return byArray;
        }
        finally {
            tx.commit();
        }
    }

    public byte[] put(Transaction tx, byte[] key, byte[] value) {
        return this.put(tx, key, value, 0);
    }

    public byte[] put(Transaction tx, byte[] key, byte[] value, int flags) {
        Util.checkArgNotNull(key, "key");
        Util.checkArgNotNull(value, "value");
        if (tx == null) {
            return this.put(key, value, flags);
        }
        Util.checkArgNotNull(tx, "tx");
        NativeBuffer keyBuffer = NativeBuffer.create(key);
        try {
            NativeBuffer valueBuffer = NativeBuffer.create(value);
            try {
                byte[] byArray = this.put(tx, keyBuffer, valueBuffer, flags);
                valueBuffer.delete();
                return byArray;
            }
            catch (Throwable throwable) {
                valueBuffer.delete();
                throw throwable;
            }
        }
        finally {
            keyBuffer.delete();
        }
    }

    private byte[] put(Transaction tx, NativeBuffer keyBuffer, NativeBuffer valueBuffer, int flags) {
        return this.put(tx, new Value(keyBuffer), new Value(valueBuffer), flags);
    }

    private byte[] put(Transaction tx, Value keySlice, Value valueSlice, int flags) {
        Util.checkSize(this.env, keySlice);
        if ((flags & JNI.MDBX_DUPSORT) != 0) {
            Util.checkSize(this.env, valueSlice);
        }
        boolean hasSec = this.getSecondaries() != null;
        HashSet<Value> valueSlices = new HashSet<Value>();
        if (hasSec && (flags & JNI.MDBX_NOOVERWRITE) == 0 && (flags & JNI.MDBX_NODUPDATA) == 0) {
            Throwable throwable = null;
            Object var8_10 = null;
            try (Cursor cursor = this.openCursor(tx);){
                byte[] key = keySlice.toByteArray();
                Entry entry = cursor.get(CursorOp.SET, key);
                if (entry != null) {
                    NativeBuffer valueBuffer = NativeBuffer.create(entry.getValue());
                    valueSlices.add(Value.create(valueBuffer));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        int rc = JNI.mdbx_put(tx.pointer(), this.pointer(), keySlice, valueSlice, flags);
        if (((flags & JNI.MDBX_NOOVERWRITE) != 0 || (flags & JNI.MDBX_NODUPDATA) != 0) && rc == JNI.MDBX_KEYEXIST) {
            return valueSlice.toByteArray();
        }
        if (rc != 0) {
            throw new MDBXException("put failed", rc);
        }
        if (!valueSlices.isEmpty()) {
            this.deleteSecondaries(tx, keySlice, valueSlices);
        }
        this.putSecondaries(tx, keySlice, valueSlice);
        return null;
    }

    protected void putSecondaries(Transaction tx, Value keySlice, Value valueSlice) {
        if (this.secondaries != null) {
            for (SecondaryDatabase secDb : this.secondaries) {
                SecondaryDbConfig secConfig = (SecondaryDbConfig)secDb.getConfig();
                byte[] pKey = keySlice.toByteArray();
                byte[] secKey = secConfig.getKeyCreator().createSecondaryKey(secDb, pKey, valueSlice.toByteArray());
                secDb.internalPut(tx, secKey, pKey);
            }
        }
    }

    public byte[] replace(byte[] key, byte[] value) {
        return this.replace(key, value, 0);
    }

    public byte[] replace(byte[] key, byte[] value, int flags) {
        Util.checkArgNotNull(key, "key");
        Transaction tx = this.env.createTransaction();
        try {
            byte[] byArray = this.replace(tx, key, value, flags);
            return byArray;
        }
        finally {
            tx.commit();
        }
    }

    public byte[] replace(Transaction tx, byte[] key, byte[] value) {
        return this.replace(tx, key, value, 0);
    }

    public byte[] replace(Transaction tx, byte[] key, byte[] value, int flags) {
        Util.checkArgNotNull(key, "key");
        Util.checkArgNotNull(value, "value");
        if (tx == null) {
            return this.replace(key, value, flags);
        }
        Util.checkArgNotNull(tx, "tx");
        NativeBuffer keyBuffer = NativeBuffer.create(key);
        try {
            NativeBuffer valueBuffer = NativeBuffer.create(value);
            try {
                byte[] byArray = this.replace(tx, keyBuffer, valueBuffer, flags);
                valueBuffer.delete();
                return byArray;
            }
            catch (Throwable throwable) {
                valueBuffer.delete();
                throw throwable;
            }
        }
        finally {
            keyBuffer.delete();
        }
    }

    private byte[] replace(Transaction tx, NativeBuffer keyBuffer, NativeBuffer valueBuffer, int flags) {
        return this.replace(tx, new Value(keyBuffer), new Value(valueBuffer), flags);
    }

    private byte[] replace(Transaction tx, Value keySlice, Value valueSlice, int flags) {
        Util.checkSize(this.env, keySlice);
        if ((flags & JNI.MDBX_DUPSORT) != 0) {
            Util.checkSize(this.env, valueSlice);
        }
        boolean hasSec = this.getSecondaries() != null;
        HashSet<Value> valueSlices = new HashSet<Value>();
        if (hasSec && (flags & JNI.MDBX_NOOVERWRITE) == 0 && (flags & JNI.MDBX_NODUPDATA) == 0) {
            Throwable throwable = null;
            Object var8_9 = null;
            try (Cursor cursor = this.openCursor(tx);){
                byte[] key = keySlice.toByteArray();
                Entry entry = cursor.get(CursorOp.SET, key);
                if (entry != null) {
                    NativeBuffer valueBuffer = NativeBuffer.create(entry.getValue());
                    valueSlices.add(Value.create(valueBuffer));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        NativeBuffer oldValBuffer = NativeBuffer.create((long)((double)valueSlice.iov_len * 1.5));
        try {
            Value oldValSlice = new Value(oldValBuffer);
            boolean didResize = false;
            int rc = 0;
            while ((rc = JNI.mdbx_replace(tx.pointer(), this.pointer(), keySlice, valueSlice, oldValSlice, flags)) == JNI.MDBX_RESULT_TRUE) {
                if (didResize) {
                    throw new MDBXException("put failed, falling into loop", rc);
                }
                didResize = true;
                oldValBuffer.delete();
                oldValBuffer = NativeBuffer.create(oldValSlice.iov_len);
            }
            if (rc != 0) {
                throw new MDBXException("put failed", rc);
            }
            if (!valueSlices.isEmpty()) {
                this.deleteSecondaries(tx, keySlice, valueSlices);
            }
            this.putSecondaries(tx, keySlice, valueSlice);
            byte[] byArray = oldValSlice.toByteArray();
            return byArray;
        }
        finally {
            oldValBuffer.delete();
        }
    }

    public boolean delete(byte[] key) {
        return this.delete(key, null);
    }

    public boolean delete(byte[] key, byte[] value) {
        Util.checkArgNotNull(key, "key");
        Transaction tx = this.env.createTransaction();
        try {
            boolean bl = this.delete(tx, key, value);
            return bl;
        }
        finally {
            tx.commit();
        }
    }

    public boolean delete(Transaction tx, byte[] key) {
        return this.delete(tx, key, null);
    }

    public boolean delete(Transaction tx, byte[] key, byte[] value) {
        Util.checkArgNotNull(tx, "tx");
        Util.checkArgNotNull(key, "key");
        if (tx == null) {
            return this.delete(key, value);
        }
        Util.checkArgNotNull(tx, "tx");
        NativeBuffer keyBuffer = NativeBuffer.create(key);
        try {
            NativeBuffer valueBuffer = NativeBuffer.create(value);
            try {
                boolean bl = this.delete(tx, keyBuffer, valueBuffer);
                if (valueBuffer != null) {
                    valueBuffer.delete();
                }
                return bl;
            }
            catch (Throwable throwable) {
                if (valueBuffer != null) {
                    valueBuffer.delete();
                }
                throw throwable;
            }
        }
        finally {
            keyBuffer.delete();
        }
    }

    private boolean delete(Transaction tx, NativeBuffer keyBuffer, NativeBuffer valueBuffer) {
        return this.delete(tx, new Value(keyBuffer), Value.create(valueBuffer));
    }

    private boolean delete(Transaction tx, Value keySlice, Value valueSlice) {
        HashSet<Value> valueSlices;
        block12: {
            Util.checkSize(this.env, keySlice);
            boolean hasSec = this.getSecondaries() != null;
            valueSlices = new HashSet<Value>();
            if (valueSlice == null && hasSec) {
                Throwable throwable = null;
                Object var7_9 = null;
                try (Cursor cursor = this.openCursor(tx);){
                    byte[] key = keySlice.toByteArray();
                    Entry entry = cursor.get(CursorOp.SET, key);
                    while (entry != null) {
                        NativeBuffer valueBuffer = NativeBuffer.create(entry.getValue());
                        valueSlices.add(Value.create(valueBuffer));
                        entry = this.getConfig(tx).isDupSort() ? cursor.get(CursorOp.NEXT_DUP, key, entry.getValue()) : null;
                    }
                    break block12;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            valueSlices.add(valueSlice);
        }
        int rc = JNI.mdbx_del(tx.pointer(), this.pointer(), keySlice, valueSlice);
        if (rc == JNI.MDBX_NOTFOUND) {
            return false;
        }
        Util.checkErrorCode(this.env, rc);
        this.deleteSecondaries(tx, keySlice, valueSlices);
        return true;
    }

    protected void deleteSecondaries(Transaction tx, Value keySlice, Set<Value> valueSlices) {
        if (this.secondaries != null) {
            for (SecondaryDatabase secDb : this.secondaries) {
                SecondaryDbConfig secConfig = (SecondaryDbConfig)secDb.getConfig();
                byte[] pKey = keySlice.toByteArray();
                for (Value valueSlice : valueSlices) {
                    byte[] secKey = secConfig.getKeyCreator().createSecondaryKey(secDb, pKey, valueSlice.toByteArray());
                    secDb.delete(tx, secKey, pKey);
                }
            }
        }
    }

    public Cursor openCursor(Transaction tx) {
        Util.checkArgNotNull(tx, "tx");
        long[] cursor = new long[1];
        Util.checkErrorCode(this.env, JNI.mdbx_cursor_open(tx.pointer(), this.pointer(), cursor));
        return new Cursor(this.env, cursor[0], tx, this);
    }

    public SecondaryCursor openSecondaryCursor(Transaction tx) {
        Util.checkArgNotNull(tx, "tx");
        long[] cursor = new long[1];
        Util.checkErrorCode(this.env, JNI.mdbx_cursor_open(tx.pointer(), this.pointer(), cursor));
        return new SecondaryCursor(this.env, cursor[0], tx, this);
    }

    public int getFlags() {
        Transaction tx = this.env.createTransaction();
        try {
            int n = this.getFlags(tx);
            return n;
        }
        finally {
            tx.commit();
        }
    }

    public int getFlags(Transaction tx) {
        long[] flags = new long[1];
        Util.checkErrorCode(this.env, JNI.mdbx_dbi_flags(tx.pointer(), this.pointer(), flags));
        return (int)flags[0];
    }

    public FlagState getFlagsState(Transaction tx) {
        long[] flags = new long[1];
        long[] state = new long[1];
        Util.checkErrorCode(this.env, JNI.mdbx_dbi_flags_ex(tx.pointer(), this.pointer(), flags, state));
        return new FlagState((int)flags[0], (int)state[0]);
    }

    public int getDupsortDepthMask(Transaction tx) {
        long[] mask = new long[1];
        Util.checkErrorCode(this.env, JNI.mdbx_dbi_dupsort_depthmask(tx.pointer(), this.pointer(), mask));
        return (int)mask[0];
    }

    public int getSequence(Transaction tx, long increment) {
        long[] res = new long[1];
        Util.checkErrorCode(this.env, JNI.mdbx_dbi_sequence(tx.pointer(), this.pointer(), res, increment));
        return (int)res[0];
    }

    public DatabaseConfig getConfig() {
        Transaction tx = this.env.createTransaction();
        try {
            DatabaseConfig databaseConfig = this.getConfig(tx);
            return databaseConfig;
        }
        finally {
            tx.commit();
        }
    }

    public DatabaseConfig getConfig(Transaction tx) {
        int flags = this.getFlags(tx);
        return new DatabaseConfig(flags);
    }

    void associate(Transaction tx, SecondaryDatabase secondary) {
        if (this.secondaries == null) {
            this.secondaries = new ArrayList<SecondaryDatabase>();
        }
        this.secondaries.add(secondary);
    }
}

